/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.OperateResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseDataAddMenuOperateServiceImpl
extends AbstractOperateService {
    private static final Log LOG = LogFactory.getLog(BaseDataAddMenuOperateServiceImpl.class);
    private final IDynamicMetadataApplicationService iDynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);

    @Override
    protected void doOperate() {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        String menuLocal = bo.getMenuLocal();
        if (HRStringUtils.isEmpty((String)menuLocal)) {
            return;
        }
        String sysExtAppId = this.iDynamicMetadataApplicationService.getOrCreateExtIsvAppId(menuLocal);
        AppMetadata metadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)sysExtAppId, (boolean)false);
        List appMenus = metadata.getAppMenus();
        Optional<AppMenuElement> appMenu = appMenus.stream().filter(menu -> HRStringUtils.equals((String)menu.getNumber(), (String)bo.getMenuLocalNumber())).findFirst();
        if (!appMenu.isPresent()) {
            return;
        }
        MetadataGenParam data = bo.getData();
        BaseParam baseParam = data.getBaseParam();
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)baseParam.getMetadataNumber());
        long count = appMenus.stream().filter(menu -> HRStringUtils.equals((String)menu.getFormId(), (String)formMetadata.getId())).count();
        if (count >= 1L) {
            return;
        }
        AppMenuElement appMenuElement = AppMetaServiceHelper.CreateBlankAppMenuElement();
        appMenuElement.setId(String.valueOf(DBServiceHelper.genGlobalLongId()));
        appMenuElement.setName(LocaleString.fromMap((Map)formMetadata.getName()));
        appMenuElement.setMenuType("page");
        String uuid = UUID.randomUUID().toString().replace("-", "");
        appMenuElement.setNumber(uuid.substring(0, 10));
        appMenuElement.setFormId(formMetadata.getId());
        appMenuElement.setFormNumber(baseParam.getMetadataNumber());
        appMenuElement.setFormName(formMetadata.getName().getLocaleValue());
        appMenuElement.setParentId(appMenu.get().getId());
        appMenuElement.setSeq(this.getSeq(appMenus, appMenu.get().getId()).shortValue());
        appMenuElement.setVectorImage("kdfont kdfont-tongyongtubiao5");
        appMenuElement.setIconShortcut("/icons/pc/application/tysj3_48_48.png");
        appMenuElement.setDescription(appMenuElement.getName());
        appMenuElement.setOpenType("MainNewTabPage");
        appMenuElement.setPermission(null);
        appMenuElement.setVisible("true");
        appMenuElement.setParameterType("ListShowParameter");
        appMenuElement.setCaption(formMetadata.getName());
        appMenus.add(appMenuElement);
        ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
        AppMetaServiceHelper.save((AppMetadata)metadata);
        ThreadCache.put((Object)"AppMetaDao.querySubApp.ignoreExtApp", (Object)"true");
    }

    private Short getSeq(List<AppMenuElement> appMenus, String parentMenuId) {
        Optional<Short> maxSeq = appMenus.stream().filter(menu -> HRStringUtils.equals((String)menu.getParentId(), (String)parentMenuId)).map(menu -> menu.getSeq()).sorted(Comparator.comparing(Short::intValue).reversed()).findFirst();
        if (maxSeq.isPresent()) {
            Short seq = maxSeq.get();
            if (seq >= Short.MAX_VALUE) {
                return (short)Short.MAX_VALUE;
            }
            return (short)(seq + 1);
        }
        return (short)1;
    }

    @Override
    public OperateResultBo rollback(String runParamStr) {
        return null;
    }
}

