/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.common.util.MetaFieldTypeUtils;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.PresetDataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class CadreFileMultiViewServiceImpl
extends AbstractOperateService {
    private static final Log LOG = LogFactory.getLog(CadreFileMultiViewServiceImpl.class);
    private static final String HSPM_MULTI_VIEW_CONFIG_EMP = "hspm_multiviewconfigemp";
    private static final String SOEBS_MULTI_VIEW_CONFIG = "soebs_multiviewconfig";
    private static final String FIELD_NUMBER = "field.number";
    private static final String FIELD_ID = "field.id";
    private static final String SELECT_COMMON_FIELDS = String.join((CharSequence)",", "id", "name", "number", "category", "group", "isedit", "isrequired", "max", "maxcount", "min", "precision", "refkey", "scale", "type");
    private final IBaseEntityService empMultiService = CommonEntityServiceFactory.getEntityService((String)"hspm_multiviewconfigemp");
    private final IBaseEntityService multiService = CommonEntityServiceFactory.getEntityService((String)"soebs_multiviewconfig");
    private final IBaseEntityService infoGroupFieldEntityService = CommonEntityServiceFactory.getEntityService((String)"soebs_infogroupfield");
    private Set<String> deleteFieldSet;
    private List<String> allFieldList;

    private void initData() {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        List fieldParamList = bo.getSourceData().getFieldParamList();
        this.deleteFieldSet = Sets.newHashSetWithExpectedSize((int)fieldParamList.size());
        this.allFieldList = Lists.newArrayListWithCapacity((int)fieldParamList.size());
        for (FieldParam fieldParam : fieldParamList) {
            String number = fieldParam.getNumber();
            if (fieldParam.isDelete()) {
                this.deleteFieldSet.add(number);
            }
            this.allFieldList.add(number);
        }
        List attlist = bo.getSourceData().getContainerParamList().stream().filter(containerParam -> FieldTypeEnum.ATTACHMENTPANEL.getType().equals(containerParam.getType())).collect(Collectors.toList());
        for (ContainerParam containerParam2 : attlist) {
            String number = containerParam2.getNumber();
            if (containerParam2.isDelete()) {
                this.deleteFieldSet.add(number);
            }
            this.allFieldList.add(number);
        }
    }

    @Override
    protected void doOperate() {
        this.initData();
        List registerPersonInfoList = (List)TaskRunContext.get().getContextValue("registerPersonInfo");
        if (CollectionUtils.isEmpty((Collection)registerPersonInfoList)) {
            LOG.info("ErFileMultiViewServiceImpl registerPersonInfo is empty");
            return;
        }
        Set<Long> infoGroupPageIds = registerPersonInfoList.stream().map(map -> this.getLongValue(map.get("id"))).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> groupIdAndInfoGroupFieldMap = this.queryInfoGroupFieldByGroupIds(infoGroupPageIds);
        PresetDataResultBo resultBo = new PresetDataResultBo();
        PresetDataResultBo empResultBo = new PresetDataResultBo();
        ArrayList<DynamicObject> multiViewConfigList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> empMultiViewConfigList = new ArrayList<DynamicObject>(10);
        for (Map info : registerPersonInfoList) {
            String bizType = (String)info.get("biztype");
            List<DynamicObject> infoGroupFields = groupIdAndInfoGroupFieldMap.get(this.getLongValue(info.get("id")));
            if ("1".equals(bizType)) {
                DynamicObject[] empMultiViewConfigs = this.generateMultiViewConfig(info, infoGroupFields, empResultBo);
                if (empMultiViewConfigs == null || empMultiViewConfigs.length <= 0) continue;
                empMultiViewConfigList.addAll(Arrays.asList(empMultiViewConfigs));
                continue;
            }
            DynamicObject[] multiViewConfigs = this.generateMultiViewConfig(info, infoGroupFields, resultBo);
            if (multiViewConfigs == null || multiViewConfigs.length <= 0) continue;
            multiViewConfigList.addAll(Arrays.asList(multiViewConfigs));
        }
        if (!CollectionUtils.isEmpty(empMultiViewConfigList)) {
            this.saveMultiViewConfigDyn(empMultiViewConfigList, empResultBo);
        }
        if (!CollectionUtils.isEmpty(multiViewConfigList)) {
            this.saveMultiViewConfigDyn(multiViewConfigList, resultBo);
        }
    }

    private DynamicObject[] generateMultiViewConfig(Map<String, Object> info, List<DynamicObject> infoGroupFields, PresetDataResultBo toolResultDataBo) {
        if (CollectionUtils.isEmpty(infoGroupFields)) {
            return null;
        }
        String bizType = (String)info.get("biztype");
        DynamicObject[] multiViewConfigs = this.getMultiViewConfigs(info, bizType);
        if (multiViewConfigs == null || multiViewConfigs.length == 0) {
            return null;
        }
        Map<String, DynamicObject> infoGroupFieldMap = infoGroupFields.stream().collect(Collectors.toMap(dy -> dy.getString("number"), dy -> dy, (k1, k2) -> k1));
        Set<Long> groupFieldSet = infoGroupFields.stream().map(dy -> dy.getLong("id")).collect(Collectors.toSet());
        String infoGroupPageRegisterId = info.get("id").toString();
        long[] entityIds = ID.genLongIds((int)multiViewConfigs.length);
        String extType = this.getRunParamStrByKey("exttype");
        PresetDataResultBo entryData = new PresetDataResultBo();
        for (int index = 0; index < multiViewConfigs.length; ++index) {
            DynamicObject multiViewConfig = multiViewConfigs[index];
            DynamicObjectCollection groupEntityCol = multiViewConfig.getDynamicObjectCollection("groupentity");
            DynamicObject dynamicObject = this.getGroupEntity(groupEntityCol, groupFieldSet, infoGroupPageRegisterId);
            boolean isNewGroup = false;
            if (dynamicObject != null) {
                entityIds[index] = dynamicObject.getLong("id");
            } else {
                isNewGroup = true;
                dynamicObject = this.buildGroupEntity(entityIds[index], infoGroupPageRegisterId, info, groupEntityCol);
            }
            if (!HRStringUtils.equals((String)extType, (String)"1")) {
                dynamicObject.set("groupname", info.get("name"));
            }
            DynamicObjectCollection fieldEntityCol = dynamicObject.getDynamicObjectCollection("fieldentity");
            this.removeFields(fieldEntityCol);
            int seq = MetaFieldTypeUtils.getSeq(fieldEntityCol);
            long[] subEntityIds = ID.genLongIds((int)this.allFieldList.size());
            PresetDataResultBo subEntryData = new PresetDataResultBo();
            Map<String, DynamicObject> fieldEntityMap = fieldEntityCol.stream().collect(Collectors.toMap(dy -> dy.getString(FIELD_NUMBER), dy -> dy, (k1, k2) -> k1));
            for (int idx = 0; idx < this.allFieldList.size(); ++idx) {
                DynamicObject field = infoGroupFieldMap.get(this.allFieldList.get(idx));
                if (this.filterField(field, info)) continue;
                DynamicObject fieldEntity = null;
                if (!isNewGroup) {
                    fieldEntity = fieldEntityMap.get(field.getString("number"));
                }
                if (fieldEntity == null) {
                    this.buildFieldEntity(subEntityIds[idx], field, seq++, fieldEntityCol);
                    continue;
                }
                subEntityIds[idx] = fieldEntity.getLong("id");
                this.setFiledValue(fieldEntity, field);
            }
            if (fieldEntityCol.isEmpty()) {
                long removeGroupId = dynamicObject.getLong("id");
                groupEntityCol.removeIf(dy -> dy.getLong("id") == removeGroupId);
            }
            subEntryData.setNumber("fieldentity");
            subEntryData.setIdList(Arrays.stream(subEntityIds).boxed().collect(Collectors.toList()));
            entryData.addSubData(subEntryData);
        }
        entryData.setIdList(Arrays.stream(entityIds).boxed().collect(Collectors.toList()));
        entryData.setNumber("groupentity");
        toolResultDataBo.addSubData(entryData);
        return multiViewConfigs;
    }

    private DynamicObject getGroupEntity(DynamicObjectCollection groupEntityCol, Set<Long> groupFieldSet, String infoGroupPageRegisterId) {
        Optional<DynamicObject> opDy = groupEntityCol.stream().filter(dy -> {
            String[] relationGroups;
            if (infoGroupPageRegisterId.equals(dy.getString("groupid"))) {
                return true;
            }
            String relationGroup = dy.getString("relation");
            if (HRStringUtils.isEmpty((String)relationGroup)) {
                return false;
            }
            if (relationGroup.equals(dy.getString("groupid"))) {
                return false;
            }
            for (String group : relationGroups = relationGroup.split(",")) {
                if (!infoGroupPageRegisterId.equals(group)) continue;
                return true;
            }
            return false;
        }).findFirst();
        if (opDy.isPresent()) {
            String groupId = opDy.get().getString("groupid");
            List subGroupEntityList = groupEntityCol.stream().filter(dy -> groupId.equals(dy.getString("parentgroupid"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(subGroupEntityList)) {
                return opDy.get();
            }
            for (DynamicObject subGroup : subGroupEntityList) {
                if (!subGroup.getDynamicObjectCollection("fieldentity").stream().anyMatch(entity -> groupFieldSet.contains(entity.getLong(FIELD_ID)))) continue;
                return subGroup;
            }
            return (DynamicObject)subGroupEntityList.get(0);
        }
        return null;
    }

    private void removeFields(DynamicObjectCollection fieldEntityCol) {
        if (CollectionUtils.isEmpty(this.deleteFieldSet)) {
            return;
        }
        fieldEntityCol.removeIf(fieldEntity -> this.deleteFieldSet.contains(fieldEntity.getString(FIELD_NUMBER)));
    }

    private boolean filterField(DynamicObject field, Map<String, Object> info) {
        if (field == null) {
            return true;
        }
        if ("description".equals(field.getString("number"))) {
            return true;
        }
        if (this.deleteFieldSet.contains(field.getString("number"))) {
            return true;
        }
        return HRStringUtils.isEmpty((String)((String)info.get("dialogpc"))) && "18".equals(field.getString("type"));
    }

    private DynamicObject buildGroupEntity(long id, String infoGroupPageRegisterId, Map<String, Object> info, DynamicObjectCollection groupEntityCol) {
        int seq = MetaFieldTypeUtils.getSeq(groupEntityCol);
        DynamicObject dynamicObject = groupEntityCol.addNew();
        dynamicObject.set("id", (Object)id);
        dynamicObject.set("groupid", (Object)infoGroupPageRegisterId);
        dynamicObject.set("relation", (Object)infoGroupPageRegisterId);
        dynamicObject.set("allisedit", (Object)Boolean.FALSE);
        dynamicObject.set("allisrequired", (Object)Boolean.FALSE);
        dynamicObject.set("allisaudit", (Object)Boolean.FALSE);
        dynamicObject.set("isallowadd", (Object)Boolean.FALSE);
        dynamicObject.set("seq", (Object)seq);
        dynamicObject.set("groupname", info.get("name"));
        String viewLocation = (String)info.get("viewlocation");
        if (HRStringUtils.isEmpty((String)viewLocation)) {
            viewLocation = "1";
        }
        dynamicObject.set("configarea", (Object)viewLocation);
        return dynamicObject;
    }

    private void buildFieldEntity(long id, DynamicObject field, int seq, DynamicObjectCollection fieldEntityCol) {
        DynamicObject fieldEntity = fieldEntityCol.addNew();
        fieldEntity.set("id", (Object)id);
        fieldEntity.set("field", (Object)field);
        fieldEntity.set("seq", (Object)seq);
        this.setFiledValue(fieldEntity, field);
        fieldEntity.set("isaudit", (Object)Boolean.FALSE);
        this.setFieldType(fieldEntity, field);
    }

    private void setFiledValue(DynamicObject fieldEntity, DynamicObject field) {
        fieldEntity.set("isedit", (Object)field.getBoolean("isedit"));
        fieldEntity.set("isrequired", (Object)field.getBoolean("isrequired"));
    }

    private void setFieldType(DynamicObject fieldEntity, DynamicObject field) {
        if ("18".equals(field.getString("type"))) {
            fieldEntity.set("fieldtype", (Object)"3");
        } else if ("12".equals(field.getString("type"))) {
            fieldEntity.set("fieldtype", (Object)"2");
        } else {
            fieldEntity.set("fieldtype", (Object)"1");
        }
    }

    private DynamicObject[] getMultiViewConfigs(Map<String, Object> info, String bizType) {
        IBaseEntityService baseEntityService;
        String fileName;
        if ("1".equals(bizType)) {
            fileName = "psfileviews";
            baseEntityService = this.empMultiService;
        } else {
            fileName = "mgfileviews";
            baseEntityService = this.multiService;
        }
        List list = (List)info.get(fileName);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return this.queryMultiViewConfigsByIdList(baseEntityService, list.stream().map(this::getLongValue).collect(Collectors.toSet()));
        }
        return null;
    }

    private void saveMultiViewConfigDyn(List<DynamicObject> multiViewConfigs, PresetDataResultBo toolResultDataBo) {
        String entityNumber = multiViewConfigs.get(0).getDataEntityType().getName();
        toolResultDataBo.setNumber(entityNumber);
        List<Object> idList = MetaFieldTypeUtils.save(multiViewConfigs.toArray(new DynamicObject[0]), this.getOperateResultBo());
        toolResultDataBo.setIdList(idList);
        this.getOperateResultBo().getDataResultBo().addPresetDataResultBo(toolResultDataBo);
    }

    private DynamicObject[] queryMultiViewConfigsByIdList(IBaseEntityService baseEntityService, Collection<Long> idList) {
        return baseEntityService.loadDynamicObjectArray(new QFilter("id", "in", idList).toArray());
    }

    private Long getLongValue(Object obj) {
        return obj instanceof Long ? (Long)obj : Long.valueOf(obj.toString());
    }

    private Map<Long, List<DynamicObject>> queryInfoGroupFieldByGroupIds(Collection<Long> groupId) {
        QFilter groupIdFilter = new QFilter("group", "in", groupId);
        DynamicObject[] infoGroupFields = this.infoGroupFieldEntityService.query(SELECT_COMMON_FIELDS, new QFilter[]{groupIdFilter});
        return Stream.of(infoGroupFields).collect(Collectors.groupingBy(dy -> dy.getLong("group.id")));
    }
}

