/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.util.MetaFieldTypeUtils;
import kd.hdtc.hrbm.business.domain.task.bo.PermRelateBo;
import kd.hdtc.hrbm.business.domain.task.impl.PresetDataOperateServiceImpl;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public abstract class CommonPermRelateDataServiceImpl
extends PresetDataOperateServiceImpl {
    private static final String ENTITY_NAME = "hrcs_permrelat";
    private static final String ENTITY_TYPE_ID = "entitytype.id";

    @Override
    protected String entityName() {
        return ENTITY_NAME;
    }

    protected List<DynamicObject> getDataEntityList(List<PermRelateBo> permRelateBoList) {
        ArrayList list = Lists.newArrayListWithCapacity((int)permRelateBoList.size());
        for (PermRelateBo relateBo : permRelateBoList) {
            DynamicObject permRelateEntityDy = this.entityService.generateEmptyDynamicObject();
            permRelateEntityDy.set("entitytype", (Object)MetaFieldTypeUtils.buildDy("bos_entityobject", relateBo.getEntityObjectId()));
            permRelateEntityDy.set("bizapp", (Object)MetaFieldTypeUtils.buildDy("bos_devportal_bizapp", relateBo.getAppId()));
            permRelateEntityDy.set("appcombo", (Object)relateBo.getAppId());
            permRelateEntityDy.set("mainpermitem", (Object)relateBo.getMainPermItemId());
            DynamicObjectCollection dynamicObjectCollection = permRelateEntityDy.getDynamicObjectCollection("entryentity");
            relateBo.getRelateEntryList().forEach(relateEntry -> {
                DynamicObject entry = dynamicObjectCollection.addNew();
                entry.set("entitytypeid", (Object)MetaFieldTypeUtils.buildDy("bos_entityobject", relateEntry.getEntityObjectId()));
                entry.set("app", (Object)MetaFieldTypeUtils.buildDy("bos_devportal_bizapp", relateEntry.getAppId()));
                entry.set("permitemid", (Object)relateEntry.getPermItemId());
                entry.set("permitem", (Object)relateEntry.getPermItemId());
                entry.set("issyspreset", (Object)Boolean.FALSE);
            });
            list.add(permRelateEntityDy);
        }
        return list;
    }

    @Override
    protected Map<String, DynamicObject> existDyMap(List<DynamicObject> dyList) {
        if (CollectionUtils.isEmpty(dyList)) {
            return Maps.newHashMapWithExpectedSize((int)0);
        }
        QFilter qFilter = new QFilter("entitytype", "in", dyList.stream().map(dy -> dy.getString(ENTITY_TYPE_ID)).collect(Collectors.toSet()));
        List existList = this.entityService.queryOriginalList("id,entitytype.id,mainpermitem", qFilter.toArray());
        return existList.stream().collect(Collectors.toMap(this::dyKey, dy -> dy));
    }

    @Override
    protected String dyKey(DynamicObject dy) {
        return dy.getString(ENTITY_TYPE_ID) + "," + dy.getString("mainpermitem");
    }
}

