/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.impl.PresetDataOperateServiceImpl;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class HCFRegOperateServiceImpl
extends PresetDataOperateServiceImpl {
    private static final Log LOG = LogFactory.getLog(HCFRegOperateServiceImpl.class);
    private static final String ENTITY_NAME = "hom_bdinfogroup";

    @Override
    protected String entityName() {
        return ENTITY_NAME;
    }

    @Override
    protected List<DynamicObject> getDataEntityList() {
        DynamicObject dy = this.entityService.generateEmptyDynamicObject();
        String metadataNumber = (String)TaskRunContext.get().getRunParamMap().get("logicEntityNumber");
        String metadataName = (String)TaskRunContext.get().getRunParamMap().get("logicEntityName");
        dy.set("number", (Object)metadataNumber);
        dy.set("enable", (Object)"1");
        dy.set("status", (Object)"C");
        dy.set("name", (Object)metadataName);
        dy.set("multipleentity", (Object)StringUtils.equals((String)this.getRunParamStrByKey("mulline"), (String)"true"));
        this.buildEntry(dy);
        return Lists.newArrayList((Object[])new DynamicObject[]{dy});
    }

    @Override
    protected Map<String, DynamicObject> existDyMap(List<DynamicObject> dyList) {
        QFilter qFilter = new QFilter("number", "in", dyList.stream().map(this::dyKey).collect(Collectors.toSet()));
        DynamicObject[] existArray = this.entityService.loadDynamicObjectArray(qFilter.toArray());
        return Arrays.stream(existArray).collect(Collectors.toMap(this::dyKey, dy -> dy));
    }

    @Override
    protected String dyKey(DynamicObject dy) {
        return dy.getString("number");
    }

    @Override
    protected void fillUpdateData(DynamicObject dy, DynamicObject dbDy) {
        DynamicObjectCollection dbEntryCol = dbDy.getDynamicObjectCollection("infogroupfield");
        DynamicObjectCollection infoGroupFieldCol = dy.getDynamicObjectCollection("infogroupfield");
        Map<String, DynamicObject> dbEntryMap = dbEntryCol.stream().collect(Collectors.toMap(prop -> prop.getString("fieldnumber"), prop -> prop));
        for (DynamicObject entryDy : infoGroupFieldCol) {
            String fieldNumber = entryDy.getString("fieldnumber");
            DynamicObject dbEntryDy = dbEntryMap.get(fieldNumber);
            if (dbEntryDy != null) {
                dbEntryDy.set("fieldname", entryDy.get("fieldname"));
                continue;
            }
            dbEntryCol.add((Object)entryDy);
        }
        dbDy.set("name", dy.get("name"));
    }

    private void buildEntry(DynamicObject dynamicObject) {
        List fieldParamList = (List)TaskRunContext.get().getRunParamMap().get("fieldList");
        DynamicObjectCollection entryCollection = dynamicObject.getDynamicObjectCollection("infogroupfield");
        for (Map fieldParam : fieldParamList) {
            DynamicObject entryDynamicObject = entryCollection.addNew();
            entryDynamicObject.set("approveshow", (Object)Boolean.TRUE);
            entryDynamicObject.set("listshow", (Object)Boolean.TRUE);
            entryDynamicObject.set("fieldnumber", fieldParam.get("number"));
            entryDynamicObject.set("fieldname", fieldParam.get("name"));
            entryDynamicObject.set("listshowfirstline", (Object)Boolean.TRUE);
            if (FieldTypeEnum.TEXTFIELD.getType().equals(fieldParam.get("type"))) {
                entryDynamicObject.set("fieldtype", (Object)"0");
            } else if (FieldTypeEnum.PICTUREFIELD.getType().equals(fieldParam.get("type"))) {
                entryDynamicObject.set("fieldtype", (Object)"1");
            } else if (FieldTypeEnum.ATTACHMENTFIELD.getType().equals(fieldParam.get("type"))) {
                entryDynamicObject.set("fieldtype", (Object)"2");
            } else {
                entryDynamicObject.set("fieldtype", (Object)"0");
            }
            entryDynamicObject.set("pageid", dynamicObject.get("number"));
        }
    }
}

