/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.impl.PresetDataOperateServiceImpl;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class HisModelRegOperateServiceImpl
extends PresetDataOperateServiceImpl {
    private static final Log LOG = LogFactory.getLog(HisModelRegOperateServiceImpl.class);
    private static final String ENTITY_NAME = "hrcs_appdefaultevent";
    private static final String ACTION_APP = "actionapp";
    private static final String ACTION_APP_ID = "actionapp.id";
    private static final String EVENT_ENTITY = "evententity";
    private final IBaseEntityService appService = CommonEntityServiceFactory.getEntityService((String)"bos_devportal_bizapp");

    @Override
    protected String entityName() {
        return ENTITY_NAME;
    }

    @Override
    protected List<DynamicObject> getDataEntityList() {
        DynamicObject dy = this.entityService.generateEmptyDynamicObject();
        dy.set(ACTION_APP, (Object)this.getActionApp());
        DynamicObject eventEntity = this.buildEventEntity();
        dy.set(EVENT_ENTITY, (Object)eventEntity);
        if (eventEntity == null) {
            LOG.info("not find source event entity");
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new DynamicObject[]{dy});
    }

    @Override
    protected Map<String, DynamicObject> existDyMap(List<DynamicObject> dyList) {
        QFilter qFilter = new QFilter(ACTION_APP, "in", dyList.stream().map(this::dyKey).collect(Collectors.toSet()));
        DynamicObject[] existArray = this.entityService.query("id,actionapp,evententity", qFilter.toArray());
        return Arrays.stream(existArray).collect(Collectors.toMap(this::dyKey, dy -> dy, (k1, k2) -> k1));
    }

    @Override
    protected String dyKey(DynamicObject dy) {
        return dy.getString(ACTION_APP_ID);
    }

    private DynamicObject buildEventEntity() {
        return this.getSourceEventEntity();
    }

    private DynamicObject getSourceEventEntity() {
        DynamicObject eventEntity = null;
        String sourceAppNumber = this.getRunParamStrByKey("appId");
        if (StringUtils.isEmpty((String)sourceAppNumber)) {
            return eventEntity;
        }
        DynamicObject appDy = this.getAppDyByNumber(sourceAppNumber);
        if (appDy == null) {
            return eventEntity;
        }
        QFilter qFilter = new QFilter(ACTION_APP, "=", (Object)appDy.getString("id"));
        DynamicObject entityDy = this.entityService.queryOne(EVENT_ENTITY, qFilter.toArray());
        if (entityDy != null) {
            eventEntity = entityDy.getDynamicObject(EVENT_ENTITY);
        }
        return eventEntity;
    }

    private DynamicObject getActionApp() {
        String extAppNumber = (String)TaskRunContext.get().getContextValue("extAppNumber");
        return this.getAppDyByNumber(extAppNumber);
    }

    private DynamicObject getAppDyByNumber(String number) {
        QFilter qFilter = new QFilter("number", "=", (Object)number);
        return this.appService.queryOne("id,number,bizcloud.id", qFilter.toArray());
    }
}

