/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.common.util.MetaFieldTypeUtils;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.PresetDataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.impl.PersonFilePermRelateServiceImpl;
import kd.hdtc.hrbm.common.enums.OnBrdPersonEnum;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class HomGroupDataOperateServiceImpl
extends AbstractOperateService {
    private static final Log LOG = LogFactory.getLog(PersonFilePermRelateServiceImpl.class);
    private static final String ENTITY_NAME = "hom_bdinfogroup";
    private static final String INFO_GROUP_FIELD = "infogroupfield";
    private static final String FIELD_NUMBER = "fieldnumber";
    private static final String FIELD_NAME = "fieldname";
    private static final String FIELD_TYPE = "fieldtype";
    private static final String APPROVE_SHOW = "approveshow";
    private static final String LIST_SHOW = "listshow";
    private static final String LIST_SHOW_FIRST_LINE = "listshowfirstline";
    private static final String PAGE_ID = "pageid";
    private final IBaseEntityService service = CommonEntityServiceFactory.getEntityService((String)"hom_bdinfogroup");

    @Override
    protected void doOperate() {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        MetadataGenParam metadataGenParam = bo.getData();
        List fieldParamList = metadataGenParam.getFieldParamList();
        if (CollectionUtils.isEmpty((Collection)fieldParamList)) {
            return;
        }
        DynamicObject[] dys = this.getGroupConfig(metadataGenParam);
        if (dys == null || dys.length == 0) {
            return;
        }
        String sourceEntityNumber = metadataGenParam.getBaseParam().getMetadataNumber();
        PresetDataResultBo resultBo = new PresetDataResultBo();
        resultBo.setNumber(ENTITY_NAME);
        for (DynamicObject dy : dys) {
            resultBo.addSubData(this.setEntry(dy, fieldParamList, sourceEntityNumber));
        }
        List<Object> pkList = MetaFieldTypeUtils.save(dys, this.getOperateResultBo());
        resultBo.setIdList(pkList);
        this.getOperateResultBo().getDataResultBo().addPresetDataResultBo(resultBo);
    }

    private PresetDataResultBo setEntry(DynamicObject dy, List<FieldParam> fieldParamList, String sourceEntityNumber) {
        DynamicObjectCollection col = dy.getDynamicObjectCollection(INFO_GROUP_FIELD);
        Map<String, DynamicObject> map = col.stream().collect(Collectors.toMap(dyn -> dyn.getString(FIELD_NUMBER), dyn -> dyn, (v1, v2) -> v2));
        long[] entityIds = ID.genLongIds((int)fieldParamList.size());
        int seq = MetaFieldTypeUtils.getSeq(col);
        fieldParamList = fieldParamList.stream().filter(param -> !param.isDelete()).collect(Collectors.toList());
        for (int index = 0; index < fieldParamList.size(); ++index) {
            FieldParam fieldParam = (FieldParam)fieldParamList.get(index);
            DynamicObject entry = map.get(fieldParam.getNumber());
            if (entry == null) {
                entry = col.addNew();
                entry.set("id", (Object)entityIds[index]);
                entry.set(APPROVE_SHOW, (Object)Boolean.FALSE);
                entry.set(LIST_SHOW, (Object)Boolean.FALSE);
                entry.set(FIELD_NUMBER, (Object)fieldParam.getNumber());
                entry.set(LIST_SHOW_FIRST_LINE, (Object)Boolean.FALSE);
                entry.set(PAGE_ID, (Object)sourceEntityNumber);
                entry.set("seq", (Object)seq++);
            } else {
                entityIds[index] = entry.getLong("id");
            }
            entry.set(FIELD_NAME, (Object)fieldParam.getName());
            entry.set(FIELD_TYPE, (Object)this.getFileType(fieldParam.getType()));
        }
        PresetDataResultBo entryData = new PresetDataResultBo();
        entryData.setIdList(Arrays.stream(entityIds).boxed().collect(Collectors.toList()));
        entryData.setNumber(INFO_GROUP_FIELD);
        return entryData;
    }

    private String getFileType(String type) {
        String fileType = FieldTypeEnum.PICTUREFIELD.getType().equals(type) ? "1" : (FieldTypeEnum.ATTACHMENTFIELD.getType().equals(type) ? "2" : "0");
        return fileType;
    }

    private DynamicObject[] getGroupConfig(MetadataGenParam metadataGenParam) {
        String sourceEntityNumber = metadataGenParam.getBaseParam().getMetadataNumber();
        OnBrdPersonEnum personEnum = OnBrdPersonEnum.getEnumByHcfNumber((String)sourceEntityNumber);
        if (personEnum == null) {
            throw new KDBizException("not find group number");
        }
        return this.service.loadDynamicObjectArray(new QFilter("number", "in", (Object)personEnum.getGroupNumber()).toArray());
    }
}

