/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import java.util.Collections;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.OperateResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;

public class MetadataGenerateOperateServiceImpl
extends AbstractOperateService {
    private static final Log LOG = LogFactory.getLog(MetadataGenerateOperateServiceImpl.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);

    @Override
    protected void doOperate() {
        MetadataGenParam metadataGenParam = this.buildMetadataGenParam(this.getRunParamStr());
        MetadataGenResult result = this.dynamicMetadataApplicationService.generate(metadataGenParam);
        if (!result.isSuccess()) {
            throw new HRDBSBizException(result.getThrowable(), new ErrorCode("hrdbs.metadataGenError", "hrdbs.metadataGenError"), new Object[0]);
        }
        this.getOperateResultBo().getDataResultBo().addMetadataResultBo(result.getEntityNumber(), result.getEntityId(), result.getVersionNumber());
        TaskRunContext.get().addContextValue(Collections.singletonMap("resultEntityNumber", result.getEntityNumber()));
    }

    private MetadataGenParam buildMetadataGenParam(String param) {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)param, RunParamBo.class);
        return bo.getData();
    }

    @Override
    public OperateResultBo rollback(String runParamStr) {
        return null;
    }
}

