/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropRelPropDomainService;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class PersonChangeTransactionServiceImpl
extends AbstractOperateService {
    private static final Log LOG = LogFactory.getLog(PersonChangeTransactionServiceImpl.class);
    private static final String IS_HCF = "isHcf";
    private static final String OPERATE_TYPE = "operateType";
    private static final String L4_NUMBER = "l4Number";
    private static final String EXT_META_NUM = "extMetaNum";
    private final ILogicEntityDomainService logicEntityDomainService = ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IPropRelPropDomainService propRelDomainService = ServiceFactory.getService(IPropRelPropDomainService.class);

    @Override
    protected void doOperate() {
        List<DynamicObject> propRelList;
        Object bizModelId = TaskRunContext.get().getRunParamMap().getOrDefault("bizModelId", 0L);
        String entryKey = (String)TaskRunContext.get().getRunParamMap().getOrDefault("entryKey", "");
        DynamicObject bizObject = this.logicEntityDomainService.getLogicEntityInfoById(bizModelId);
        if (bizObject != null && CollectionUtils.isNotEmpty(propRelList = this.propRelDomainService.getProRelByEntityIdAndRelType(bizObject.getLong("id"), "B1"))) {
            this.saveChangeTransactionData(bizObject, propRelList, entryKey);
        }
    }

    private void saveChangeTransactionData(DynamicObject logicEntity, List<DynamicObject> relList, String entryKey) {
        String extMetaNum;
        String l4Number;
        if (CollectionUtils.isEmpty(relList)) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        if (logicEntity.getBoolean("mainentity")) {
            l4Number = logicEntity.getString("number");
            extMetaNum = logicEntity.getString("extmetanum");
        } else {
            l4Number = logicEntity.getString("pid.number");
            extMetaNum = logicEntity.getString("pid.extmetanum");
        }
        Object l4NumberObj = this.getOperateBo().getOperateParamMap().get(L4_NUMBER);
        String isHcf = "0";
        if (l4NumberObj != null) {
            l4Number = String.valueOf(l4NumberObj);
            Object extMeatNumber = this.getOperateBo().getOperateParamMap().get(EXT_META_NUM);
            extMetaNum = extMeatNumber == null ? "" : String.valueOf(extMeatNumber);
            isHcf = "1";
        }
        params.put(IS_HCF, isHcf);
        params.put(L4_NUMBER, l4Number);
        params.put(EXT_META_NUM, extMetaNum);
        params.put("entityNumber", logicEntity.getString("number"));
        ArrayList list = new ArrayList(10);
        relList.forEach(data -> {
            String[] targetPropNumberSplit;
            HashMap<String, String> map = new HashMap<String, String>(4);
            map.put("sourceField", data.getString("sourceprop.propkey"));
            map.put(OPERATE_TYPE, data.getBoolean("sourceprop.deleted") ? "del" : "new");
            map.put("sourceEntry", entryKey);
            String targetPropNumber = data.getString("targetprop.number");
            String targetEntity = data.getString("targetprop.logicentity.number");
            if (!StringUtils.isEmpty((String)targetPropNumber) && (targetPropNumberSplit = targetPropNumber.split("\\.")).length > 1) {
                targetEntity = targetPropNumberSplit[0];
            }
            map.put("targetEntity", targetEntity);
            map.put("targetField", data.getString("targetprop.propkey"));
            list.add(map);
        });
        params.put("fileMapList", list);
        try {
            String info = (String)HRMServiceHelper.invokeHRService((String)"hpfs", (String)"HPFSFileMapManagerService", (String)"updateFileMapManager", (Object[])new Object[]{params});
            LOG.info("PersonChangeTransactionService  HPFSFileMapManagerService.updateFileMapManager result:{}", (Object)info);
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
    }
}

