/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.impl.PresetDataOperateServiceImpl;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;

public class PersonEntityRegOperateServiceImpl
extends PresetDataOperateServiceImpl {
    private static final String ENTITY_NAME = "hrpi_personentityconf";
    private static final String CLASSIFY = "classify";
    private static final String ENTITY = "entity";
    private static final String EXT_PL = "_extpl";
    private static final int PERSON_ENTITY_CONFIG_NUMBER_MAX_LENGTH = 20;
    private static final String HISTORY_TYPE = "historytype";
    private static final String HISTORY_TYPE_TIME = "time";
    private static final String HISTORY_TYPE_NONTIME = "nontime";

    @Override
    protected String entityName() {
        return ENTITY_NAME;
    }

    @Override
    protected List<DynamicObject> getDataEntityList() {
        DynamicObject dy = this.entityService.generateEmptyDynamicObject();
        String entityNumber = (String)TaskRunContext.get().getContextValue("resultEntityNumber");
        String entityName = EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName().getLocaleValue();
        String number = entityNumber + EXT_PL;
        number = number.length() > 20 ? number.substring(0, 20) : number;
        dy.set("name", (Object)entityName);
        dy.set("number", (Object)number);
        dy.set(CLASSIFY, (Object)this.getRunParamStrByKey(CLASSIFY));
        dy.set(HISTORY_TYPE, (Object)this.getHistoryType(entityNumber));
        dy.set(ENTITY, (Object)entityNumber);
        return Lists.newArrayList((Object[])new DynamicObject[]{dy});
    }

    private String getHistoryType(String entityNumber) {
        String type = HisModelController.getInstance().entityInhRelation(entityNumber);
        return "1".equals(type) ? HISTORY_TYPE_TIME : HISTORY_TYPE_NONTIME;
    }

    @Override
    protected Map<String, DynamicObject> existDyMap(List<DynamicObject> dyList) {
        QFilter qFilter = new QFilter(ENTITY, "in", dyList.stream().map(this::dyKey).collect(Collectors.toSet()));
        DynamicObject[] existArray = this.entityService.loadDynamicObjectArray(qFilter.toArray());
        return Arrays.stream(existArray).collect(Collectors.toMap(this::dyKey, dy -> dy));
    }

    @Override
    protected String dyKey(DynamicObject dy) {
        return dy.getString(ENTITY);
    }
}

