/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.ErrorCode;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FormPluginParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public abstract class PersonInfoMetadataServiceImpl
extends AbstractOperateService {
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private MetadataGenParam sourceParam;

    @Override
    protected void doOperate() {
        String modelEntityNumber = this.getRunParamStrByKey("modelEntityNumber");
        String entityNumber = modelEntityNumber.toLowerCase().replace("hrpi", "hspm");
        String metaEntityNumber = this.getMetaEntityNumber(entityNumber);
        String metaEntityName = EntityMetadataCache.getDataEntityType((String)modelEntityNumber).getDisplayName().getLocaleValue();
        MetadataGenParam metadataGenParam = this.getMetadataGenParam(metaEntityNumber, metaEntityName, modelEntityNumber);
        this.fillAttribute(metadataGenParam);
        MetadataGenResult result = this.dynamicMetadataApplicationService.generate(metadataGenParam);
        if (!result.isSuccess()) {
            throw new HRDBSBizException(result.getThrowable(), new ErrorCode("hrdbs.metadataGenError", "hrdbs.metadataGenError"), new Object[0]);
        }
        this.getOperateResultBo().getDataResultBo().addMetadataResultBo(result.getEntityNumber(), result.getEntityId(), result.getVersionNumber());
        String contextKey = this.getAddContextKey();
        if (!StringUtils.isEmpty((String)contextKey)) {
            TaskRunContext.get().addContextValue(Collections.singletonMap(contextKey, result.getEntityNumber()));
        }
    }

    protected abstract String getMetaEntityNumber(String var1);

    protected abstract String getBizUnitId();

    protected abstract String getPlugins();

    protected abstract String getParentFilePage();

    protected String getAddContextKey() {
        return null;
    }

    protected String getFilePluginParam() {
        return null;
    }

    protected boolean addModelFieldFlag() {
        return false;
    }

    protected boolean addCardContainerFlag() {
        return false;
    }

    protected void fillAttribute(MetadataGenParam metadataGenParam) {
    }

    private MetadataGenParam getMetadataGenParam(String metaDataNumber, String metaDataName, String entityNumber) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataName(metaDataName);
        baseParam.setMetadataNumber(metaDataNumber);
        FormMetadata parentFormMetadata = MetadataUtils.getFormMetadataByNumber((String)this.getParentFilePage());
        baseParam.setModelType(parentFormMetadata.getModelType());
        baseParam.setParentId(parentFormMetadata.getEntityId());
        baseParam.setBizUnitId(this.getBizUnitId());
        baseParam.setAppId("hspm");
        baseParam.setType(MetadataGenTypeEnum.NORMAL_METADATA);
        MetadataGenParam sourceParam = this.getSourceParam();
        List<Object> containerList = Lists.newArrayListWithCapacity((int)10);
        if (CollectionUtils.isNotEmpty((Collection)sourceParam.getContainerParamList())) {
            containerList = sourceParam.getContainerParamList().stream().filter(containerParam -> FieldTypeEnum.ATTACHMENTPANEL.getType().equals(containerParam.getType())).collect(Collectors.toList());
        }
        if (this.addModelFieldFlag()) {
            List metadataBoItems = sourceParam.getFieldParamList();
            metadataBoItems.forEach(fieldParam -> {
                fieldParam.setContainerNumber("fieldspermflex");
                metadataGenParam.getFieldParamList().add(fieldParam);
            });
            if (CollectionUtils.isNotEmpty((Collection)containerList)) {
                containerList.forEach(ap -> {
                    FieldParam fieldParam = this.getAttachmentFieldParam((ContainerParam)ap);
                    metadataGenParam.getFieldParamList().add(fieldParam);
                });
            }
        }
        String pluginParam = this.getPlugins();
        String filePluginParam = this.getFilePluginParam();
        if (this.addCardContainerFlag()) {
            String containerNumber = "contentap" + entityNumber.substring(entityNumber.lastIndexOf(95) + 1);
            ContainerParam containerParam1 = this.getContainerParam(containerNumber);
            metadataGenParam.getContainerParamList().add(containerParam1);
        }
        if (StringUtils.isNotEmpty((String)filePluginParam)) {
            pluginParam = filePluginParam;
        }
        if (StringUtils.isNotEmpty((String)pluginParam)) {
            String[] plugins = pluginParam.split(";");
            ArrayList formPluginParamList = Lists.newArrayListWithExpectedSize((int)plugins.length);
            for (String plugin : plugins) {
                FormPluginParam formPluginParam = new FormPluginParam();
                formPluginParam.setClassName(plugin);
                formPluginParam.setDescription(plugin);
                formPluginParam.setEnable(Boolean.TRUE);
                formPluginParamList.add(formPluginParam);
            }
            metadataGenParam.setFormPluginParamList((List)formPluginParamList);
        }
        return metadataGenParam;
    }

    private FieldParam getAttachmentFieldParam(ContainerParam ap) {
        FieldParam fieldParam = new FieldParam();
        fieldParam.setName(ap.getName());
        fieldParam.setNumber(ap.getNumber());
        HashMap fieldRuleMap = Maps.newHashMapWithExpectedSize((int)1);
        fieldRuleMap.put("MustInput", 0);
        fieldParam.setFieldRuleMap((Map)fieldRuleMap);
        fieldParam.setType(AttachmentField.class.getSimpleName());
        fieldParam.setContainerNumber("fieldspermflex");
        return fieldParam;
    }

    private ContainerParam getContainerParam(String containerNumber) {
        String containerName = ResManager.loadKDString((String)"\u5185\u5bb9\u533a", (String)"AbstractMetadataServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]);
        ContainerParam containerParam1 = new ContainerParam();
        containerParam1.setName(containerName);
        containerParam1.setNumber(containerNumber);
        containerParam1.setType("FlexPanelAp");
        containerParam1.setIndex(3);
        containerParam1.setCollapsible(false);
        return containerParam1;
    }

    protected final MetadataGenParam getSourceParam() {
        if (this.sourceParam == null) {
            RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
            this.sourceParam = bo.getSourceData();
        }
        return this.sourceParam;
    }
}

