/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.model.plugin.AbstractModelOperater;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.MetadataDataResultBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.tools.impl.MassMaintenanceNumberGenerateDomainServiceImpl;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;

public class PersonMassMaintPresetServiceImpl
extends AbstractOperateService {
    private static final String HSPM_INFO_CLASSIFY_RELATE_PANEL_BIZ_UNIT_ID = "3AFH/LKOBE6L";
    private static final String PARENT_FILE_PAGE = "2=G599BNQBH1";
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);

    @Override
    protected void doOperate() {
        String modelEntityNumber = this.getRunParamStrByKey("modelEntityNumber");
        MassMaintenanceNumberGenerateDomainServiceImpl numberGenerateDomainService = new MassMaintenanceNumberGenerateDomainServiceImpl();
        Map<String, Map<String, String>> numberMap = numberGenerateDomainService.generateMulBySourceNumber((Set<String>)ImmutableSet.of((Object)modelEntityNumber));
        Map<String, String> currentNumberMap = numberMap.get(modelEntityNumber);
        String tabNumber = currentNumberMap.get("tab");
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)modelEntityNumber);
        MetadataGenParam relatePanelSetMetadataGenParam = this.buildMetadataGenParam(tabNumber, mainType.getDisplayName().getLocaleValue());
        MetadataGenResult result = this.dynamicMetadataApplicationService.generate(relatePanelSetMetadataGenParam);
        this.getOperateResultBo().getDataResultBo().addMetadataDataResultBoList(new MetadataDataResultBo(result.getEntityId(), tabNumber));
        TaskRunContext.get().addContextValue(Collections.singletonMap("massMaintenanceTabNumber", tabNumber));
    }

    private MetadataGenParam buildMetadataGenParam(String metaDataNumber, String sourceEntityName) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataName(this.getEntityName(sourceEntityName));
        baseParam.setMetadataNumber(metaDataNumber);
        baseParam.setParentId(PARENT_FILE_PAGE);
        baseParam.setBizUnitId(HSPM_INFO_CLASSIFY_RELATE_PANEL_BIZ_UNIT_ID);
        baseParam.setModelType(AbstractModelOperater.OBJECT_TYPE.DynamicFormModel.name());
        baseParam.setAppId("hspm");
        baseParam.setType(MetadataGenTypeEnum.NORMAL_METADATA);
        return metadataGenParam;
    }

    private String getEntityName(String sourceEntityName) {
        return ResManager.loadKDString((String)"%s\u9875\u7b7e", (String)"PersonMassMaintPresetServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[]{sourceEntityName});
    }
}

