/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.DataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.MetadataDataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.tools.impl.MassMaintenanceNumberGenerateDomainServiceImpl;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicQueryApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.pojo.query.QueryList;
import kd.hdtc.hrdbs.common.pojo.query.RelationCondition;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class PersonMassMaintQueryServiceImpl
extends AbstractOperateService {
    private static final String HSPM_INFO_CLASSIFY_QUERY_LIST_PLUGINS = "kd.hr.hbp.formplugin.web.newhismodel.HisCommonListPlugin;kd.sdk.hr.hspm.formplugin.infoclassify.ext.InfoClassifyExtListPlugin;kd.hr.hbp.formplugin.web.template.HRHiesButtonSwitchPlugin";
    private static final String HSPM_INFO_CLASSIFY_QUERY_LIST_BIZ_UNIT_ID = "3AFH/LKOBE6L";
    private static final String HSPM_INFO_CLASSIFY_COPY_LIST_NUMBER = "hspm_massmglist_ext";
    private final List<String> relEntityList = Arrays.asList("hrpi_empentrel", "hrpi_empposorgrel", "hspm_ermanfile", "hrpi_person");
    private final List<Supplier<List<RelationCondition>>> supplierList = Arrays.asList(this::buildEmpConditionList, this::buildEmpPosConditionList, this::buildErmFileConditionList, this::buildPersonConditionList);
    private final IDynamicQueryApplicationService dynamicQueryApplicationService = (IDynamicQueryApplicationService)ServiceFactory.getService(IDynamicQueryApplicationService.class);
    private final IMetadataEntityService metadataEntityService = (IMetadataEntityService)ServiceFactory.getService(IMetadataEntityService.class);
    private final IBaseEntityService entityService = CommonEntityServiceFactory.getEntityService((String)"bos_entityobject");
    private DynamicObject sourceData;
    private String queryNumber;
    private String listNumber;

    private void initData() {
        String modelEntityNumber = this.getRunParamStrByKey("modelEntityNumber");
        MassMaintenanceNumberGenerateDomainServiceImpl numberGenerateDomainService = new MassMaintenanceNumberGenerateDomainServiceImpl();
        Map<String, Map<String, String>> numberMap = numberGenerateDomainService.generateMulBySourceNumber((Set<String>)ImmutableSet.of((Object)modelEntityNumber));
        Map<String, String> currentNumberMap = numberMap.get(modelEntityNumber);
        this.queryNumber = currentNumberMap.get("query");
        this.listNumber = currentNumberMap.get("list");
        String formNumber = (String)TaskRunContext.get().getContextValue("massMaintenanceEntityNumber");
        this.sourceData = this.entityService.queryOne(String.join((CharSequence)",", "id", "name", "number"), new QFilter("number", "=", (Object)formNumber).toArray());
        if (this.sourceData == null) {
            throw new HDTCBizException("this number con not find object");
        }
    }

    @Override
    protected void doOperate() {
        this.initData();
        QueryGenResult result = this.dynamicQueryApplicationService.generatePlatformQuery(this.buildGenParam());
        DataResultBo resultBo = this.getOperateResultBo().getDataResultBo();
        DynamicObject queryDy = this.entityService.queryOne("id,enableimport", new QFilter("id", "=", (Object)this.queryNumber).toArray());
        if (queryDy != null) {
            queryDy.set("enableimport", (Object)"1");
            this.entityService.save(queryDy);
        }
        resultBo.addMetadataDataResultBoList(new MetadataDataResultBo(result.getQueryId(), this.queryNumber));
        resultBo.addMetadataDataResultBoList(new MetadataDataResultBo(result.getQueryListId(), this.listNumber));
        TaskRunContext.get().addContextValue(this.getEntityMap(this.queryNumber, this.listNumber));
    }

    private Map<String, Object> getEntityMap(String queryNumber, String listNumber) {
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)3);
        entityMap.put("massMaintenanceQueryNumber", queryNumber);
        entityMap.put("massMaintenanceListNumber", listNumber);
        return entityMap;
    }

    private QueryGenParam buildGenParam() {
        String formNumber = (String)TaskRunContext.get().getContextValue("massMaintenanceEntityNumber");
        QueryGenParam queryGenParam = new QueryGenParam();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)"hspm");
        queryGenParam.setAppId(appId);
        queryGenParam.setNumber(this.queryNumber);
        queryGenParam.setName(this.buildQueryName());
        queryGenParam.setMainEntity(this.buildMainEntity());
        queryGenParam.setQueryList(this.buildQueryList());
        queryGenParam.setUnit(HSPM_INFO_CLASSIFY_QUERY_LIST_BIZ_UNIT_ID);
        queryGenParam.setSubQueryEntityList(this.buildSubQueryEntityList());
        queryGenParam.setQueryFieldList(this.buildQueryFieldList(queryGenParam));
        this.buildOps(queryGenParam, this.metadataEntityService.getDesignMetadata(formNumber));
        return queryGenParam;
    }

    private String buildQueryName() {
        return ResManager.loadKDString((String)"%s\u67e5\u8be2", (String)"PersonMassMaintenanceQueryHandler_0", (String)"hdtc-hrbm-business", (Object[])new Object[]{this.sourceData.getString("name")});
    }

    private void buildOps(QueryGenParam queryGenParam, Map<String, Object> sourceMetaData) {
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List editParamList = sourceDesignMetadataParser.getEntityMetadata();
        queryGenParam.setEntityOperationList((List)((Map)editParamList.get(0)).get("Operations"));
        queryGenParam.setPermissionItemsList((List)((Map)editParamList.get(0)).get("PermissionItems"));
    }

    private QueryList buildQueryList() {
        QueryList queryList = new QueryList();
        queryList.setListName(this.sourceData.getString("name"));
        queryList.setListNumber(this.listNumber);
        queryList.setRelQueryListNumber(HSPM_INFO_CLASSIFY_COPY_LIST_NUMBER);
        queryList.cancelClearFilter();
        queryList.setPluginList(Arrays.asList(HSPM_INFO_CLASSIFY_QUERY_LIST_PLUGINS.split(";")));
        return queryList;
    }

    private QueryEntity buildMainEntity() {
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setNumber(this.sourceData.getString("number"));
        queryEntity.setName(this.sourceData.getString("name"));
        queryEntity.setAlias(this.sourceData.getString("number"));
        return queryEntity;
    }

    private List<QueryEntity> buildSubQueryEntityList() {
        ArrayList list = Lists.newArrayListWithCapacity((int)this.relEntityList.size());
        int index = 0;
        for (String relEntity : this.relEntityList) {
            QueryEntity entity = this.buildQueryEntity(relEntity);
            entity.setRelationConditionList(this.supplierList.get(index).get());
            list.add(entity);
            ++index;
        }
        return list;
    }

    private void setQueryEntityByNumber(QueryField queryField, QueryGenParam queryGenParam, String number) {
        int index = 0;
        for (String relEntity : this.relEntityList) {
            String subNumber = number.replace(relEntity + ".", "");
            if (subNumber.length() != number.length()) {
                queryField.setFieldNumber(subNumber);
                queryField.setQueryEntity((QueryEntity)queryGenParam.getSubQueryEntityList().get(index));
                return;
            }
            ++index;
        }
        queryField.setFieldNumber(number);
        queryField.setQueryEntity(queryGenParam.getMainEntity());
    }

    private QueryEntity buildQueryEntity(String number) {
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setNumber(number);
        MainEntityType empType = EntityMetadataCache.getDataEntityType((String)number);
        queryEntity.setName(empType.getDisplayName().getLocaleValue());
        queryEntity.setAlias(number);
        return queryEntity;
    }

    private List<RelationCondition> buildPersonConditionList() {
        RelationCondition condition1 = this.buildConditionList("person", ResManager.loadKDString((String)"\u59d3\u540d(person)", (String)"PersonMassMaintenanceQueryHandler_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]), "hrpi_person.id", ResManager.loadKDString((String)"HR\u4eba\u5458\u4fe1\u606f.\u4eba\u5458(hrpi_person.id)", (String)"PersonMassMaintenanceQueryHandler_9", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        RelationCondition condition2 = this.buildConditionList("hrpi_person.iscurrentversion", ResManager.loadKDString((String)"HR\u4eba\u5458\u4fe1\u606f.\u662f\u5426\u5f53\u524d\u7248\u672c(hrpi_person.iscurrentversion)", (String)"PersonMassMaintenanceQueryHandler_10", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        RelationCondition condition3 = this.buildConditionList("hrpi_person.datastatus", ResManager.loadKDString((String)"HR\u4eba\u5458\u4fe1\u606f.\u6570\u636e\u7248\u672c\u72b6\u6001(hrpi_person.datastatus)", (String)"PersonMassMaintenanceQueryHandler_11", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        return Lists.newArrayList((Object[])new RelationCondition[]{condition1, condition2, condition3});
    }

    private List<RelationCondition> buildErmFileConditionList() {
        RelationCondition condition1 = this.buildConditionList("person", ResManager.loadKDString((String)"\u59d3\u540d(person)", (String)"PersonMassMaintenanceQueryHandler_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]), "hspm_ermanfile.person", ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848.\u4eba\u5458(hspm_ermanfile.person)", (String)"PersonMassMaintenanceQueryHandler_7", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        RelationCondition condition2 = this.buildConditionList("hspm_ermanfile.iscurrentversion", ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848.\u662f\u5426\u5f53\u524d\u7248\u672c(hspm_ermanfile.iscurrentversion)", (String)"PersonMassMaintenanceQueryHandler_8", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        RelationCondition condition3 = this.buildConditionList("hspm_ermanfile.datastatus", ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848.\u6570\u636e\u7248\u672c\u72b6\u6001(hspm_ermanfile.datastatus)", (String)"PersonMassMaintenanceQueryHandler_14", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        return Lists.newArrayList((Object[])new RelationCondition[]{condition1, condition2, condition3});
    }

    private List<RelationCondition> buildEmpPosConditionList() {
        RelationCondition condition1 = this.buildConditionList("person", ResManager.loadKDString((String)"\u59d3\u540d(person)", (String)"PersonMassMaintenanceQueryHandler_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]), "hrpi_empposorgrel.person", ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u57fa\u7840\u9875\u9762.\u4eba\u5458(hrpi_empposorgrel.person)", (String)"PersonMassMaintenanceQueryHandler_5", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        RelationCondition condition2 = this.buildConditionList("hrpi_empposorgrel.iscurrentversion", ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u57fa\u7840\u9875\u9762.\u662f\u5426\u5f53\u524d\u7248\u672c(hrpi_empposorgrel.iscurrentversion)", (String)"PersonMassMaintenanceQueryHandler_6", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        RelationCondition condition3 = this.buildConditionList("hrpi_empposorgrel.datastatus", ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u57fa\u7840\u9875\u9762.\u6570\u636e\u7248\u672c\u72b6\u6001(hrpi_empposorgrel.datastatus)", (String)"PersonMassMaintenanceQueryHandler_13", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        return Lists.newArrayList((Object[])new RelationCondition[]{condition1, condition2, condition3});
    }

    private List<RelationCondition> buildEmpConditionList() {
        RelationCondition condition1 = this.buildConditionList("person", ResManager.loadKDString((String)"\u59d3\u540d(person)", (String)"PersonMassMaintenanceQueryHandler_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]), "hrpi_empentrel.person", ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f\u57fa\u7840\u9875\u9762.\u4eba\u5458(hrpi_empentrel.person)", (String)"PersonMassMaintenanceQueryHandler_2", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        RelationCondition condition2 = this.buildConditionList("hrpi_empentrel.iscurrentversion", ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f\u57fa\u7840\u9875\u9762.\u662f\u5426\u5f53\u524d\u7248\u672c(hrpi_empentrel.iscurrentversion)", (String)"PersonMassMaintenanceQueryHandler_3", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        RelationCondition condition3 = this.buildConditionList("hrpi_empentrel.businessstatus", ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f\u57fa\u7840\u9875\u9762.\u4e1a\u52a1\u72b6\u6001", (String)"PersonMassMaintenanceQueryHandler_4", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        RelationCondition condition4 = this.buildConditionList("hrpi_empentrel.datastatus", ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f\u57fa\u7840\u9875\u9762.\u6570\u636e\u7248\u672c\u72b6\u6001(hrpi_empentrel.datastatus)", (String)"PersonMassMaintenanceQueryHandler_12", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        RelationCondition condition5 = this.buildConditionList("hrpi_empentrel.islatestrecord", ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f\u57fa\u7840\u9875\u9762.\u662f\u5426\u6700\u65b0\u804c\u4e1a\u4fe1\u606f(hrpi_empentrel.islatestrecord)", (String)"PersonMassMaintenanceQueryHandler_15", (String)"hdtc-hrbm-business", (Object[])new Object[0]), null, null);
        return Lists.newArrayList((Object[])new RelationCondition[]{condition1, condition2, condition3, condition4, condition5});
    }

    private RelationCondition buildConditionList(String mainEntityProp, String mainEntityPropName, String subEntityProp, String subEntityPropName) {
        RelationCondition relationCondition = new RelationCondition();
        relationCondition.setMainEntityProp(mainEntityProp);
        relationCondition.setMainEntityPropName(mainEntityPropName);
        if (StringUtils.isEmpty((String)subEntityProp)) {
            relationCondition.setSubEntityProp("'1'");
            relationCondition.setSubEntityPropName("'1'");
            return relationCondition;
        }
        relationCondition.setSubEntityProp(subEntityProp);
        relationCondition.setSubEntityPropName(subEntityPropName);
        return relationCondition;
    }

    private List<FieldParam> getSourceFields() {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        return bo.getSourceData().getFieldParamList().stream().filter(field -> !field.isDelete() && !FieldTypeEnum.MULBASEDATAFIELD.getType().equals(field.getType())).collect(Collectors.toList());
    }

    private List<QueryField> buildQueryFieldList(QueryGenParam queryGenParam) {
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        List<Map<String, Object>> fieldNodeList = this.getTemplateField();
        int index = 0;
        for (Map<String, Object> fieldMap : fieldNodeList) {
            QueryField queryField = new QueryField();
            queryField.setHyperLink("true".equals(String.valueOf(fieldMap.get("Hyperlink"))));
            queryField.setFieldName((String)fieldMap.get("Name"));
            this.setQueryEntityByNumber(queryField, queryGenParam, (String)fieldMap.get("ListFieldId"));
            list.add(queryField);
            if (index != 0 || !"3".equals(String.valueOf(fieldMap.get("Index")))) continue;
            ++index;
            this.addSourceField(queryGenParam, list);
        }
        return list;
    }

    private List<Map<String, Object>> getTemplateField() {
        Map sourceMetaData = this.metadataEntityService.getDesignMetadata(HSPM_INFO_CLASSIFY_COPY_LIST_NUMBER);
        DesignMetadataParser sourceDataDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List formNodeList = sourceDataDesignMetadataParser.getFormMetadata();
        return formNodeList.stream().filter(node -> node.containsKey("ListFieldId")).collect(Collectors.toList());
    }

    private void addSourceField(QueryGenParam queryGenParam, List<QueryField> list) {
        List<FieldParam> fieldParamList = this.getSourceFields();
        for (FieldParam param : fieldParamList) {
            QueryField queryField = new QueryField();
            queryField.setFieldName(param.getName());
            if (FieldTypeEnum.BASEDATAFIELD.getType().equals(param.getType())) {
                queryField.setFieldNumber(param.getNumber() + "." + "name");
            } else {
                queryField.setFieldNumber(param.getNumber());
            }
            queryField.setQueryEntity(queryGenParam.getMainEntity());
            list.add(queryField);
        }
    }
}

