/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrbm.business.common.util.MetaFieldTypeUtils;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.PresetDataResultBo;
import kd.hdtc.hrbm.common.enums.OperateExistRuleEnum;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;

public abstract class PresetDataOperateServiceImpl
extends AbstractOperateService {
    private static final Log LOG = LogFactory.getLog(PresetDataOperateServiceImpl.class);
    private static final Set<String> IGNORE_KEY_SET = Sets.newHashSet((Object[])new String[]{"id", "boid"});
    protected IBaseEntityService entityService;

    protected abstract String entityName();

    protected abstract List<DynamicObject> getDataEntityList();

    protected abstract Map<String, DynamicObject> existDyMap(List<DynamicObject> var1);

    protected abstract String dyKey(DynamicObject var1);

    protected boolean callOpFlag() {
        return true;
    }

    @Override
    protected void doOperate() {
        this.entityService = CommonEntityServiceFactory.getEntityService((String)this.entityName());
        List<DynamicObject> dyList = this.getDataEntityList();
        ArrayList idList = Lists.newArrayListWithCapacity((int)dyList.size());
        Map<String, DynamicObject> updateMap = this.existDyMap(dyList);
        OperateExistRuleEnum existRuleEnum = this.getOperateBo().getOperateExistRuleEnum();
        if (existRuleEnum == OperateExistRuleEnum.EXIST_DELETE_INSERT) {
            this.delete(updateMap.values());
            updateMap.clear();
        } else if (existRuleEnum == OperateExistRuleEnum.EXIST_UPDATE) {
            this.fillData(dyList, updateMap);
            updateMap.clear();
        } else {
            this.beforeSkip(dyList, updateMap);
            dyList.removeIf(dy -> updateMap.containsKey(this.dyKey((DynamicObject)dy)));
        }
        List<Object> changedIdList = null;
        if (!CollectionUtils.isEmpty(dyList)) {
            changedIdList = this.save(dyList);
            idList.addAll(changedIdList);
        }
        updateMap.values().forEach(dy -> idList.add(dy.getLong("id")));
        this.afterOperate(changedIdList, idList);
        this.getOperateResultBo().getDataResultBo().addPresetDataResultBo(new PresetDataResultBo(this.entityName(), changedIdList));
    }

    private List<Object> save(List<DynamicObject> dyList) {
        List<Object> resultList = Lists.newArrayListWithCapacity((int)16);
        if (this.callOpFlag()) {
            resultList = MetaFieldTypeUtils.save(dyList.toArray(new DynamicObject[0]), this.getOperateResultBo());
        } else {
            Object[] result;
            for (Object entity : result = this.entityService.save(dyList.toArray(new DynamicObject[0]))) {
                if (!(entity instanceof DynamicObject)) continue;
                resultList.add(((DynamicObject)entity).getLong("id"));
            }
        }
        return resultList;
    }

    protected void afterOperate(List<Object> changedIdList, List<Object> idList) {
    }

    protected void beforeSkip(List<DynamicObject> dyList, Map<String, DynamicObject> updateMap) {
    }

    private void fillData(List<DynamicObject> dyList, Map<String, DynamicObject> updateMap) {
        for (int index = 0; index < dyList.size(); ++index) {
            DynamicObject dy = dyList.get(index);
            DynamicObject updateDy = updateMap.get(this.dyKey(dy));
            if (updateDy == null) continue;
            this.fillUpdateData(dy, updateDy);
            dyList.set(index, updateDy);
        }
    }

    protected void fillUpdateData(DynamicObject dy, DynamicObject dbDy) {
        HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)dbDy, IGNORE_KEY_SET);
    }

    private void delete(Collection<DynamicObject> dyList) {
        if (!CollectionUtils.isEmpty(dyList)) {
            OperationServiceHelper.executeOperate((String)"delete", (String)this.entityName(), (DynamicObject[])dyList.toArray(new DynamicObject[0]), (OperateOption)this.createOperateOption());
        }
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", Boolean.TRUE.toString());
        return operateOption;
    }
}

