/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.util.SplitNumberUtil;
import kd.hdtc.hrbm.business.domain.task.bo.PresetDataResultBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.impl.PresetDataOperateServiceImpl;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class RegisterPersonInfoGroupServiceImpl
extends PresetDataOperateServiceImpl {
    private static final Log LOG = LogFactory.getLog(RegisterPersonInfoGroupServiceImpl.class);
    private static final String PAGE_INFO_ID = "pageinfo.id";
    private final IBaseEntityService infoGroupFieldEntityService = CommonEntityServiceFactory.getEntityService((String)"hspm_infogroupfield");
    private final IBaseEntityService empMultiService = CommonEntityServiceFactory.getEntityService((String)"hspm_multiviewconfigemp");
    private final IBaseEntityService multiService = CommonEntityServiceFactory.getEntityService((String)"hspm_multiviewconfig");
    private Map<String, Map<String, Object>> numberIdMap;
    private final Set<String> ignoreKeySet = Sets.newHashSet((Object[])new String[]{"id", "boid", "viewlocation"});

    public final Map<String, Map<String, Object>> getNumberIdMap() {
        return this.numberIdMap;
    }

    @Override
    protected String entityName() {
        return "hspm_infogrouppagereg";
    }

    @Override
    protected List<DynamicObject> getDataEntityList() {
        return this.buildInfoGroupList();
    }

    @Override
    protected Map<String, DynamicObject> existDyMap(List<DynamicObject> dyList) {
        QFilter qFilter = new QFilter("pageinfo", "in", dyList.stream().map(dy -> dy.getString(PAGE_INFO_ID)).collect(Collectors.toSet()));
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject[] existArray = this.entityService.loadDynamicObjectArray(qFilter.toArray());
        return Arrays.stream(existArray).collect(Collectors.toMap(this::dyKey, dy -> dy, (k1, k2) -> k1));
    }

    @Override
    protected String dyKey(DynamicObject dy) {
        return dy.getString(PAGE_INFO_ID) + "," + dy.getString("group.id") + "," + dy.getString("businesstype");
    }

    @Override
    protected void afterOperate(List<Object> changedIdList, List<Object> idList) {
        if (!CollectionUtils.isEmpty(changedIdList)) {
            for (Object successPkId : changedIdList) {
                LOG.error("RegisterPersonInfoGroupServiceImpl saveInfoGroupField start id is {}", successPkId);
                HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMInfoGroupService", (String)"saveInfoGroupField", (Object[])new Object[]{successPkId});
            }
            this.getOperateResultBo().getDataResultBo().addPresetDataResultBo(new PresetDataResultBo("hspm_infogroupfield", this.queryInfoGroupFieldIdByGroupIds(changedIdList)));
        }
        this.setRegisterContext(idList);
    }

    private void setRegisterContext(List<Object> idList) {
        if (CollectionUtils.isEmpty(idList) || this.numberIdMap == null) {
            return;
        }
        List list = this.entityService.queryOriginalList("id,number,name,dyviewpc,dialogpc,dyviewmobile,dialogmobile", new QFilter("id", "in", idList).toArray());
        ArrayList resultList = Lists.newArrayListWithCapacity((int)list.size());
        list.forEach(dy -> {
            Map<String, Object> configMap = this.numberIdMap.get(dy.getString("number"));
            if (configMap != null) {
                HashMap valueMap = Maps.newHashMapWithExpectedSize((int)16);
                valueMap.put("id", dy.getLong("id"));
                valueMap.put("dyviewpc", dy.getString("dyviewpc"));
                valueMap.put("dialogpc", dy.getString("dialogpc"));
                valueMap.put("dyviewmobile", dy.getString("dyviewmobile"));
                valueMap.put("dialogmobile", dy.getString("dialogmobile"));
                valueMap.put("name", dy.getString("name"));
                valueMap.put("biztype", configMap.get("biztype"));
                valueMap.put("viewlocation", configMap.get("viewlocation"));
                valueMap.put("psfileviews", configMap.get("psfileviews"));
                valueMap.put("mgfileviews", configMap.get("mgfileviews"));
                resultList.add(valueMap);
            }
        });
        TaskRunContext.get().addContextValue(Collections.singletonMap("registerPersonInfo", resultList));
    }

    private List<Object> queryInfoGroupFieldIdByGroupIds(List<Object> groupId) {
        List dynamicObjectList;
        QFilter groupIdFilter = new QFilter("group", "in", groupId);
        QFilter groupFiledQFilter = this.getGroupFiledQFilter();
        if (groupFiledQFilter != null) {
            groupIdFilter.and(groupFiledQFilter);
        }
        if (CollectionUtils.isNotEmpty((Collection)(dynamicObjectList = this.infoGroupFieldEntityService.queryOriginalList("id", new QFilter[]{groupIdFilter})))) {
            return dynamicObjectList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
        }
        return new ArrayList<Object>();
    }

    protected QFilter getGroupFiledQFilter() {
        return null;
    }

    @Override
    protected void fillUpdateData(DynamicObject dy, DynamicObject dbDy) {
        HRDynamicObjectUtils.copy((DynamicObject)dy, (DynamicObject)dbDy, this.ignoreKeySet);
    }

    private List<DynamicObject> buildInfoGroupList() {
        Map<Long, List<DynamicObject>> map;
        this.numberIdMap = Maps.newHashMapWithExpectedSize((int)16);
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        String entityNumber = this.getRunParamStrByKey("modelEntityNumber");
        String entityName = EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName().getLocaleValue();
        DynamicObject[] viewArray = this.getViewListByParam("mgfileviews", this.multiService);
        if (viewArray != null) {
            map = Arrays.stream(viewArray).collect(Collectors.groupingBy(dy -> dy.getLong("erfiletype.id")));
            list.addAll(this.buildInfoGroupList(map, "0", entityNumber, entityName));
        }
        if ((viewArray = this.getViewListByParam("psfileviews", this.empMultiService)) != null) {
            map = Arrays.stream(viewArray).collect(Collectors.groupingBy(dy -> dy.getLong("erfiletype.id")));
            list.addAll(this.buildInfoGroupList(map, "1", entityNumber, entityName));
        }
        return list;
    }

    private DynamicObject[] getViewListByParam(String param, IBaseEntityService service) {
        Object obj = this.getRunParamMap().get(param);
        if (!(obj instanceof List)) {
            return null;
        }
        Object[] idArray = ((List)obj).stream().map(this::getLongValue).toArray();
        return service.query("id,erfiletype", idArray);
    }

    private Long getLongValue(Object obj) {
        return obj instanceof Long ? (Long)obj : Long.valueOf(obj.toString());
    }

    private List<DynamicObject> buildInfoGroupList(Map<Long, List<DynamicObject>> map, String bizType, String entityNumber, String entityName) {
        ArrayList personInfoGroupList = Lists.newArrayListWithCapacity((int)map.size());
        Date now = new Date();
        DynamicObject bosEntityObDy = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bos_entityobject"));
        bosEntityObDy.set("id", (Object)entityNumber);
        for (Map.Entry<Long, List<DynamicObject>> entry : map.entrySet()) {
            String viewLocation;
            HashMap configMap = Maps.newHashMapWithExpectedSize((int)5);
            DynamicObject infoGroupPageRegister = this.entityService.generateEmptyDynamicObject();
            String number = this.generateInfoGroupPageRegisterNumber(entityNumber, bizType, entry.getKey()).toUpperCase(Locale.ROOT);
            infoGroupPageRegister.set("number", (Object)number);
            infoGroupPageRegister.set("name", (Object)entityName);
            infoGroupPageRegister.set("enable", (Object)"1");
            infoGroupPageRegister.set("modifytime", (Object)now);
            infoGroupPageRegister.set("createtime", (Object)now);
            infoGroupPageRegister.set("status", (Object)"C");
            DynamicObject erFileTypeDy = entry.getValue().get(0).getDynamicObject("erfiletype");
            infoGroupPageRegister.set("group", (Object)erFileTypeDy);
            infoGroupPageRegister.set("pageinfo", (Object)bosEntityObDy);
            infoGroupPageRegister.set("pagetype", (Object)"3");
            infoGroupPageRegister.set("businesstype", (Object)bizType);
            configMap.put("mgfileviews", Collections.EMPTY_LIST);
            configMap.put("psfileviews", Collections.EMPTY_LIST);
            if ("0".equals(bizType)) {
                this.setManageInfoGroupPageRegisterParam(infoGroupPageRegister);
                viewLocation = "2";
                configMap.put("mgfileviews", this.getMulIdList(entry.getValue()));
            } else {
                this.setEmployeeInfoGroupPageRegisterParam(infoGroupPageRegister);
                viewLocation = "1";
                configMap.put("psfileviews", this.getMulIdList(entry.getValue()));
            }
            infoGroupPageRegister.set("viewlocation", (Object)viewLocation);
            configMap.put("biztype", bizType);
            configMap.put("viewlocation", viewLocation);
            personInfoGroupList.add(infoGroupPageRegister);
            this.numberIdMap.put(number, configMap);
        }
        return personInfoGroupList;
    }

    private List<Long> getMulIdList(List<DynamicObject> dyList) {
        return dyList.stream().map(dy -> dy.getLong("id")).collect(Collectors.toList());
    }

    private String generateInfoGroupPageRegisterNumber(String entityNumber, String bizType, long fileTypeId) {
        if (StringUtils.isEmpty((CharSequence)entityNumber) || StringUtils.isEmpty((CharSequence)bizType)) {
            return "";
        }
        String finalFileType = fileTypeId / 10L % 100L + "";
        String number = SplitNumberUtil.getSplitNumber(entityNumber, 20);
        return number + "_" + bizType + "_" + finalFileType + "_extpl";
    }

    private void setManageInfoGroupPageRegisterParam(DynamicObject infoGroupPageRegister) {
        this.setAttribute(infoGroupPageRegister, "dyviewpc", "mgmtSingleEntityNumber");
        this.setAttribute(infoGroupPageRegister, "dyviewpc", "mgmtMultiEntityNumber");
        this.setAttribute(infoGroupPageRegister, "dialogpc", "mgmtDialogEntityNumber");
    }

    private void setAttribute(DynamicObject dy, String propertyName, String key) {
        String entityNumber = (String)TaskRunContext.get().getContextValue(key);
        if (HRStringUtils.isNotEmpty((String)entityNumber)) {
            dy.set(propertyName, (Object)entityNumber);
        }
    }

    private void setEmployeeInfoGroupPageRegisterParam(DynamicObject infoGroupPageRegister) {
        this.setAttribute(infoGroupPageRegister, "dyviewpc", "empSingleEntityNumber");
        this.setAttribute(infoGroupPageRegister, "dyviewpc", "empMultiEntityNumber");
        this.setAttribute(infoGroupPageRegister, "dialogpc", "empDialogEntityNumber");
        this.setAttribute(infoGroupPageRegister, "dyviewmobile", "mSingleEntityNumber");
        this.setAttribute(infoGroupPageRegister, "dialogmobile", "mSingleEntityNumber");
        this.setAttribute(infoGroupPageRegister, "dyviewmobile", "mMultiEntityNumber");
        this.setAttribute(infoGroupPageRegister, "dialogmobile", "mDialogEntityNumber");
    }
}

