/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.caserule.CaseRuleHandleFactory;
import kd.hdtc.hrbm.business.domain.caserule.handle.ICaseRuleHandle;
import kd.hdtc.hrbm.business.domain.task.ITaskRecordDomainService;
import kd.hdtc.hrbm.business.domain.task.ITaskService;
import kd.hdtc.hrbm.business.domain.task.bo.TaskDetailBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskGenContext;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.entity.ITaskDetailEntityService;
import kd.hdtc.hrbm.business.domain.task.entity.ITaskRecordEntityService;
import kd.hdtc.hrbm.business.domain.task.impl.TaskServiceImpl;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class TaskRecordDomainServiceImpl
implements ITaskRecordDomainService {
    private static final Log LOG = LogFactory.getLog(TaskRecordDomainServiceImpl.class);
    private final ITaskRecordEntityService taskRecordEntityService = ServiceFactory.getService(ITaskRecordEntityService.class);
    private final ITaskDetailEntityService iTaskDetailEntityService = ServiceFactory.getService(ITaskDetailEntityService.class);

    @Override
    public long generateTaskRecord(long sceneManagerId, String runParamStr, String callbackServiceName) {
        long taskId = ID.genLongId();
        TXHandle required = null;
        try {
            required = TX.requiresNew();
            TaskGenContext.create(taskId, runParamStr, sceneManagerId);
            this.taskRecordEntityService.createNewTaskRecord(taskId, sceneManagerId, runParamStr, callbackServiceName);
            new TaskDetailBo().createTaskDetail();
        }
        catch (Exception ex) {
            if (required != null) {
                required.markRollback();
            }
            throw ex;
        }
        finally {
            TaskGenContext.remove();
            if (required != null) {
                required.close();
            }
        }
        return taskId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean run(long taskId) {
        if (!this.taskRecordEntityService.isExists(new QFilter("id", "=", (Object)taskId))) {
            throw new HRDBSBizException("task is not exist, taskId : " + taskId);
        }
        try {
            TaskRunContext.create(taskId);
            TaskRunContext.get().init();
            List<ITaskService> taskServiceList = this.buildTaskServiceList();
            for (ITaskService iTaskService : taskServiceList) {
                if (iTaskService.run()) continue;
                boolean bl = false;
                return bl;
            }
            for (ICaseRuleHandle iCaseRuleHandle : this.getCaseRuleHandleList()) {
                iCaseRuleHandle.callback(TaskRunContext.get().getExtCaseManageId(), TaskRunContext.get().getRunContextMap());
            }
        }
        finally {
            TaskRunContext.remove();
        }
        this.taskRecordEntityService.successTaskRecord(taskId);
        return true;
    }

    private List<ICaseRuleHandle> getCaseRuleHandleList() {
        String serviceName = Optional.ofNullable(TaskRunContext.get()).map(it -> (String)it.getContextValue("callbackService")).orElseGet(() -> "");
        if (StringUtils.isEmpty((String)serviceName)) {
            return Lists.newArrayList();
        }
        List handleNameList = Splitter.on((String)";").trimResults().splitToList((CharSequence)serviceName);
        return handleNameList.stream().map(handleName -> CaseRuleHandleFactory.getCaseRuleHandle(handleName)).collect(Collectors.toList());
    }

    private List<ITaskService> buildTaskServiceList() {
        List<DynamicObject> taskDetailList = this.iTaskDetailEntityService.queryTaskDetailList(TaskRunContext.get().getTaskId());
        return taskDetailList.stream().map(taskDetail -> new TaskServiceImpl((DynamicObject)taskDetail)).collect(Collectors.toList());
    }

    @Override
    public void retry(long taskId) {
        this.run(taskId);
    }

    @Override
    public DynamicObject getTaskDetailById(Long id) {
        return this.iTaskDetailEntityService.queryOne("result", new QFilter("id", "=", (Object)id).toArray());
    }

    @Override
    public DynamicObject getTaskDetailByTaskIdAndStatus(Long taskId, String execStatus) {
        QFilter qFilter = new QFilter("task", "=", (Object)taskId);
        qFilter.and("execstatus", "=", (Object)execStatus);
        return this.iTaskDetailEntityService.queryOne("operate.name", qFilter.toArray());
    }
}

