/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl;

import java.util.Date;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IBizModelRecordDomainService;
import kd.hdtc.hrbm.business.domain.task.ITaskService;
import kd.hdtc.hrbm.business.domain.task.TaskOperateServiceFactory;
import kd.hdtc.hrbm.business.domain.task.bo.BizModelRecordBo;
import kd.hdtc.hrbm.business.domain.task.bo.DataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.OperateBo;
import kd.hdtc.hrbm.business.domain.task.bo.OperateResultBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.entity.ITaskDetailEntityService;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.platform.DynamicObjectUtils;

public class TaskServiceImpl
implements ITaskService {
    private static final Log LOG = LogFactory.getLog(TaskServiceImpl.class);
    private static final ITaskDetailEntityService iTaskDetailEntityService = ServiceFactory.getService(ITaskDetailEntityService.class);
    private final IBizModelRecordDomainService bizModelRecordDomainService = ServiceFactory.getService(IBizModelRecordDomainService.class);
    private long taskDetailId;
    private DynamicObject taskDetailDynamicObject;
    private String execStatus;

    public TaskServiceImpl(DynamicObject taskDetailDynamicObject) {
        this.taskDetailDynamicObject = taskDetailDynamicObject;
        this.taskDetailId = taskDetailDynamicObject.getLong("id");
        this.execStatus = taskDetailDynamicObject.getString("execstatus");
    }

    @Override
    public boolean run() {
        if ("1".equals(this.execStatus)) {
            return true;
        }
        this.taskDetailDynamicObject.set("starttime", (Object)new Date());
        DynamicObject operateDy = Optional.ofNullable(this.taskDetailDynamicObject.getDynamicObject("operate")).map(task -> task.getString("number")).map(operateNumber -> TaskRunContext.get().getOperateDyByNumber((String)operateNumber)).orElseThrow(() -> new HRDBSBizException("operate is empty"));
        OperateBo operateBo = new OperateBo(operateDy);
        boolean flag = true;
        try {
            OperateResultBo operateResultBo = TaskOperateServiceFactory.getOperateService(operateBo).operate(TaskRunContext.get().getRunParamMap());
            if (operateResultBo.isSuccess()) {
                this.taskDetailDynamicObject.set("execstatus", (Object)"1");
                this.taskDetailDynamicObject.set("result", (Object)operateResultBo.getDataResultBo().resultDataBoToJson());
                this.taskDetailDynamicObject.set("endtime", (Object)new Date());
                DynamicObjectUtils.clearBigText((DynamicObject)this.taskDetailDynamicObject, (String)"errormsg");
                this.bizModelRecordDomainService.saveBizModelRecord(this.buildBizModelRecordBo(TaskRunContext.get(), operateResultBo.getDataResultBo()));
            } else {
                this.taskDetailDynamicObject.set("execstatus", (Object)"2");
                DynamicObjectUtils.setBigText((DynamicObject)this.taskDetailDynamicObject, (String)"errormsg", (String)JsonUtils.toStr(operateResultBo.getMessageList()));
            }
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            this.taskDetailDynamicObject.set("execstatus", (Object)"2");
            DynamicObjectUtils.setBigText((DynamicObject)this.taskDetailDynamicObject, (String)"errormsg", (String)TaskServiceImpl.getStackTraceString(ex));
            flag = false;
        }
        DynamicObjectUtils.addModifyAuditInfo((DynamicObject)this.taskDetailDynamicObject);
        iTaskDetailEntityService.saveInTrans(this.taskDetailDynamicObject);
        return flag;
    }

    private static String getStackTraceString(Throwable throwable) {
        if (throwable.getCause() != null) {
            return TaskServiceImpl.getStackTraceString(throwable.getCause());
        }
        StringBuilder sb = new StringBuilder("traceId:");
        sb.append(RequestContext.get().getTraceId()).append('\n');
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            if (sb.length() > 4000) {
                return sb.toString();
            }
            sb.append(stackTraceElement).append('\n');
        }
        return sb.toString();
    }

    private BizModelRecordBo buildBizModelRecordBo(TaskRunContext taskRunContext, DataResultBo dataResultBo) {
        BizModelRecordBo bizModelRecordBo = new BizModelRecordBo();
        long bizModelId = (Long)Optional.ofNullable(taskRunContext.getRunParamByKey("bizModelId")).orElse(0L);
        String baseDatatype = (String)Optional.ofNullable(taskRunContext.getRunParamByKey("baseDatatype")).orElse("");
        bizModelRecordBo.setBizModelId(bizModelId);
        bizModelRecordBo.setBaseDatatype(baseDatatype);
        bizModelRecordBo.setDataResultBo(dataResultBo);
        return bizModelRecordBo;
    }
}

