/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.hr;

import java.util.Arrays;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public abstract class AbstractOnBrdMetaServiceImpl
extends AbstractOperateService {
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);

    @Override
    protected void doOperate() {
        String modelEntityNumber = this.getRunParamStrByKey("modelEntityNumber");
        String metaEntityNumber = this.getMetaEntityNumber(modelEntityNumber);
        metaEntityNumber = metaEntityNumber.toLowerCase().replace("hcf", "hom");
        MetadataGenParam metadataGenParam = this.getMetadataGenParam(metaEntityNumber, modelEntityNumber);
        this.fillAttribute(metadataGenParam);
        MetadataGenResult result = this.dynamicMetadataApplicationService.generate(metadataGenParam);
        this.getOperateResultBo().getDataResultBo().addMetadataResultBo(result.getEntityNumber(), result.getEntityId(), result.getVersionNumber());
        String contextKey = this.getAddContextKey();
        if (!StringUtils.isEmpty((String)contextKey)) {
            String[] keys = contextKey.split(",");
            TaskRunContext.get().addContextValue(Arrays.stream(keys).collect(Collectors.toMap(key -> key, key -> result.getEntityNumber())));
        }
    }

    protected abstract String getMetaEntityNumber(String var1);

    protected abstract String getParentFilePage();

    protected abstract String getAddContextKey();

    protected String getBizUnitId() {
        return "41A5TI4/1UZE";
    }

    protected boolean isAddFields() {
        return false;
    }

    protected void fillAttribute(MetadataGenParam metadataGenParam) {
    }

    private MetadataGenParam getMetadataGenParam(String metaDataNumber, String modelEntityNumber) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)modelEntityNumber);
        String metaDataName = mainEntityType.getDisplayName().getLocaleValue();
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataName(metaDataName);
        baseParam.setMetadataNumber(metaDataNumber);
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)this.getParentFilePage());
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setBizUnitId(this.getBizUnitId());
        baseParam.setAppId("hom");
        baseParam.setType(MetadataGenTypeEnum.NORMAL_METADATA);
        baseParam.cancelAutoTableName();
        if (this.isAddFields()) {
            this.addFields(metadataGenParam);
        }
        return metadataGenParam;
    }

    private void addFields(MetadataGenParam metadataGenParam) {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        MetadataGenParam param = bo.getData();
        metadataGenParam.setFieldParamList(param.getFieldParamList());
        metadataGenParam.setContainerParamList(param.getContainerParamList());
    }
}

