/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.hr;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.tools.IMetadataDomainService;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class DeleteOnBrdOperateServiceImpl
extends AbstractOperateService {
    private final IBaseEntityService peronBrdConfService = CommonEntityServiceFactory.getEntityService((String)"hom_peronbrdinfoconf");
    private final IMetadataDomainService iMetadataDomainService = ServiceFactory.getService(IMetadataDomainService.class);
    private final IBaseEntityService permRelateService = CommonEntityServiceFactory.getEntityService((String)"hrcs_permrelat");
    private final IBaseEntityService entityForbidService = CommonEntityServiceFactory.getEntityService((String)"hrcs_entityforbid");
    private final IBaseEntityService rolePermService = CommonEntityServiceFactory.getEntityService((String)"perm_roleperm");
    private static final String ENTITY = "roleperm.entity";
    private static final String ENTITY_ID = "entity.id";
    private static final String ROLE_PERM = "roleperm";

    @Override
    protected void doOperate() {
        String modelEntityNumber = this.getRunParamStrByKey("modelEntityNumber");
        QFilter qFilter = new QFilter("obj", "=", (Object)modelEntityNumber);
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject peronBrdConfDy = this.peronBrdConfService.queryOriginalOne("viewinfo,editinfo,showinfo", qFilter.toArray());
        if (peronBrdConfDy == null) {
            return;
        }
        HashSet entityNumberSet = Sets.newHashSetWithExpectedSize((int)5);
        this.addEntityNumber(entityNumberSet, "viewinfo", peronBrdConfDy);
        this.addEntityNumber(entityNumberSet, "editinfo", peronBrdConfDy);
        this.addEntityNumber(entityNumberSet, "showinfo", peronBrdConfDy);
        if (CollectionUtils.isEmpty((Collection)entityNumberSet)) {
            return;
        }
        this.deleteRolePerm(entityNumberSet);
        try (TXHandle txHandle = TX.requiresNew();){
            qFilter = new QFilter("entitytype", "in", (Object)entityNumberSet);
            this.permRelateService.deleteByFilter(qFilter.toArray());
            qFilter = new QFilter("entitytypeid", "in", (Object)entityNumberSet);
            this.entityForbidService.deleteByFilter(qFilter.toArray());
        }
        entityNumberSet.forEach(entityNumber -> this.iMetadataDomainService.deleteMetadata((String)entityNumber, false));
        String oldEditEntityNumber = peronBrdConfDy.getString("editinfo");
        if (StringUtils.isNotEmpty((String)oldEditEntityNumber)) {
            TaskRunContext.get().addContextValue(Collections.singletonMap("oldEditEntityNumber", oldEditEntityNumber));
        }
    }

    private void deleteRolePerm(Set<String> entityNumberSet) {
        QFilter qFilter = new QFilter(ENTITY, "in", entityNumberSet);
        DynamicObject[] roleArray = this.rolePermService.loadDynamicObjectArray(qFilter.toArray());
        if (roleArray == null || roleArray.length == 0) {
            return;
        }
        for (DynamicObject role : roleArray) {
            DynamicObjectCollection rolePermCol = role.getDynamicObjectCollection(ROLE_PERM);
            rolePermCol.removeIf(rolePerm -> entityNumberSet.contains(rolePerm.getString(ENTITY_ID)));
        }
        try (TXHandle txHandle = TX.requiresNew();){
            this.rolePermService.save(roleArray);
        }
    }

    private void addEntityNumber(Set<String> entityNumberSet, String propertyName, DynamicObject peronBrdConfDy) {
        String value = peronBrdConfDy.getString(propertyName);
        if (StringUtils.isNotEmpty((String)value)) {
            entityNumberSet.add(value);
        }
    }
}

