/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.hr;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.id.ID;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.util.MetaFieldTypeUtils;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.impl.PresetDataOperateServiceImpl;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class HRPersonDiaETplConfServiceImpl
extends PresetDataOperateServiceImpl {
    private static final String DEP_EMP = "depemp";
    private static final String PERSON = "person";
    private static final String BO_ID = "boid";
    private static final String HRPI_EMPPOSORGREL = "hrpi_empposorgrel";
    private static final String HSPM_ERMANFILE = "hspm_ermanfile";
    private static final String UNIQUE_VAL = ",person,boid,";
    private final List<String> posFieldList = Arrays.asList("adminorg", "apositiontype", "position", "stdposition", "job", "depemp");
    private final List<String> eRmanFileFieldList = Arrays.asList("org", "empgroup", "depemp");
    private final LocaleString desc = ResManager.getLocaleString((String)"\u65e0\u9700\u586b\u5199", (String)"DiaETplConfServiceImpl_0", (String)"hdtc-hrbm-business");
    private int treeSeq = 1;
    private List<String> enableFieldList;
    private List<String> deleteFieldList;

    @Override
    protected String entityName() {
        return "hies_diaetplconf";
    }

    @Override
    protected List<DynamicObject> getDataEntityList() {
        this.initData();
        return Lists.newArrayList((Object[])new DynamicObject[]{this.buildDy()});
    }

    @Override
    protected void afterOperate(List<Object> changedIdList, List<Object> idList) {
        if (!CollectionUtils.isEmpty(changedIdList)) {
            QFilter qFilter = new QFilter("id", "in", idList);
            qFilter.and("enable", "!=", (Object)"1");
            DynamicObject[] array = this.entityService.query("id,enable", qFilter.toArray());
            if (array != null && array.length > 0) {
                for (DynamicObject dy : array) {
                    dy.set("enable", (Object)"1");
                }
                this.entityService.save(array);
            }
        }
    }

    private void initData() {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        List fieldParamList = bo.getSourceData().getFieldParamList();
        this.deleteFieldList = Lists.newArrayListWithCapacity((int)fieldParamList.size());
        this.enableFieldList = Lists.newArrayListWithCapacity((int)(fieldParamList.size() + 2));
        this.enableFieldList.add(PERSON);
        this.enableFieldList.add(BO_ID);
        for (FieldParam fieldParam : fieldParamList) {
            String number = fieldParam.getNumber();
            if (fieldParam.isDelete()) {
                this.deleteFieldList.add(number);
                continue;
            }
            this.enableFieldList.add(number);
        }
    }

    private DynamicObject buildDy() {
        DynamicObject configDy = this.entityService.generateEmptyDynamicObject();
        String metaEntityName = EntityMetadataCache.getDataEntityType((String)this.getRunParamStrByKey("modelEntityNumber")).getDisplayName().getLocaleValue();
        String fromMetaDataNumber = (String)TaskRunContext.get().getContextValue("massMaintenanceEntityNumber");
        String queryNumber = (String)TaskRunContext.get().getContextValue("massMaintenanceQueryNumber");
        configDy.set("orgfield", (Object)MetaFieldTypeUtils.buildDy("bos_org", 100000L));
        configDy.set("allocationpolicy", (Object)"0");
        configDy.set("number", (Object)(fromMetaDataNumber + "_imttpl"));
        configDy.set("name", (Object)(metaEntityName + "_import"));
        configDy.set("tmpltype", (Object)"IMPT");
        configDy.set("entitytype", (Object)"MESS");
        configDy.set("entity", (Object)MetaFieldTypeUtils.buildDy("hbp_entityobject", fromMetaDataNumber));
        configDy.set("queryentity", (Object)MetaFieldTypeUtils.buildDy("hbp_entityobject", queryNumber));
        configDy.set("tplgenmode", (Object)"sysgen");
        configDy.set("importtype", (Object)"updateandnew");
        configDy.set("enabledowncond", (Object)"1");
        configDy.set("mainentityuniqueval", (Object)UNIQUE_VAL);
        configDy.set("source", (Object)"normal");
        configDy.set("tplscope", (Object)"standard");
        configDy.set("issyspreset", (Object)Boolean.TRUE);
        this.buildEntityRelationCol(configDy);
        this.buildTreeEntryEntity(configDy);
        configDy.set("enable", (Object)"1");
        return configDy;
    }

    private void buildEntityRelationCol(DynamicObject configDy) {
        long[] entityIds = ID.genLongIds((int)2);
        DynamicObjectCollection entityRelationCol = configDy.getDynamicObjectCollection("entityrelation");
        DynamicObject entityRelationDy = entityRelationCol.addNew();
        entityRelationDy.set("id", (Object)entityIds[0]);
        entityRelationDy.set("rentity", (Object)HRPI_EMPPOSORGREL);
        entityRelationDy.set("seq", (Object)1);
        entityRelationDy.set("entityuniqueval", (Object)DEP_EMP);
        entityRelationDy = entityRelationCol.addNew();
        entityRelationDy.set("id", (Object)entityIds[1]);
        entityRelationDy.set("rentity", (Object)HSPM_ERMANFILE);
        entityRelationDy.set("seq", (Object)2);
        entityRelationDy.set("entityuniqueval", (Object)DEP_EMP);
    }

    private void buildTreeEntryEntity(DynamicObject configDy) {
        DynamicObjectCollection col = configDy.getDynamicObjectCollection("tpltreeentryentity");
        String fromMetaDataNumber = (String)TaskRunContext.get().getContextValue("massMaintenanceEntityNumber");
        this.buildTreeEntryEntity(col, fromMetaDataNumber, this.enableFieldList, (entityDy, field) -> {
            entityDy.set("isimport", (Object)Boolean.TRUE);
            entityDy.set("ischecked", (Object)Boolean.TRUE);
            entityDy.set("ismustinput", (Object)field.isMustInput());
            if (field instanceof BasedataField) {
                entityDy.set("imptattr", (Object)"number");
            }
        });
        this.buildTreeEntryEntity(col, HRPI_EMPPOSORGREL, this.posFieldList, this::setOtherTreeEntity);
        this.buildTreeEntryEntity(col, HSPM_ERMANFILE, this.eRmanFileFieldList, this::setOtherTreeEntity);
    }

    private void buildTreeEntryEntity(DynamicObjectCollection col, String entityNumber, List<String> importFieldList, BiConsumer<DynamicObject, Field<?>> consumer) {
        List<Field<?>> fieldList = this.getImportEntityItems(entityNumber);
        if (fieldList == null || fieldList.size() == 0) {
            return;
        }
        long[] entityIds = ID.genLongIds((int)(fieldList.size() + 3));
        int index = 0;
        DynamicObject entityDy = col.addNew();
        long firstId = entityIds[index++];
        entityDy.set("id", (Object)firstId);
        entityDy.set("childentity", (Object)entityNumber);
        entityDy.set("fieldnumber", (Object)entityNumber);
        entityDy.set("isimport", (Object)Boolean.TRUE);
        entityDy.set("isfield", (Object)Boolean.FALSE);
        entityDy.set("ischecked", (Object)Boolean.TRUE);
        entityDy.set("seq", (Object)this.treeSeq++);
        entityDy = col.addNew();
        long secondId = entityIds[index++];
        entityDy.set("id", (Object)secondId);
        entityDy.set("pid", (Object)firstId);
        entityDy.set("childentity", (Object)entityNumber);
        entityDy.set("isimport", (Object)Boolean.TRUE);
        entityDy.set("isfield", (Object)Boolean.FALSE);
        entityDy.set("ischecked", (Object)Boolean.TRUE);
        entityDy.set("seq", (Object)this.treeSeq++);
        entityDy = col.addNew();
        entityDy.set("id", (Object)entityIds[index++]);
        entityDy.set("pid", (Object)secondId);
        entityDy.set("childentity", (Object)entityNumber);
        entityDy.set("fieldnumber", (Object)"id");
        entityDy.set("isfield", (Object)Boolean.TRUE);
        entityDy.set("seq", (Object)this.treeSeq++);
        Map<String, Field> fieldMap = fieldList.stream().collect(Collectors.toMap(AbstractElement::getKey, field -> field));
        for (String fieldKey : importFieldList) {
            Field field2 = fieldMap.remove(fieldKey);
            if (field2 == null) continue;
            entityDy = col.addNew();
            entityDy.set("id", (Object)entityIds[index++]);
            entityDy.set("pid", (Object)secondId);
            entityDy.set("childentity", (Object)entityNumber);
            entityDy.set("fieldnumber", (Object)field2.getKey());
            entityDy.set("isfield", (Object)Boolean.TRUE);
            entityDy.set("fieldname", (Object)field2.getName());
            entityDy.set("seq", (Object)this.treeSeq++);
            consumer.accept(entityDy, field2);
        }
    }

    private void setOtherTreeEntity(DynamicObject entityDy, Field<?> field) {
        entityDy.set("isimport", (Object)Boolean.TRUE);
        entityDy.set("ischecked", (Object)Boolean.TRUE);
        entityDy.set("fieldimportdesc", (Object)this.desc);
        if (field instanceof BasedataField) {
            if (DEP_EMP.equals(field.getKey())) {
                entityDy.set("imptattr", (Object)"number");
            } else {
                entityDy.set("imptattr", (Object)"number_name");
            }
        }
    }

    private List<Field<?>> getImportEntityItems(String entityNumber) {
        List list = MetadataUtils.getEntityFieldItems((String)entityNumber);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return list.stream().map(item -> (Field)item).filter(item -> item.getFeatures().isImportable()).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    protected Map<String, DynamicObject> existDyMap(List<DynamicObject> dyList) {
        QFilter qFilter = new QFilter("queryentity.id", "in", dyList.stream().map(dy -> dy.getString("queryentity.id")).collect(Collectors.toSet()));
        qFilter.and("issyspreset", "=", (Object)Boolean.TRUE);
        DynamicObject[] array = this.entityService.loadDynamicObjectArray(qFilter.toArray());
        return Arrays.stream(array).collect(Collectors.toMap(this::dyKey, dy -> dy, (k1, k2) -> k2));
    }

    @Override
    protected String dyKey(DynamicObject dy) {
        return dy.getString("queryentity.id");
    }

    @Override
    protected void fillUpdateData(DynamicObject dy, DynamicObject dbDy) {
        DynamicObjectCollection dbTreeCol = dbDy.getDynamicObjectCollection("tpltreeentryentity");
        String fromMetaDataNumber = (String)TaskRunContext.get().getContextValue("massMaintenanceEntityNumber");
        List entityList = dy.getDynamicObjectCollection("tpltreeentryentity").stream().filter(entityDy -> fromMetaDataNumber.equals(entityDy.getString("childentity")) && entityDy.getBoolean("isfield")).collect(Collectors.toList());
        Map<String, DynamicObject> dbEntryMap = dbTreeCol.stream().filter(entityDy -> fromMetaDataNumber.equals(entityDy.getString("childentity")) && entityDy.getBoolean("isfield")).collect(Collectors.toMap(entityDy -> entityDy.getString("fieldnumber"), entityDy -> entityDy));
        Optional<DynamicObject> maxSeqOp = dbTreeCol.stream().filter(entityDy -> fromMetaDataNumber.equals(entityDy.getString("childentity"))).max(Comparator.comparingInt(entityDy -> entityDy.getInt("seq")));
        int seq = 0;
        if (maxSeqOp.isPresent()) {
            seq = maxSeqOp.get().getInt("seq");
        }
        ++seq;
        int addIndex = 0;
        for (DynamicObject entryDy2 : entityList) {
            String fieldNumber = entryDy2.getString("fieldnumber");
            DynamicObject dbEntryDy = dbEntryMap.get(fieldNumber);
            if (dbEntryDy != null) continue;
            entryDy2.set("seq", (Object)seq++);
            ++addIndex;
            dbTreeCol.add((Object)entryDy2);
        }
        this.setDeleteFiledValue(dbEntryMap);
        if (addIndex == 0) {
            return;
        }
        int finalAddIndex = addIndex;
        dbTreeCol.stream().filter(entityDy -> !fromMetaDataNumber.equals(entityDy.getString("childentity"))).forEach(entryDy -> entryDy.set("seq", (Object)(entryDy.getInt("seq") + finalAddIndex)));
    }

    private void setDeleteFiledValue(Map<String, DynamicObject> dbEntryMap) {
        if (CollectionUtils.isEmpty(this.deleteFieldList)) {
            return;
        }
        for (String deleteField : this.deleteFieldList) {
            DynamicObject dbEntryDy = dbEntryMap.get(deleteField);
            if (dbEntryDy == null) continue;
            dbEntryDy.set("isimport", (Object)Boolean.FALSE);
            dbEntryDy.set("ischecked", (Object)Boolean.FALSE);
        }
    }
}

