/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.hr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.task.bo.SwitchRegistryBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrbm.business.domain.task.impl.CommonSwitchRegistryServiceImpl;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;

public class HRSwitchRegistryServiceImpl
extends CommonSwitchRegistryServiceImpl {
    private final IBaseEntityService bosFormMetaService = CommonEntityServiceFactory.getEntityService((String)"bos_formmeta");

    @Override
    protected List<DynamicObject> getDataEntityList() {
        ArrayList switchRegistryBoList = Lists.newArrayListWithCapacity((int)2);
        DynamicObject listDy = this.getFormMeta();
        if (listDy == null) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        String metaEntityName = EntityMetadataCache.getDataEntityType((String)this.getRunParamStrByKey("modelEntityNumber")).getDisplayName().getLocaleValue();
        String fromMetaDataNumber = (String)TaskRunContext.get().getContextValue("massMaintenanceEntityNumber");
        String entityId = listDy.getString("id");
        switchRegistryBoList.add(this.buildImportSwitchRegistryBo(fromMetaDataNumber, metaEntityName, entityId));
        switchRegistryBoList.add(this.buildExportSwitchRegistryBo(fromMetaDataNumber, metaEntityName, entityId));
        return this.getDataEntityList(switchRegistryBoList);
    }

    private DynamicObject getFormMeta() {
        String listNumber = (String)TaskRunContext.get().getContextValue("massMaintenanceListNumber");
        QFilter qFilter = new QFilter("number", "=", (Object)listNumber);
        return this.bosFormMetaService.queryOriginalOne("id", qFilter.toArray());
    }

    private SwitchRegistryBo buildImportSwitchRegistryBo(String entityNumber, String name, String entity) {
        SwitchRegistryBo bo = new SwitchRegistryBo();
        bo.setNumber(entityNumber + "_imp");
        bo.setName(name + "_import");
        bo.setEntity(entity);
        bo.setBizapp("1WXBPN7+OHJZ");
        bo.setOldOp("importdata");
        bo.setNewOp("importdata_hr");
        bo.setOpType("impt");
        bo.setPermItem("4730fc9f000003ae");
        bo.setEnableStatus("0");
        return bo;
    }

    private SwitchRegistryBo buildExportSwitchRegistryBo(String entityNumber, String name, String entity) {
        SwitchRegistryBo bo = new SwitchRegistryBo();
        bo.setNumber(entityNumber + "_exportbyimp");
        bo.setName(name + "_export");
        bo.setEntity(entity);
        bo.setBizapp("1WXBPN7+OHJZ");
        bo.setOldOp("exportlist");
        bo.setNewOp("export_from_impttpl_hr");
        bo.setOpType("expt");
        bo.setPermItem("4730fc9f000004ae");
        bo.setEnableStatus("0");
        return bo;
    }
}

