/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.hr;

import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public abstract class PersonInfoMetaExtServiceImpl
extends AbstractOperateService {
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)ServiceFactory.getService(IBizUnitEntityService.class);
    private MetadataGenParam sourceParam;

    @Override
    protected void doOperate() {
        MetadataGenResult result = this.dynamicMetadataApplicationService.generate(this.buildMetadataGenParam());
        this.getOperateResultBo().getDataResultBo().addMetadataResultBo(result.getEntityNumber(), result.getEntityId(), result.getVersionNumber());
    }

    private MetadataGenParam buildMetadataGenParam() {
        String metaEntityNumber = this.getMetaEntityNumber();
        MainEntityType mainType = MetadataUtils.getMainEntityType((String)metaEntityNumber);
        String metaEntityName = mainType.getDisplayName().getLocaleValue();
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataNumber(metaEntityNumber);
        baseParam.setMetadataName(metaEntityName);
        baseParam.setType(MetadataGenTypeEnum.EXTEND_METADATA);
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)metaEntityNumber);
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setBizUnitId((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        baseParam.setAppId(mainType.getAppId());
        this.fillAttribute(metadataGenParam);
        return metadataGenParam;
    }

    protected abstract String getMetaEntityNumber();

    protected void fillAttribute(MetadataGenParam metadataGenParam) {
    }

    protected final MetadataGenParam getSourceParam() {
        if (this.sourceParam == null) {
            RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
            this.sourceParam = bo.getSourceData();
        }
        return this.sourceParam;
    }
}

