/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.hr;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.MetadataDataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicQueryApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.pojo.query.QueryList;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class PersonMassMainQueryExtServiceImpl
extends AbstractOperateService {
    private QueryEntityType sourceQueryType;
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)ServiceFactory.getService(IBizUnitEntityService.class);
    private final IDynamicQueryApplicationService dynamicQueryApplicationService = (IDynamicQueryApplicationService)ServiceFactory.getService(IDynamicQueryApplicationService.class);

    @Override
    protected void doOperate() {
        this.initData();
        QueryGenResult result = this.dynamicQueryApplicationService.generatePlatformQuery(this.buildGenParam());
        this.getOperateResultBo().getDataResultBo().addMetadataDataResultBoList(new MetadataDataResultBo(result.getExtQueryId(), result.getExtQueryNumber()));
        this.getOperateResultBo().getDataResultBo().addMetadataDataResultBoList(new MetadataDataResultBo(result.getExtQueryListId(), result.getExtQueryListNumber()));
    }

    private void initData() {
        String sourceEntityNumber = this.getRunParamStrByKey("massMaintenanceQueryNumber");
        this.sourceQueryType = (QueryEntityType)MetadataUtils.getMainEntityType((String)sourceEntityNumber);
    }

    private QueryGenParam buildGenParam() {
        QueryGenParam queryGenParam = new QueryGenParam();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)this.sourceQueryType.getAppId());
        queryGenParam.setAppId(appId);
        queryGenParam.setNumber(this.sourceQueryType.getName());
        queryGenParam.setName(this.sourceQueryType.getDisplayName().getLocaleValue());
        queryGenParam.setMainEntity(this.buildMainEntity());
        queryGenParam.setQueryList(this.buildQueryList());
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)queryGenParam.getNumber());
        queryGenParam.setUnit((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        queryGenParam.setSubQueryEntityList(this.buildSubQueryEntityList());
        queryGenParam.setQueryFieldList(this.buildQueryFieldList(queryGenParam));
        return queryGenParam;
    }

    private List<QueryField> buildQueryFieldList(QueryGenParam queryGenParam) {
        ArrayList list = Lists.newArrayListWithCapacity((int)16);
        List<FieldParam> fieldParamList = this.getSourceFields();
        for (FieldParam param : fieldParamList) {
            QueryField queryField = new QueryField();
            queryField.setFieldName(param.getName());
            if (FieldTypeEnum.BASEDATAFIELD.getType().equals(param.getType())) {
                queryField.setFieldNumber(param.getNumber() + "." + "name");
            } else {
                queryField.setFieldNumber(param.getNumber());
            }
            queryField.setQueryEntity(queryGenParam.getMainEntity());
            queryField.setVisible(false);
            list.add(queryField);
        }
        return list;
    }

    private List<FieldParam> getSourceFields() {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        return bo.getSourceData().getFieldParamList().stream().filter(field -> !field.isDelete() && !FieldTypeEnum.MULBASEDATAFIELD.getType().equals(field.getType())).collect(Collectors.toList());
    }

    private QueryEntity buildMainEntity() {
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setNumber(this.sourceQueryType.getEntityName());
        queryEntity.setName(this.sourceQueryType.getDisplayName().getLocaleValue());
        queryEntity.setAlias(this.sourceQueryType.getEntityName());
        return queryEntity;
    }

    private QueryList buildQueryList() {
        String queryListEntityNumber = this.getRunParamStrByKey("massMaintenanceListNumber");
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)queryListEntityNumber);
        QueryList queryList = new QueryList();
        queryList.setListName(formMetadata.getName().getLocaleValue());
        queryList.setListNumber(queryListEntityNumber);
        queryList.setRelQueryListNumber(queryListEntityNumber);
        return queryList;
    }

    private List<QueryEntity> buildSubQueryEntityList() {
        List joinEntityList = this.sourceQueryType.getJoinEntitys();
        if (CollectionUtils.isEmpty((Collection)joinEntityList)) {
            return Lists.newArrayListWithCapacity((int)0);
        }
        ArrayList list = Lists.newArrayListWithCapacity((int)joinEntityList.size());
        for (JoinEntity joinEntity : joinEntityList) {
            QueryEntity entity = this.buildQueryEntity(joinEntity);
            list.add(entity);
        }
        return list;
    }

    private QueryEntity buildQueryEntity(JoinEntity joinEntity) {
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setNumber(joinEntity.getEntityName());
        queryEntity.setName(joinEntity.getDisplayName());
        queryEntity.setAlias(joinEntity.getAlias());
        return queryEntity;
    }
}

