/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.hr;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.impl.RegisterPersonInfoGroupServiceImpl;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class RegisterPersonGroupServiceImpl
extends RegisterPersonInfoGroupServiceImpl {
    private static final Log LOG = LogFactory.getLog(RegisterPersonGroupServiceImpl.class);
    private static final String PRESET = "preset";
    private static final Long MAIN_FILE_TYPE = 1010L;

    @Override
    protected List<DynamicObject> getDataEntityList() {
        String entityNumber = this.getRunParamStrByKey("modelEntityNumber");
        QFilter qFilter = new QFilter("pageinfo", "=", (Object)entityNumber);
        List<DynamicObject> list = super.getDataEntityList();
        qFilter.and("group", "in", this.getGroupSet(list));
        qFilter.and("enable", "=", (Object)"1");
        DynamicObject[] groups = this.entityService.query("group,name,viewlocation,pagetype,dyviewpc,dialogpc,dyviewmobile,dialogmobile,requiredfields,noteditablefields,filterfields,businesstype,preset", qFilter.toArray());
        if (groups == null || groups.length == 0) {
            LOG.error("not find main file type group");
            return Lists.newArrayList();
        }
        Map<String, DynamicObject> sourceMap = this.getSourceMap(groups);
        Iterator<DynamicObject> it = list.iterator();
        while (it.hasNext()) {
            DynamicObject dy = it.next();
            DynamicObject sourceDy = this.getSourceDy(dy, sourceMap);
            if (sourceDy == null) {
                LOG.error("not find main file type group, businesstype is +" + dy.getString("businesstype"));
                it.remove();
                continue;
            }
            dy.set("name", sourceDy.get("name"));
            dy.set("businesstype", sourceDy.get("businesstype"));
            dy.set("pagetype", sourceDy.get("pagetype"));
            dy.set("dyviewpc", sourceDy.get("dyviewpc"));
            dy.set("dialogpc", sourceDy.get("dialogpc"));
            dy.set("dyviewmobile", sourceDy.get("dyviewmobile"));
            dy.set("dialogmobile", sourceDy.get("dialogmobile"));
            dy.set("requiredfields", sourceDy.get("requiredfields"));
            dy.set("noteditablefields", sourceDy.get("noteditablefields"));
            dy.set("filterfields", sourceDy.get("filterfields"));
        }
        return list;
    }

    private DynamicObject getSourceDy(DynamicObject dy, Map<String, DynamicObject> sourceMap) {
        String mapKey = this.getMapKey(dy);
        DynamicObject sourceDy = sourceMap.get(mapKey);
        if (sourceDy == null) {
            String sourceViewLocation;
            mapKey = this.getMapKey(dy.getString("group.id"), "2");
            sourceDy = sourceMap.get(mapKey);
            if (sourceDy != null && StringUtils.equals((String)dy.getString("businesstype"), (String)"1") && StringUtils.equals((String)(sourceViewLocation = sourceDy.getString("viewlocation")), (String)"2")) {
                sourceDy = null;
            }
            if (sourceDy == null) {
                mapKey = this.getMapKey(String.valueOf(MAIN_FILE_TYPE), dy.getString("businesstype"));
                return sourceMap.get(mapKey);
            }
        }
        return sourceDy;
    }

    private Set<Long> getGroupSet(List<DynamicObject> list) {
        Set<Long> set = list.stream().map(dy -> dy.getLong("group.id")).collect(Collectors.toSet());
        set.add(MAIN_FILE_TYPE);
        return set;
    }

    @Override
    protected void beforeSkip(List<DynamicObject> dyList, Map<String, DynamicObject> updateMap) {
        Map<String, Map<String, Object>> numberMap = this.getNumberIdMap();
        for (DynamicObject dy : dyList) {
            String number = dy.getString("number");
            Map<String, Object> map = numberMap.get(number);
            if (map == null) continue;
            this.putMapValue(map, dy);
            DynamicObject db = updateMap.get(this.dyKey(dy));
            if (db == null) continue;
            this.putMapValue(map, db);
            String dbNumber = db.getString("number");
            if (StringUtils.equals((String)number, (String)dbNumber)) continue;
            numberMap.remove(number);
            numberMap.put(dbNumber, map);
        }
    }

    private void putMapValue(Map<String, Object> map, DynamicObject dy) {
        map.put("viewlocation", dy.getString("viewlocation"));
        map.put("name", dy.getString("name"));
    }

    private Map<String, DynamicObject> getSourceMap(DynamicObject[] groups) {
        HashMap map = Maps.newHashMapWithExpectedSize((int)4);
        for (DynamicObject dy : groups) {
            String mapKey = this.getMapKey(dy);
            if (map.get(mapKey) != null && !dy.getBoolean(PRESET)) continue;
            map.put(mapKey, dy);
        }
        return map;
    }

    private String getMapKey(DynamicObject dy) {
        String groupIdStr = dy.getString("group.id");
        String businessType = dy.getString("businesstype");
        return this.getMapKey(groupIdStr, businessType);
    }

    private String getMapKey(String groupIdStr, String businessType) {
        return groupIdStr + "," + businessType;
    }

    @Override
    protected void afterOperate(List<Object> changedIdList, List<Object> idList) {
        super.afterOperate(idList, idList);
    }

    @Override
    protected QFilter getGroupFiledQFilter() {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        HashSet allFieldNumberSet = Sets.newHashSetWithExpectedSize((int)16);
        bo.getSourceData().getFieldParamList().forEach(fieldParam -> allFieldNumberSet.add(fieldParam.getNumber()));
        bo.getSourceData().getContainerParamList().stream().filter(containerParam -> FieldTypeEnum.ATTACHMENTPANEL.getType().equals(containerParam.getType())).forEach(param -> allFieldNumberSet.add(param.getNumber()));
        return new QFilter("number", "in", (Object)allFieldNumberSet);
    }
}

