/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.sihc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.MetadataDataResultBo;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicQueryApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.common.enums.query.KsqlQueryWay;
import kd.hdtc.hrdbs.common.enums.query.QuerySchema;
import kd.hdtc.hrdbs.common.pojo.query.HRCSQuerySchema;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class CadreReportQueryExtServiceImpl
extends AbstractOperateService {
    private QueryEntityType sourceQueryType;
    private DynamicObject modCadreReportDO;
    private QueryEntity mainEntity;
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)ServiceFactory.getService(IBizUnitEntityService.class);
    private final IDynamicQueryApplicationService dynamicQueryApplicationService = (IDynamicQueryApplicationService)ServiceFactory.getService(IDynamicQueryApplicationService.class);
    private static final HRBaseServiceHelper MOD_CADRE_REPORT_REPOSITORY = HRBaseServiceHelper.create((String)"hrbm_modcadrereport");
    DynamicObject[] allModCadreReportDOArr;
    private static final Map<String, String> ENTITY_ALIES = Maps.newLinkedHashMapWithExpectedSize((int)8);
    private final IMetadataEntityService metadataEntityService = (IMetadataEntityService)ServiceFactory.getService(IMetadataEntityService.class);

    @Override
    protected void doOperate() {
        this.initData();
        QueryGenResult result = this.dynamicQueryApplicationService.generatePlatformQuery(this.buildGenParam());
        this.getOperateResultBo().getDataResultBo().addMetadataDataResultBoList(new MetadataDataResultBo(result.getExtQueryId(), result.getExtQueryNumber()));
    }

    private void initData() {
        this.sourceQueryType = (QueryEntityType)MetadataUtils.getMainEntityType((String)"soebs_cadrefilereportquery");
        Map<String, Object> runParamMap = this.getRunParamMap();
        Object primaryKey = runParamMap.get("primaryKey");
        this.modCadreReportDO = MOD_CADRE_REPORT_REPOSITORY.queryOne(primaryKey);
        Objects.requireNonNull(this.modCadreReportDO);
        this.allModCadreReportDOArr = MOD_CADRE_REPORT_REPOSITORY.loadDynamicObjectArray(new QFilter[]{new QFilter("enable", "=", (Object)"1")});
    }

    private QueryGenParam buildGenParam() {
        QueryGenParam queryGenParam = new QueryGenParam();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)this.sourceQueryType.getAppId());
        queryGenParam.setAppId(appId);
        queryGenParam.setNumber(this.sourceQueryType.getName());
        queryGenParam.setName(this.sourceQueryType.getDisplayName().getLocaleValue());
        queryGenParam.setMainEntity(this.buildMainEntity());
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)queryGenParam.getNumber());
        queryGenParam.setUnit((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        queryGenParam.setSubQueryEntityList(this.buildSubQueryEntityList());
        queryGenParam.setQueryFieldList(this.buildQueryFieldList(queryGenParam));
        HRCSQuerySchema querySchema = new HRCSQuerySchema();
        querySchema.setQuerySchema(QuerySchema.KSQL);
        querySchema.setKsqlQueryWay(KsqlQueryWay.SQL_QUERY);
        queryGenParam.setHrcsQuerySchema(querySchema);
        Map sourceMetaData = this.metadataEntityService.getDesignMetadata("soebs_cadrefile");
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List editParamList = sourceDesignMetadataParser.getEntityMetadata();
        queryGenParam.setEntityOperationList((List)((Map)editParamList.get(0)).get("Operations"));
        queryGenParam.setPermissionItemsList((List)((Map)editParamList.get(0)).get("PermissionItems"));
        return queryGenParam;
    }

    private List<QueryField> buildQueryFieldList(QueryGenParam queryGenParam) {
        ArrayList queryFieldList = Lists.newArrayListWithCapacity((int)16);
        List subQueryEntityList = queryGenParam.getSubQueryEntityList();
        for (DynamicObject dynamicObject : this.allModCadreReportDOArr) {
            Optional<QueryEntity> first = subQueryEntityList.stream().filter(entity -> HRStringUtils.equals((String)dynamicObject.getString("bizmodel.number"), (String)entity.getNumber())).findFirst();
            if (!first.isPresent()) continue;
            DynamicObjectCollection propEntry = dynamicObject.getDynamicObjectCollection("entryentity");
            for (DynamicObject propRowDO : propEntry) {
                QueryField queryField = new QueryField();
                queryFieldList.add(queryField);
                DynamicObject propDO = propRowDO.getDynamicObject("cadreprop");
                String entityName = propDO.getString("logicentity.name");
                String entityNumber = propDO.getString("logicentity.number");
                if (ENTITY_ALIES.get(entityNumber) != null) {
                    entityName = ENTITY_ALIES.get(entityNumber);
                }
                queryField.setFieldNumber(propDO.getString("propkey"));
                queryField.setFieldName(entityName + "." + propDO.getString("name"));
                queryField.setQueryEntity(first.get());
            }
        }
        return queryFieldList;
    }

    private QueryEntity buildMainEntity() {
        this.mainEntity = new QueryEntity();
        this.mainEntity.setNumber(this.sourceQueryType.getEntityName());
        this.mainEntity.setName(this.sourceQueryType.getDisplayName().getLocaleValue());
        this.mainEntity.setAlias(this.sourceQueryType.getEntityName());
        return this.mainEntity;
    }

    private List<QueryEntity> buildSubQueryEntityList() {
        ArrayList queryEntityList = Lists.newArrayListWithCapacity((int)10);
        if (this.allModCadreReportDOArr == null || this.allModCadreReportDOArr.length == 0) {
            return queryEntityList;
        }
        for (DynamicObject dynamicObject : this.allModCadreReportDOArr) {
            if (CollectionUtils.isEmpty((Collection)dynamicObject.getDynamicObjectCollection("entryentity"))) continue;
            queryEntityList.add(this.buildCurrEntity(dynamicObject));
        }
        return queryEntityList;
    }

    private QueryEntity buildQueryEntity(JoinEntity joinEntity) {
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setNumber(joinEntity.getEntityName());
        queryEntity.setName(joinEntity.getDisplayName());
        queryEntity.setAlias(joinEntity.getAlias());
        return queryEntity;
    }

    private QueryEntity buildCurrEntity(DynamicObject modCadreReportDO) {
        QueryEntity queryEntity = new QueryEntity();
        DynamicObject bizModelDO = modCadreReportDO.getDynamicObject("bizmodel");
        queryEntity.setNumber(bizModelDO.getString("number"));
        queryEntity.setName(bizModelDO.getString("name"));
        queryEntity.setAlias(bizModelDO.getString("number"));
        queryEntity.setMainQueryEntity(this.mainEntity);
        return queryEntity;
    }

    private boolean checkIsNewEntity(List<JoinEntity> joinEntityList, DynamicObject bizModelDO) {
        return joinEntityList.stream().map(JoinEntity::getEntityName).noneMatch(joinEntityName -> HRStringUtils.equals((String)joinEntityName, (String)bizModelDO.getString("name")));
    }

    static {
        ENTITY_ALIES.put("hrpi_pernontsprop", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CadreReportQueryExtServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("soecs_cafilenontsprop", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CadreReportQueryExtServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("hrpi_pertsprop", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CadreReportQueryExtServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("hrpi_perregion", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CadreReportQueryExtServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("hrpi_percontact", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CadreReportQueryExtServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("hrpi_percre", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CadreReportQueryExtServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("soebs_cadrefile", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"CadreReportQueryExtServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("hrpi_appointremoverel", ResManager.loadKDString((String)"\u4efb\u514d\u7ecf\u5386", (String)"CadreReportQueryExtServiceImpl_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("hrpi_pereduexp", ResManager.loadKDString((String)"\u6700\u9ad8\u5b66\u5386", (String)"CadreReportQueryExtServiceImpl_2", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        ENTITY_ALIES.put("hrpi_empentrel", ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f", (String)"CadreReportQueryExtServiceImpl_3", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
    }
}

