/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.sihc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.util.CollectionUtils;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.EntryParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class SIHCCollAffairsAddFieldOperateServiceImpl
extends AbstractOperateService {
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)ServiceFactory.getService(IBizUnitEntityService.class);
    private static final String APPOINT_FLEX = "appointflex";

    @Override
    protected void doOperate() {
        MetadataGenParam metadataGenParam = this.buildMetadataGenParam(this.getRunParamStr());
        if ("soecadm_appremreg".equals(metadataGenParam.getBaseParam().getMetadataNumber()) || "soecadm_appremcoll".equals(metadataGenParam.getBaseParam().getMetadataNumber())) {
            this.appRemAffairsHandle(metadataGenParam);
            this.generateHandle(metadataGenParam);
        }
    }

    private void appRemAffairsHandle(MetadataGenParam metadataGenParam) {
        List fieldParamList = metadataGenParam.getFieldParamList();
        if (CollectionUtils.isEmpty((Collection)fieldParamList)) {
            List entryParamList = metadataGenParam.getEntryParamList();
            if (CollectionUtils.isNotEmpty((Collection)entryParamList)) {
                EntryParam entryParam = (EntryParam)entryParamList.get(0);
                List fieldParamListAdd = entryParam.getFieldParamList();
                fieldParamListAdd.forEach(fieldParam -> {
                    String substring = fieldParam.getType().substring(0, fieldParam.getType().length() - "entry".length());
                    fieldParam.setType(substring);
                    fieldParam.setContainerNumber(APPOINT_FLEX);
                    fieldParam.setEntryParam(null);
                });
                metadataGenParam.setFieldParamList(fieldParamListAdd);
                metadataGenParam.setEntryParamList(new ArrayList());
            }
        } else {
            fieldParamList.forEach(fieldParam -> fieldParam.setContainerNumber(APPOINT_FLEX));
        }
        BaseParam baseParam = metadataGenParam.getBaseParam();
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)"soecadm_appremaffairs");
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setMetadataNumber(formMetadata.getKey());
        baseParam.setMetadataName(formMetadata.getName().toString());
        baseParam.setBizUnitId((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        baseParam.setModelType(formMetadata.getModelType());
    }

    private void generateHandle(MetadataGenParam metadataGenParam) {
        MetadataGenResult result = this.dynamicMetadataApplicationService.generate(metadataGenParam);
        if (!result.isSuccess()) {
            throw new HRDBSBizException(result.getThrowable(), new ErrorCode("hrdbs.metadataGenError", "hrdbs.metadataGenError"), new Object[0]);
        }
        this.getOperateResultBo().getDataResultBo().addMetadataResultBo(result.getEntityNumber(), result.getEntityId(), result.getVersionNumber());
        TaskRunContext.get().addContextValue(Collections.singletonMap("resultEntityNumber", result.getEntityNumber()));
    }

    private MetadataGenParam buildMetadataGenParam(String param) {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)param, RunParamBo.class);
        return bo.getData();
    }
}

