/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.sihc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.lang.Lang;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.MetadataDataResultBo;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.SnapCadreRosterHelper;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.bo.SnapReportEntityInfo;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.bo.SnapReportFieldInfo;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicQueryApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.common.enums.query.KsqlQueryWay;
import kd.hdtc.hrdbs.common.enums.query.QuerySchema;
import kd.hdtc.hrdbs.common.pojo.query.HRCSQuerySchema;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.pojo.query.QueryList;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class SnapCadreReportQueryExtServiceImpl
extends AbstractOperateService {
    private QueryEntityType sourceQueryType;
    private DynamicObject modCadreReportDO;
    private QueryEntity mainEntity;
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)ServiceFactory.getService(IBizUnitEntityService.class);
    private final IDynamicQueryApplicationService dynamicQueryApplicationService = (IDynamicQueryApplicationService)ServiceFactory.getService(IDynamicQueryApplicationService.class);
    private static final HRBaseServiceHelper MOD_CADRE_REPORT_REPOSITORY = HRBaseServiceHelper.create((String)"hrbm_modcadrereport");
    DynamicObject[] allModCadreReportDOArr;
    private final IMetadataEntityService metadataEntityService = (IMetadataEntityService)ServiceFactory.getService(IMetadataEntityService.class);

    @Override
    protected void doOperate() {
        this.initData();
        QueryGenResult result = this.dynamicQueryApplicationService.generatePlatformQuery(this.buildGenParam());
        this.getOperateResultBo().getDataResultBo().addMetadataDataResultBoList(new MetadataDataResultBo(result.getExtQueryId(), result.getExtQueryNumber()));
    }

    private void initData() {
        this.sourceQueryType = (QueryEntityType)MetadataUtils.getMainEntityType((String)"soebs_cadrefilesnapreportquery");
        Map<String, Object> runParamMap = this.getRunParamMap();
        Object primaryKey = runParamMap.get("primaryKey");
        this.modCadreReportDO = MOD_CADRE_REPORT_REPOSITORY.queryOne(primaryKey);
        Objects.requireNonNull(this.modCadreReportDO);
        this.allModCadreReportDOArr = MOD_CADRE_REPORT_REPOSITORY.loadDynamicObjectArray(new QFilter[]{new QFilter("enable", "=", (Object)"1")});
    }

    private QueryGenParam buildGenParam() {
        QueryGenParam queryGenParam = new QueryGenParam();
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)this.sourceQueryType.getAppId());
        queryGenParam.setAppId(appId);
        queryGenParam.setNumber(this.sourceQueryType.getName());
        queryGenParam.setName(this.sourceQueryType.getDisplayName().getLocaleValue());
        queryGenParam.setMainEntity(this.buildMainEntity());
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)queryGenParam.getNumber());
        queryGenParam.setUnit((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        queryGenParam.setSubQueryEntityList(this.buildSubQueryEntityList());
        queryGenParam.setQueryFieldList(this.buildQueryFieldList(queryGenParam));
        HRCSQuerySchema querySchema = new HRCSQuerySchema();
        querySchema.setQuerySchema(QuerySchema.KSQL);
        querySchema.setKsqlQueryWay(KsqlQueryWay.SQL_QUERY);
        queryGenParam.setHrcsQuerySchema(querySchema);
        Map sourceMetaData = this.metadataEntityService.getDesignMetadata("soebs_cadrefile");
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List editParamList = sourceDesignMetadataParser.getEntityMetadata();
        queryGenParam.setEntityOperationList((List)((Map)editParamList.get(0)).get("Operations"));
        queryGenParam.setPermissionItemsList((List)((Map)editParamList.get(0)).get("PermissionItems"));
        return queryGenParam;
    }

    private List<QueryField> buildQueryFieldList(QueryGenParam queryGenParam) {
        ArrayList queryFieldList = Lists.newArrayListWithCapacity((int)16);
        for (DynamicObject dynamicObject : this.allModCadreReportDOArr) {
            SnapReportEntityInfo snapReportEntityInfo = SnapCadreRosterHelper.getSnapReportEntityInfo(dynamicObject);
            List<SnapReportFieldInfo> snapReportFieldInfoList = snapReportEntityInfo.getSnapReportFieldInfoList();
            Optional<QueryEntity> first = queryGenParam.getSubQueryEntityList().stream().filter(entity -> HRStringUtils.equals((String)entity.getNumber(), (String)snapReportEntityInfo.getNumber())).findFirst();
            if (!first.isPresent()) continue;
            for (SnapReportFieldInfo snapReportFieldInfo : snapReportFieldInfoList) {
                QueryField queryField = new QueryField();
                queryFieldList.add(queryField);
                queryField.setFieldNumber(snapReportFieldInfo.getNumber());
                Object nameObj = snapReportFieldInfo.getName();
                String name = nameObj instanceof Map ? (String)((Map)nameObj).get(Lang.get().getLangTag()) : String.valueOf(nameObj);
                queryField.setFieldName(name);
                queryField.setQueryEntity(first.get());
            }
        }
        return queryFieldList;
    }

    private QueryEntity buildMainEntity() {
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setNumber(this.sourceQueryType.getEntityName());
        queryEntity.setName(this.sourceQueryType.getDisplayName().getLocaleValue());
        queryEntity.setAlias(this.sourceQueryType.getEntityName());
        this.mainEntity = queryEntity;
        return queryEntity;
    }

    private QueryList buildQueryList() {
        String queryListEntityNumber = this.getRunParamStrByKey("massMaintenanceListNumber");
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)queryListEntityNumber);
        QueryList queryList = new QueryList();
        queryList.setListName(formMetadata.getName().getLocaleValue());
        queryList.setListNumber(queryListEntityNumber);
        queryList.setRelQueryListNumber(queryListEntityNumber);
        return queryList;
    }

    private List<QueryEntity> buildSubQueryEntityList() {
        ArrayList queryEntityList = Lists.newArrayListWithCapacity((int)10);
        if (this.allModCadreReportDOArr == null || this.allModCadreReportDOArr.length == 0) {
            return queryEntityList;
        }
        for (DynamicObject dynamicObject : this.allModCadreReportDOArr) {
            if (CollectionUtils.isEmpty((Collection)dynamicObject.getDynamicObjectCollection("entryentity_snap"))) continue;
            queryEntityList.add(this.buildCurrEntity(dynamicObject));
        }
        return queryEntityList;
    }

    private QueryEntity buildQueryEntity(JoinEntity joinEntity) {
        QueryEntity queryEntity = new QueryEntity();
        queryEntity.setNumber(joinEntity.getEntityName());
        queryEntity.setName(joinEntity.getDisplayName());
        queryEntity.setAlias(joinEntity.getAlias());
        return queryEntity;
    }

    private QueryEntity buildCurrEntity(DynamicObject modCadreReportDO) {
        QueryEntity queryEntity = new QueryEntity();
        SnapReportEntityInfo snapReportEntityInfo = SnapCadreRosterHelper.getSnapReportEntityInfo(modCadreReportDO);
        queryEntity.setNumber(snapReportEntityInfo.getNumber());
        Object nameObj = snapReportEntityInfo.getName();
        String name = nameObj instanceof Map ? (String)((Map)nameObj).get(Lang.get().getLangTag()) : String.valueOf(nameObj);
        queryEntity.setName(name);
        queryEntity.setAlias(snapReportEntityInfo.getNumber());
        queryEntity.setMainQueryEntity(this.mainEntity);
        return queryEntity;
    }
}

