/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.sihc;

import java.util.Collections;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.ErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.entity.sihc.IModifyCadreReportEntityService;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.OperateResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class SnapCadreRosterEntityGenOperateServiceImpl
extends AbstractOperateService {
    private static final Log log = LogFactory.getLog(SnapCadreRosterEntityGenOperateServiceImpl.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBizUnitEntityService.class);
    private final IModifyCadreReportEntityService modifyCadreReportService = ServiceFactory.getService(IModifyCadreReportEntityService.class);

    @Override
    protected void doOperate() {
        MetadataGenResult result = this.dynamicMetadataApplicationService.generate(this.buildMetadataGenParam());
        if (!result.isSuccess()) {
            log.info("SnapCadreRosterEntityGenOperateServiceImpl.doOperate.generate result: {}", (Object)result);
            throw new HRDBSBizException(result.getThrowable(), new ErrorCode("hrdbs.metadataGenError", "hrdbs.metadataGenError"), new Object[0]);
        }
        this.getOperateResultBo().getDataResultBo().addMetadataResultBo(result.getEntityNumber(), result.getEntityId(), result.getVersionNumber());
        TaskRunContext.get().addContextValue(Collections.singletonMap("resultEntityNumber", result.getEntityNumber()));
    }

    private MetadataGenParam buildMetadataGenParam() {
        Object primaryKey = this.getRunParamMap().get("primaryKey");
        DynamicObject modifyCadreReportObj = this.modifyCadreReportService.getModifyCadreReportById(primaryKey);
        String bizEntityName = modifyCadreReportObj.getString("bizmodel.name");
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        MetadataGenParam metadataGenParam = bo.getData();
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)"soebs_rostercadresnaptpl");
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataNumber(String.valueOf(this.getRunParamMap().get("rosterEntityNumber")));
        baseParam.setMetadataName(ResManager.loadKDString((String)"\u79bb\u9000\u540d\u518c\u5173\u7cfb\u8868-%s", (String)"SnapCadreRosterEntityGenOperateServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[]{bizEntityName}));
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)baseParam.getMetadataNumber());
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setType(MetadataGenTypeEnum.EXTEND_METADATA);
        baseParam.setBizUnitId((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        baseParam.setAppId(mainType.getAppId());
        return metadataGenParam;
    }

    @Override
    public OperateResultBo rollback(String runParamStr) {
        return null;
    }
}

