/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.sihc;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.entity.sihc.IRosterCnfEntityService;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.PresetDataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.RunParamBo;
import kd.hdtc.hrdbs.common.pojo.NodeParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.collections4.CollectionUtils;

public class SnapCadreRosterEntityPresetDataOperateServiceImpl
extends AbstractOperateService {
    private static final Log log = LogFactory.getLog(SnapCadreRosterEntityPresetDataOperateServiceImpl.class);
    private final IRosterCnfEntityService rosterConfService = ServiceFactory.getService(IRosterCnfEntityService.class);

    @Override
    protected void doOperate() {
        RunParamBo bo = (RunParamBo)SerializationUtils.fromJsonString((String)this.getRunParamStr(), RunParamBo.class);
        MetadataGenParam metadataGenParam = bo.getData();
        List fieldParamList = metadataGenParam.getFieldParamList();
        if (CollectionUtils.isEmpty((Collection)fieldParamList)) {
            return;
        }
        DynamicObject rosterConfObj = this.getRosterConfObj(metadataGenParam);
        PresetDataResultBo resultBo = new PresetDataResultBo();
        resultBo.setNumber("soebs_rosterentitycnf");
        resultBo.setIdList(Lists.newArrayList((Object[])new Object[]{rosterConfObj.getLong("id")}));
        this.getOperateResultBo().getDataResultBo().addPresetDataResultBo(resultBo);
    }

    private DynamicObject getRosterConfObj(MetadataGenParam metadataGenParam) {
        String bizEntityNumber = (String)this.getRunParamMap().get("bizEntityNumber");
        String rosterEntityNumber = (String)this.getRunParamMap().get("rosterEntityNumber");
        DynamicObject rosterConfObj = this.rosterConfService.getRosterConfigByBizNumber(bizEntityNumber);
        if (HRObjectUtils.isEmpty((Object)rosterConfObj)) {
            rosterConfObj = this.rosterConfService.generateEmptyDynamicObject();
            rosterConfObj.set("confentity", (Object)bizEntityNumber);
            rosterConfObj.set("confmappingentity", (Object)rosterEntityNumber);
        }
        Set newFieldsSet = metadataGenParam.getFieldParamList().stream().map(NodeParam::getNumber).collect(Collectors.toSet());
        String existFields = rosterConfObj.getString("queryfields");
        if (HRStringUtils.isEmpty((String)existFields)) {
            rosterConfObj.set("queryfields", (Object)String.join((CharSequence)",", newFieldsSet));
        } else {
            Set existFieldsSet = Arrays.stream(existFields.split(",")).collect(Collectors.toSet());
            String newFieldsStr = newFieldsSet.stream().filter(field -> !existFieldsSet.contains(field)).collect(Collectors.joining(","));
            if (HRStringUtils.isNotEmpty((String)newFieldsStr)) {
                rosterConfObj.set("queryfields", (Object)(existFields + "," + newFieldsStr));
            }
        }
        this.rosterConfService.save(rosterConfObj);
        return rosterConfObj;
    }
}

