/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.sihc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrbm.business.domain.extcase.entity.sihc.IRosterCnfEntityService;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.bo.SnapReportEntityInfo;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.bo.SnapReportFieldInfo;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class SnapCadreRosterHelper {
    public static String getSnapCadreRosterEntityNumber(String bizEntityNumber) {
        IRosterCnfEntityService rosterConfService = ServiceFactory.getService(IRosterCnfEntityService.class);
        Map<String, String> rosterConfigMap = rosterConfService.queryAllRosterConfig();
        String rosterEntityNum = rosterConfigMap.get(bizEntityNumber);
        if (HRStringUtils.isNotEmpty((String)rosterEntityNum)) {
            return rosterEntityNum;
        }
        String noAppEntityNum = bizEntityNumber.substring(bizEntityNumber.indexOf("_") + 1);
        String soebsEntityNum = "soebs_rost" + noAppEntityNum;
        String newRosterEntityNum = soebsEntityNum.length() <= 24 ? soebsEntityNum : soebsEntityNum.substring(0, 24);
        if (!MetadataUtils.isExist((String)newRosterEntityNum)) {
            SnapCadreRosterHelper.addRosterEntityToConf(bizEntityNumber, newRosterEntityNum, rosterConfService);
            return newRosterEntityNum;
        }
        int begin = 97;
        int end = begin + 26;
        for (int i = begin; i < end; ++i) {
            String appendSuffixRosterEntityNum = newRosterEntityNum + (char)i;
            if (MetadataUtils.isExist((String)appendSuffixRosterEntityNum)) continue;
            SnapCadreRosterHelper.addRosterEntityToConf(bizEntityNumber, appendSuffixRosterEntityNum, rosterConfService);
            return appendSuffixRosterEntityNum;
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SnapCadreRosterHelper_10", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
    }

    private static void addRosterEntityToConf(String bizEntityNumber, String newRosterEntityNum, IRosterCnfEntityService rosterConfService) {
        DynamicObject newRosterConfObj = rosterConfService.generateEmptyDynamicObject();
        newRosterConfObj.set("confentity", (Object)bizEntityNumber);
        newRosterConfObj.set("confmappingentity", (Object)newRosterEntityNum);
        rosterConfService.save(newRosterConfObj);
    }

    public static SnapReportEntityInfo getSnapReportEntityInfo(DynamicObject modCadreReportObj) {
        SnapReportEntityInfo snapReportEntityInfo = new SnapReportEntityInfo();
        DynamicObjectCollection coll = modCadreReportObj.getDynamicObjectCollection("entryentity_snap");
        if (coll.isEmpty()) {
            return snapReportEntityInfo;
        }
        String bizEntityName = modCadreReportObj.getString("bizmodel.name");
        snapReportEntityInfo.setName(bizEntityName);
        String bizEntityNumber = modCadreReportObj.getString("bizmodel.number");
        String rosterEntityNumber = SnapCadreRosterHelper.getSnapCadreRosterEntityNumber(bizEntityNumber);
        snapReportEntityInfo.setNumber(rosterEntityNumber);
        String fieldGroupName = SnapCadreRosterHelper.getCadreRosterPresetGroupName().get(bizEntityNumber);
        if (HRStringUtils.isEmpty((String)fieldGroupName)) {
            fieldGroupName = bizEntityName;
        }
        ArrayList fieldInfoList = Lists.newArrayListWithExpectedSize((int)coll.size());
        for (DynamicObject entryObj : coll) {
            SnapReportFieldInfo snapReportFieldInfo = new SnapReportFieldInfo();
            String fieldName = entryObj.getString("snapprop.name");
            snapReportFieldInfo.setName(fieldGroupName + "." + fieldName);
            String fieldNumber = entryObj.getString("snapprop.propkey");
            String fieldType = entryObj.getString("snapprop.fieldtype");
            if (FieldTypeEnum.BASEDATAFIELD.getType().equals(fieldType)) {
                snapReportFieldInfo.setNumber(fieldNumber + "." + "name");
            } else {
                snapReportFieldInfo.setNumber(fieldNumber);
            }
            fieldInfoList.add(snapReportFieldInfo);
        }
        snapReportEntityInfo.setSnapReportFieldInfoList(fieldInfoList);
        return snapReportEntityInfo;
    }

    public static Map<String, String> getCadreRosterPresetGroupName() {
        HashMap map = Maps.newHashMapWithExpectedSize((int)14);
        map.put("hrpi_pernontsprop", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"SnapCadreRosterHelper_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_perregion", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"SnapCadreRosterHelper_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_percontact", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"SnapCadreRosterHelper_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_pertsprop", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"SnapCadreRosterHelper_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_empcadre", ResManager.loadKDString((String)"\u5e72\u90e8\u8eab\u4efd\u4fe1\u606f", (String)"SnapCadreRosterHelper_1", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_percre", ResManager.loadKDString((String)"\u8bc1\u4ef6\u4fe1\u606f", (String)"SnapCadreRosterHelper_2", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_pereduexp", ResManager.loadKDString((String)"\u6559\u80b2\u7ecf\u5386", (String)"SnapCadreRosterHelper_3", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_perprotitle", ResManager.loadKDString((String)"\u804c\u79f0\u4fe1\u606f", (String)"SnapCadreRosterHelper_4", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_perocpqual", ResManager.loadKDString((String)"\u804c\u4e1a\u8d44\u683c", (String)"SnapCadreRosterHelper_5", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_empentrel", ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f", (String)"SnapCadreRosterHelper_6", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_baselocation", ResManager.loadKDString((String)"\u5e38\u9a7b\u5de5\u4f5c\u5730", (String)"SnapCadreRosterHelper_7", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_empposorgrel", ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386", (String)"SnapCadreRosterHelper_8", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("soecs_cafilenontsprop", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"SnapCadreRosterHelper_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        map.put("hrpi_appointremoverel", ResManager.loadKDString((String)"\u4efb\u514d\u7ecf\u5386", (String)"SnapCadreRosterHelper_9", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        return map;
    }

    public static Object[] getPublishCadreFileType(String entityNum) {
        QFilter entityNumFilter = new QFilter("pageinfo.id", "=", (Object)entityNum);
        QFilter cadreTypeFilter = new QFilter("group.id", "in", (Object)Lists.newArrayList((Object[])new Long[]{1777568566262990848L, 1787004807962185728L}));
        List pageInfoList = CommonEntityServiceFactory.getEntityService((String)"soebs_infogrouppagereg").queryOriginalList("pageinfo.id pageinfo,group.id group", new QFilter[]{entityNumFilter, cadreTypeFilter});
        return pageInfoList.stream().map(obj -> obj.getLong("group")).toArray();
    }
}

