/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.impl.swc;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.list.JoinEntity;
import kd.bos.entity.mulentities.QSConditionRow;
import kd.bos.entity.mulentities.QuerySelectField;
import kd.bos.entity.mulentities.QuerySourceJoinRelation;
import kd.bos.entity.mulentities.expr.QSExpr;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrbm.business.domain.task.AbstractOperateService;
import kd.hdtc.hrbm.business.domain.task.bo.DataResultBo;
import kd.hdtc.hrbm.business.domain.task.bo.MetadataDataResultBo;
import kd.hdtc.hrbm.business.domain.task.context.TaskRunContext;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicQueryApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.pojo.query.QueryEntity;
import kd.hdtc.hrdbs.common.pojo.query.QueryField;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenParam;
import kd.hdtc.hrdbs.common.pojo.query.QueryGenResult;
import kd.hdtc.hrdbs.common.pojo.query.QueryList;
import kd.hdtc.hrdbs.common.pojo.query.RelationCondition;
import org.apache.commons.collections.MapUtils;

public class SWCAddFieldForQueryServiceImpl
extends AbstractOperateService {
    private final IDynamicQueryApplicationService dynamicQueryApplicationService = (IDynamicQueryApplicationService)ServiceFactory.getService(IDynamicQueryApplicationService.class);
    private final IBaseEntityService entityService = CommonEntityServiceFactory.getEntityService((String)"bos_entityobject");
    private final IMetadataEntityService metadataEntityService = (IMetadataEntityService)ServiceFactory.getService(IMetadataEntityService.class);
    private String bizUnitId;
    private String queryNumber;
    private String queryListNumber;
    private String queryListPlugins;
    private QueryEntityType queryType;
    private MainEntityType mainEntityType;
    private Map<String, JoinEntity> joinEntities;
    private Map<String, List<QuerySourceJoinRelation>> joinRelations;
    private Map<String, Map<String, QuerySelectField>> selectFieldMapMap;
    private Map<String, MainEntityType> entityTypeCache;
    private Map<String, QueryEntity> queryEntityMap;

    @Override
    protected void doOperate() {
        if (!this.initData()) {
            return;
        }
        QueryGenResult result = this.dynamicQueryApplicationService.generatePlatformQuery(this.buildGenParam());
        DynamicObject queryDy = this.entityService.queryOne("id,enableimport", new QFilter("id", "=", (Object)this.queryNumber).toArray());
        if (queryDy != null) {
            queryDy.set("enableimport", (Object)"1");
            this.entityService.save(queryDy);
        }
        DataResultBo resultBo = this.getOperateResultBo().getDataResultBo();
        resultBo.addMetadataDataResultBoList(new MetadataDataResultBo(result.getQueryId(), this.queryNumber));
        if (!StringUtils.isEmpty((Object)this.queryListNumber)) {
            resultBo.addMetadataDataResultBoList(new MetadataDataResultBo(result.getQueryListId(), this.queryListNumber));
        }
        TaskRunContext.get().addContextValue(this.getEntityMap());
    }

    private boolean initData() {
        boolean result;
        this.queryNumber = MapUtils.getString(this.getRunParamMap(), (Object)"queryNumber");
        if (StringUtils.isEmpty((Object)this.queryNumber)) {
            return false;
        }
        this.bizUnitId = MapUtils.getString(this.getRunParamMap(), (Object)"bizUnitId");
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)this.queryNumber);
        if (!(type instanceof QueryEntityType)) {
            return false;
        }
        this.queryListNumber = MapUtils.getString(this.getRunParamMap(), (Object)"queryListNumber");
        if (StringUtils.isEmpty((Object)this.queryListNumber)) {
            this.queryListNumber = this.queryNumber;
        } else {
            this.queryListPlugins = MapUtils.getString(this.getRunParamMap(), (Object)"queryListPlugins");
        }
        this.queryType = (QueryEntityType)type;
        this.mainEntityType = this.queryType.getMainEntityType();
        List entities = this.queryType.getJoinEntitys();
        if (!CollectionUtils.isEmpty((Collection)entities)) {
            this.joinEntities = new LinkedHashMap<String, JoinEntity>(entities.size());
            for (JoinEntity entity : entities) {
                this.joinEntities.put(entity.getEntityName(), entity);
            }
        } else {
            this.joinEntities = new HashMap<String, JoinEntity>(0);
        }
        String bizEntityNumber = this.getRunParamStrByKey("bizEntityNumber");
        boolean bl = result = this.queryType.getMainEntityType().getName().equals(bizEntityNumber) || this.joinEntities.containsKey(bizEntityNumber);
        if (!result) {
            return false;
        }
        List relations = this.queryType.getJoinRelations();
        this.joinRelations = relations.stream().collect(Collectors.groupingBy(QuerySourceJoinRelation::getRelEntityNumber));
        List selectFields = this.queryType.getSelectFields();
        String mainEntityTypeName = this.mainEntityType.getName();
        int entitySize = this.joinEntities.size() + 1;
        this.selectFieldMapMap = new HashMap<String, Map<String, QuerySelectField>>(entitySize);
        this.entityTypeCache = new HashMap<String, MainEntityType>(entitySize);
        this.queryEntityMap = new HashMap<String, QueryEntity>(entitySize);
        for (QuerySelectField selectField : selectFields) {
            String aliasType;
            String alias = selectField.getAlias();
            int index = alias.indexOf(46);
            if (index > 0) {
                aliasType = alias.substring(0, index);
                if (aliasType.equals(mainEntityTypeName) || this.joinEntities.containsKey(aliasType)) {
                    alias = alias.substring(index + 1);
                } else {
                    aliasType = mainEntityTypeName;
                }
            } else {
                aliasType = mainEntityTypeName;
            }
            Map fieldMap = this.selectFieldMapMap.computeIfAbsent(aliasType, ky -> new HashMap(selectFields.size()));
            fieldMap.put(alias, selectField);
        }
        return true;
    }

    private Map<String, Object> getEntityMap() {
        HashMap entityMap = Maps.newHashMapWithExpectedSize((int)3);
        entityMap.put("massMaintenanceQueryNumber", this.queryNumber);
        if (!StringUtils.isEmpty((Object)this.queryListNumber)) {
            entityMap.put("massMaintenanceListNumber", this.queryListNumber);
        }
        return entityMap;
    }

    private QueryGenParam buildGenParam() {
        QueryGenParam queryGenParam = new QueryGenParam();
        queryGenParam.setUnit(this.bizUnitId);
        queryGenParam.setAppId(this.queryType.getAppId());
        queryGenParam.setNumber(this.queryType.getName());
        queryGenParam.setName(this.queryType.getDisplayName().toString());
        queryGenParam.setMainEntity(this.buildMainEntity());
        queryGenParam.setSubQueryEntityList(this.buildSubQueryEntityList());
        if (!StringUtils.isEmpty((Object)this.queryListNumber)) {
            queryGenParam.setQueryList(this.buildQueryList());
        }
        queryGenParam.setQueryFieldList(this.buildQueryFieldList());
        this.buildOps(queryGenParam, this.metadataEntityService.getDesignMetadata(this.queryNumber));
        return queryGenParam;
    }

    private QueryList buildQueryList() {
        QueryList queryList = new QueryList();
        queryList.setListName(this.queryType.getDisplayName().toString());
        queryList.setListNumber(this.queryListNumber);
        queryList.setRelQueryListNumber(this.queryListNumber);
        queryList.cancelClearFilter();
        if (!StringUtils.isEmpty((Object)this.queryListPlugins)) {
            queryList.setPluginList(Arrays.asList(this.queryListPlugins.split(";")));
        }
        return queryList;
    }

    private QueryEntity buildMainEntity() {
        QueryEntity queryEntity = new QueryEntity();
        String entityTypeName = this.mainEntityType.getName();
        queryEntity.setNumber(entityTypeName);
        queryEntity.setName(this.mainEntityType.getDisplayName().toString());
        queryEntity.setAlias(this.mainEntityType.getAlias());
        this.queryEntityMap.put(entityTypeName, queryEntity);
        return queryEntity;
    }

    private List<QueryEntity> buildSubQueryEntityList() {
        ArrayList<QueryEntity> result = new ArrayList<QueryEntity>(this.joinEntities.size());
        for (Map.Entry<String, JoinEntity> entry : this.joinEntities.entrySet()) {
            QueryEntity queryEntity = new QueryEntity();
            result.add(queryEntity);
            JoinEntity entity = entry.getValue();
            queryEntity.setNumber(entry.getKey());
            queryEntity.setName(entity.getDisplayName());
            queryEntity.setAlias(entity.getAlias());
            this.queryEntityMap.put(entry.getKey(), queryEntity);
            queryEntity.setRelationConditionList(this.buildConditionList(entity));
        }
        return result;
    }

    private List<RelationCondition> buildConditionList(JoinEntity entity) {
        String entityName = entity.getEntityName();
        List<QuerySourceJoinRelation> relations = this.joinRelations.get(entityName);
        if (CollectionUtils.isEmpty(relations)) {
            return new ArrayList<RelationCondition>(0);
        }
        ArrayList<RelationCondition> result = new ArrayList<RelationCondition>(relations.size());
        for (QuerySourceJoinRelation relation : relations) {
            List condition = relation.getCondition();
            for (QSConditionRow conditionRow : condition) {
                RelationCondition relationCondition = new RelationCondition();
                result.add(relationCondition);
                QSExpr leftItem = conditionRow.getLeftItem();
                String mainEntityProp = leftItem.toString();
                relationCondition.setMainEntityProp(mainEntityProp);
                IDataEntityProperty property = (IDataEntityProperty)this.mainEntityType.getProperties().get((Object)mainEntityProp);
                if (property != null) {
                    relationCondition.setMainEntityPropName(property.getDisplayName().toString());
                }
                QSExpr rightItem = conditionRow.getRightItem();
                String subEntityProp = rightItem.toString();
                relationCondition.setSubEntityProp(subEntityProp);
                relationCondition.setCondition(conditionRow.getCompareOp());
                Map<String, QuerySelectField> fieldMap = this.selectFieldMapMap.get(entityName);
                if (fieldMap == null) continue;
                String propName = subEntityProp.startsWith(entityName + ".") ? subEntityProp.substring(entityName.length() + 1) : subEntityProp;
                QuerySelectField field = fieldMap.get(propName);
                if (field != null) {
                    relationCondition.setSubEntityPropName(field.getLocaleDisplayName().toString());
                    continue;
                }
                relationCondition.setSubEntityPropName(this.genPropName(entityName, propName));
            }
        }
        return result;
    }

    private List<QueryField> buildQueryFieldList() {
        HashMap<String, Map> fieldParamMap;
        String bizEntityNumber = this.getRunParamStrByKey("bizEntityNumber");
        List fieldParamList = (List)((Map)this.getRunParamMap().get("data")).get("fieldParamList");
        if (fieldParamList == null) {
            fieldParamMap = new HashMap<String, Map>(0);
        } else {
            fieldParamMap = new HashMap(fieldParamList.size());
            for (Map fieldMap : fieldParamList) {
                fieldParamMap.put(MapUtils.getString((Map)fieldMap, (Object)"number"), fieldMap);
            }
        }
        LinkedList<QueryField> result = new LinkedList<QueryField>();
        for (Map.Entry<String, Map<String, QuerySelectField>> entry : this.selectFieldMapMap.entrySet()) {
            QueryField queryField;
            String entityType = entry.getKey();
            Map<String, QuerySelectField> fieldMap = entry.getValue();
            QueryEntity queryEntity = this.queryEntityMap.get(entityType);
            if (!entityType.equals(bizEntityNumber)) {
                for (Map.Entry<String, QuerySelectField> entry2 : fieldMap.entrySet()) {
                    queryField = new QueryField();
                    result.add(queryField);
                    queryField.setFieldNumber(entry2.getKey());
                    queryField.setFieldName(entry2.getValue().getLocaleDisplayName().toString());
                    queryField.setQueryEntity(queryEntity);
                }
                continue;
            }
            for (Map.Entry<String, QuerySelectField> entry3 : fieldMap.entrySet()) {
                String fieldKey = entry3.getKey();
                Map curFieldMap = (Map)fieldParamMap.remove(fieldKey);
                if (curFieldMap == null) {
                    QueryField queryField2 = new QueryField();
                    result.add(queryField2);
                    queryField2.setFieldNumber(entry3.getKey());
                    queryField2.setFieldName(entry3.getValue().getLocaleDisplayName().toString());
                    queryField2.setQueryEntity(queryEntity);
                    continue;
                }
                boolean isDelete = MapUtils.getBooleanValue((Map)curFieldMap, (Object)"delete", (boolean)false);
                if (isDelete) continue;
                QueryField queryField3 = new QueryField();
                result.add(queryField3);
                queryField3.setFieldNumber(fieldKey);
                queryField3.setQueryEntity(queryEntity);
                queryField3.setFieldName(MapUtils.getString((Map)curFieldMap, (Object)"name"));
            }
            for (Map.Entry<String, Object> entry4 : fieldParamMap.entrySet()) {
                queryField = new QueryField();
                result.add(queryField);
                queryField.setFieldNumber(entry4.getKey());
                queryField.setQueryEntity(queryEntity);
                queryField.setFieldName(MapUtils.getString((Map)((Map)entry4.getValue()), (Object)"name"));
            }
        }
        return result;
    }

    private void buildOps(QueryGenParam queryGenParam, Map<String, Object> sourceMetaData) {
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List editParamList = sourceDesignMetadataParser.getEntityMetadata();
        queryGenParam.setEntityOperationList((List)((Map)editParamList.get(0)).get("Operations"));
        queryGenParam.setPermissionItemsList((List)((Map)editParamList.get(0)).get("PermissionItems"));
    }

    private String genPropName(String entityName, String propName) {
        MainEntityType entityType = this.entityTypeCache.computeIfAbsent(entityName, ky -> MetadataServiceHelper.getDataEntityType((String)entityName));
        if (entityType == null) {
            return propName;
        }
        DynamicProperty property = entityType.getProperty(propName);
        return property.getDisplayName() == null ? propName : property.getDisplayName().toString();
    }
}

