/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.tools.impl;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.task.tools.IMetadataDomainService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.TableUtils;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class MetadataDomainServiceImpl
implements IMetadataDomainService {
    private static final Log logger = LogFactory.getLog(MetadataDomainServiceImpl.class);
    private static final String BOS_BIZAPP_ENTITY = "bos_devportal_bizapp";

    @Override
    public DynamicObject[] getBosFormBizAppNumberByBizAppIds(Set<String> ids) {
        IBaseEntityService appEventService = CommonEntityServiceFactory.getEntityService((String)BOS_BIZAPP_ENTITY);
        QFilter sonFilter = new QFilter("id", "in", ids);
        return appEventService.query("number", sonFilter.toArray());
    }

    @Override
    public DynamicObject[] getBosFormMetaByEntityNumbers(List<String> entityNumber) {
        HRBaseServiceHelper metaHelper = new HRBaseServiceHelper("bos_formmeta");
        QFilter sonFilter = new QFilter("number", "in", entityNumber);
        return metaHelper.query("number,bizappid", sonFilter.toArray());
    }

    @Override
    public void deleteMetadata(String number, boolean dropTable) {
        String id = MetadataDao.getIdByNumber((String)number, (MetaCategory)MetaCategory.Form);
        if (StringUtils.isNotEmpty((String)id)) {
            try {
                List entityTypeList = null;
                if (dropTable) {
                    entityTypeList = MetadataUtils.getEntityTypeList((String)number);
                }
                DevportalUtil.deletePage((String)id, null, (Boolean)false, null, (String)"0", (String)"PAGE_TYPE", (String)"bos_formmeta");
                if (CollectionUtils.isNotEmpty((Collection)entityTypeList)) {
                    for (MainEntityType mainEntityType : entityTypeList) {
                        TableUtils.dropTable((String)mainEntityType.getDBRouteKey(), (String)mainEntityType.getAlias());
                    }
                }
            }
            catch (Exception ex) {
                logger.error("deleteMetadata error\u3002 ", (Throwable)ex);
            }
        }
    }
}

