/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.task.tools.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.servicehelper.ISVServiceHelper;
import kd.hdtc.hrbm.business.common.util.SplitNumberUtil;
import kd.hdtc.hrbm.business.domain.task.tools.INumberGenerateDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class NumberGenerateDomainServiceImpl
implements INumberGenerateDomainService {
    private static final int LARGEST_LENGTH = 20;
    private boolean isKingdeeISV = true;
    private String currentIsv;

    @Override
    public Map<String, Map<String, String>> generateMulBySourceNumber(Set<String> sourceNumbers) {
        if (CollectionUtils.isEmpty(sourceNumbers)) {
            return null;
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(sourceNumbers.size());
        this.currentIsv = ISVServiceHelper.getISVInfo().getId();
        this.isKingdeeISV = ISVServiceHelper.isKingdeeISV();
        for (String sourceNumber : sourceNumbers) {
            HashMap<String, String> numberMap = new HashMap<String, String>(4);
            String number = sourceNumber;
            Function<String, String> mainFunc = this.getMainFunc();
            if (mainFunc != null) {
                number = mainFunc.apply(number);
            }
            number = this.setISVNumber(number);
            number = this.dealLargeNumber(number);
            numberMap.put("current_entity_number_func", number);
            Map<String, Function<String, String>> mulFunc = this.getMulFunc();
            if (CollectionUtils.isNotEmpty(mulFunc)) {
                for (Map.Entry<String, Function<String, String>> mFunc : mulFunc.entrySet()) {
                    if (mFunc.getValue() == null) continue;
                    numberMap.put(mFunc.getKey(), mFunc.getValue().apply(number));
                }
            }
            result.put(sourceNumber, numberMap);
        }
        return result;
    }

    @Override
    public Map<String, Map<String, String>> generateMulBySourceNumber(Set<String> sourceNumbers, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(sourceNumbers)) {
            return null;
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(sourceNumbers.size());
        this.currentIsv = ISVServiceHelper.getISVInfo().getId();
        this.isKingdeeISV = ISVServiceHelper.isKingdeeISV();
        Iterator<String> iterator = sourceNumbers.iterator();
        while (iterator.hasNext()) {
            String sourceNumber;
            String number = sourceNumber = iterator.next();
            HashMap<String, String> numberMap = new HashMap<String, String>(4);
            Function<String, String> mainFunc = this.getMainFunc();
            if (mainFunc != null) {
                number = mainFunc.apply(sourceNumber);
            }
            number = this.setISVNumber(number);
            number = this.dealLargeNumber(number);
            numberMap.put("current_entity_number_func", number);
            Map<String, Function<String, String>> mulFunc = this.getMulFunc(params);
            if (CollectionUtils.isNotEmpty(mulFunc)) {
                for (Map.Entry<String, Function<String, String>> mFunc : mulFunc.entrySet()) {
                    if (mFunc.getValue() == null) continue;
                    numberMap.put(mFunc.getKey(), mFunc.getValue().apply(number));
                }
            }
            result.put(sourceNumber, numberMap);
        }
        return result;
    }

    protected Function<String, String> getMainFunc() {
        return null;
    }

    protected Map<String, Function<String, String>> getMulFunc() {
        return null;
    }

    protected int getLargestLength() {
        return 20;
    }

    protected Map<String, Function<String, String>> getMulFunc(Map<String, Object> params) {
        return null;
    }

    private String setISVNumber(String number) {
        if (!this.isKingdeeISV && StringUtils.isNotEmpty((String)number) && !number.startsWith(this.currentIsv)) {
            number = this.currentIsv + "_" + number;
        }
        return number;
    }

    public String dealLargeNumber(String number) {
        int largestNumberLeg = this.getLargestLength();
        if (StringUtils.isEmpty((String)number)) {
            return number;
        }
        return SplitNumberUtil.getSplitNumber(number, largestNumberLeg);
    }
}

