/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.business.domain.tool.impl;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.tool.IBosEntityObjectEntityService;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;

public class BosEntityObjectEntityServiceImpl
extends AbstractBaseEntityService
implements IBosEntityObjectEntityService {
    private static final String BOS_ENTITY_OBJECT = "bos_entityobject";
    private static final String SELECT_COMMON_FIELDS = String.join((CharSequence)",", "id", "name", "number");

    public BosEntityObjectEntityServiceImpl() {
        super(BOS_ENTITY_OBJECT);
    }

    @Override
    public DynamicObject queryOneByNumber(String entityNumber) {
        QFilter intSourceIdFilter = new QFilter("number", "=", (Object)entityNumber);
        return this.queryOne(SELECT_COMMON_FIELDS, new QFilter[]{intSourceIdFilter});
    }

    @Override
    public Map<String, DynamicObject> queryOneByNumberList(List<String> entityNumberList) {
        QFilter intSourceIdFilter = new QFilter("number", "in", entityNumberList);
        DynamicObject[] dys = this.query(SELECT_COMMON_FIELDS, new QFilter[]{intSourceIdFilter});
        HashMap numberDyMap = Maps.newHashMapWithExpectedSize((int)dys.length);
        for (DynamicObject dy : dys) {
            numberDyMap.put(dy.getString("number"), dy);
        }
        return numberDyMap;
    }
}

