/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.card;

import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.form.FormView;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.ISceneCardConfigDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.formplugin.web.card.BizModelCardParamBean;
import kd.hdtc.hrbm.formplugin.web.card.IBizModelCardJumpStrategy;
import kd.hr.hbp.common.util.HRObjectUtils;

public abstract class AbstractBizModelCardJumpStrategy
implements IBizModelCardJumpStrategy {
    private static final Log LOG = LogFactory.getLog(AbstractBizModelCardJumpStrategy.class);
    private final ISceneCardConfigDomainService sceneCardConfigDomainService = (ISceneCardConfigDomainService)ServiceFactory.getService(ISceneCardConfigDomainService.class);
    protected BizModelCardParamBean bizModelCardParamBean;

    public AbstractBizModelCardJumpStrategy(BizModelCardParamBean bizModelCardParamBean) {
        this.bizModelCardParamBean = bizModelCardParamBean;
    }

    @Override
    public void handleCloseCallBack(IFormView view, Map<String, Object> returnData) {
        if (this.isValidate(view)) {
            BillShowParameter baseShowParameter;
            DynamicObject sceneCardConfig = this.bizModelCardParamBean.getSceneCardConfig();
            BizModelDataBean bizModelDataBean = this.bizModelCardParamBean.getBizModelDataBean();
            if (HRObjectUtils.isEmpty((Object)sceneCardConfig)) {
                LOG.info("bizModelAllLineLog about AbstractBizModelCardJumpStrategy.handleCloseCallBack() is end because of sceneCardConfig is null");
                return;
            }
            String cardJumpType = sceneCardConfig.getString("cardjumptype");
            if ("1010".equals(cardJumpType)) {
                baseShowParameter = new BillShowParameter();
                baseShowParameter.setFormId("hrbm_logicentity_display");
                if (this.bizModelCardParamBean.getLogicEntityId() != null) {
                    baseShowParameter.setPkId((Object)this.bizModelCardParamBean.getLogicEntityId());
                    baseShowParameter.setStatus(OperationStatus.VIEW);
                }
                this.initCustomParams((FormShowParameter)baseShowParameter);
                this.buildFormShowParameter((FormShowParameter)baseShowParameter, returnData);
                view.getPageCache().put("logicentitydisplaypageid", baseShowParameter.getPageId());
                if ("hrbm_sclogicard".equals(((FormView)view).getFormId())) {
                    this.sendFormAction(view, baseShowParameter);
                } else {
                    view.showForm((FormShowParameter)baseShowParameter);
                }
            }
            if ("1020".equals(cardJumpType)) {
                baseShowParameter = new FormShowParameter();
                baseShowParameter.setFormId("hrbm_allextcaseop");
                if (bizModelDataBean.getBizModelType() == BizModelTypeEnum.LOGIC_ENTITY) {
                    DynamicObject mainCard = this.sceneCardConfigDomainService.getMainCardFromBizObj(bizModelDataBean.getBizModel(), this.bizModelCardParamBean.getCurrentNodeId());
                    if (!HRObjectUtils.isEmpty((Object)mainCard)) {
                        baseShowParameter.setCustomParam("mainCardId", (Object)mainCard.getString("id"));
                        baseShowParameter.setCustomParam("bizobj", (Object)this.bizModelCardParamBean.getCurrentNodeId());
                        baseShowParameter.setCustomParam("id", (Object)this.bizModelCardParamBean.getCurrentNodeId());
                        this.initCustomParams((FormShowParameter)baseShowParameter);
                        this.buildFormShowParameter((FormShowParameter)baseShowParameter, returnData);
                        view.getPageCache().put("cardfuncpageid", baseShowParameter.getPageId());
                        view.showForm((FormShowParameter)baseShowParameter);
                    } else {
                        view.showTipNotification(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u4e3b\u5361\u7247\uff0c\u8bf7\u67e5\u770b\u5361\u7247\u8303\u56f4\u914d\u7f6e\u662f\u5426\u6b63\u786e", (String)"AbstractBizModelCardJumpStrategy_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
                    }
                }
            }
        }
    }

    protected boolean isValidate(IFormView view) {
        return true;
    }

    protected abstract void buildFormShowParameter(FormShowParameter var1, Map<String, Object> var2);

    private void initCustomParams(FormShowParameter baseShowParameter) {
        if (this.bizModelCardParamBean == null) {
            return;
        }
        baseShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        baseShowParameter.setHasRight(false);
        BizModelDataBean bizModelDataBean = this.bizModelCardParamBean.getBizModelDataBean();
        DynamicObject extCase = this.bizModelCardParamBean.getExtCase();
        if (bizModelDataBean != null) {
            BizModelTypeEnum bizModelType = bizModelDataBean.getBizModelType();
            DynamicObject bizModel = bizModelDataBean.getBizModel();
            baseShowParameter.setCustomParam("bizmodeltype", (Object)String.valueOf(bizModelType.getLevel()));
            baseShowParameter.setCustomParam("bizmodel", (Object)String.valueOf(bizModel.getLong("id")));
        }
        if (this.bizModelCardParamBean.getSceneCardConfig() != null) {
            baseShowParameter.setCustomParam("sceneCardconfigid", (Object)String.valueOf(this.bizModelCardParamBean.getSceneCardConfig().getLong("id")));
        }
        if (extCase != null) {
            LOG.info("bizModelAllLineLog about AbstractBizModelCardJumpStrategy.initCustomParams(): extCaseNumber:{},extCaseName:{}", (Object)extCase.getString("number"), (Object)extCase.getString("name"));
            baseShowParameter.setCustomParam("logicentity_extCaseKey", (Object)String.valueOf(extCase.getLong("id")));
        }
        if (this.bizModelCardParamBean.getCurrentNodeId() != null && this.bizModelCardParamBean.getCurrentNodeId() != 0L) {
            baseShowParameter.setCustomParam("curnodeid", (Object)this.bizModelCardParamBean.getCurrentNodeId());
        }
        if (this.bizModelCardParamBean.getCustomParamMap() != null) {
            baseShowParameter.getCustomParams().putAll(this.bizModelCardParamBean.getCustomParamMap());
        }
        baseShowParameter.setCustomParam("opentype", (Object)"bizmode");
    }

    private void sendFormAction(IFormView view, BillShowParameter baseShowParameter) {
        IFormView parentView = view.getParentView();
        if (parentView != null && parentView.getParentView() != null) {
            parentView.showForm((FormShowParameter)baseShowParameter);
            view.sendFormAction(parentView);
        } else {
            view.showTipNotification(ResManager.loadKDString((String)"\u7236\u9875\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u6253\u5f00\u65b0\u7684\u9875\u9762", (String)"BizModelLogicCardEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
        }
    }
}

