/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.card;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.IBizObjEntityService;
import kd.hdtc.hrbm.formplugin.web.card.AbstractBizModelCardJumpStrategy;
import kd.hdtc.hrbm.formplugin.web.card.BizModelCardParamBean;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class QuestBizModelCardJumpStrategy
extends AbstractBizModelCardJumpStrategy {
    private static final Log LOG = LogFactory.getLog(QuestBizModelCardJumpStrategy.class);
    protected static final String ADD_SON_LOGIC_ENTITY_CARD = "addsonlogicentity_card";
    private final IBizObjEntityService bizObjEntityService = (IBizObjEntityService)ServiceFactory.getService(IBizObjEntityService.class);
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);

    public QuestBizModelCardJumpStrategy(BizModelCardParamBean bizModelCardParamBean) {
        super(bizModelCardParamBean);
    }

    @Override
    public FormShowParameter handleJumpFormShowParameter(IFormPlugin plugin) {
        BizModelCardParamBean bizModelCardParamBean = this.bizModelCardParamBean;
        DynamicObject bizObjDy = this.bizObjEntityService.query("classify,tempmapple,questionnaire,type", (Object)bizModelCardParamBean.getCurrentNodeId());
        String questionnaire = bizObjDy.getString("questionnaire");
        LOG.info("bizModelAllLineLog about QuestBizModelCardJumpStrategy.handleJumpFormShowParameter(): questionnaire:{}", (Object)questionnaire);
        FormShowParameter formShowParameter = new FormShowParameter();
        if (HRStringUtils.isNotEmpty((String)questionnaire)) {
            formShowParameter.setHasRight(false);
            formShowParameter.setCustomParam("opentype", (Object)"bizmode");
            formShowParameter.setCustomParam("curnodeid", (Object)String.valueOf(bizModelCardParamBean.getCurrentNodeId()));
            formShowParameter.setCustomParam("mainentity", (Object)this.getMainLogicEntityId(bizModelCardParamBean.getCurrentNodeId()));
            formShowParameter.setCustomParam("sceneCardconfigid", (Object)bizModelCardParamBean.getSceneCardConfig().getString("id"));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setFormId(questionnaire);
            formShowParameter.setCloseCallBack(new CloseCallBack(plugin, ADD_SON_LOGIC_ENTITY_CARD));
        }
        return formShowParameter;
    }

    @Override
    protected void buildFormShowParameter(FormShowParameter baseShowParameter, Map<String, Object> returnData) {
        baseShowParameter.getCustomParams().putAll(returnData);
    }

    @Override
    public String getReturnActionId() {
        return ADD_SON_LOGIC_ENTITY_CARD;
    }

    private String getMainLogicEntityId(Long curNodeId) {
        Object[] rootLogicEntity = this.logicEntityDomainService.getRootLogicEntityByBizObjId(curNodeId.longValue());
        if (!HRArrayUtils.isEmpty((Object[])rootLogicEntity)) {
            return rootLogicEntity[0].getString("id");
        }
        LOG.info("bizModelAllLineLog about QuestBizModelCardJumpStrategy.getMainLogicEntityId(): the curNodeId:{} mainLogicEntityId is null return", (Object)curNodeId);
        return null;
    }
}

