/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.common.metadatafield.fielditem;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class BaseDataPropItemsEditPlugin
extends AbstractHDTCFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String ALIAS = "alias";
    private static final String CAPTION = "caption";
    private static final String REF_BASE_FIELD = "refbasefield";
    private static final String REF_DISPLAY_PROP = "refdisplayprop";
    private static final String BASEDATA_PROP_FIELD = "BasedataPropField";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object data = customParams.get("value");
        Map baseDataMap = (Map)customParams.get("baseDataMap");
        List<ComboItem> comboItems = this.generateBaseDataComboItemList(baseDataMap);
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(REF_BASE_FIELD);
        comboEdit.setComboItems(comboItems);
        if (data instanceof Map) {
            Map baseData = (Map)data;
            String baseDataNumber = (String)baseData.get("baseDataNumber");
            if (HRStringUtils.isNotEmpty((String)baseDataNumber) && CollectionUtils.isNotEmpty((Map)baseDataMap)) {
                ComboEdit propComboEdit = (ComboEdit)this.getView().getControl(REF_DISPLAY_PROP);
                List<ComboItem> propComboItems = this.generatePropComboItemList(baseDataNumber, (Map)baseDataMap.get(baseDataNumber));
                propComboEdit.setComboItems(propComboItems);
                this.getModel().setValue(REF_BASE_FIELD, (Object)baseDataNumber);
            }
            this.getModel().setValue(REF_DISPLAY_PROP, baseData.get("baseDataPropNumber"));
        }
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyKey = propertyChangedArgs.getProperty().getName();
        if (HRStringUtils.equals((String)REF_BASE_FIELD, (String)propertyKey)) {
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl(REF_DISPLAY_PROP);
            String refBaseFieldNumber = (String)this.getModel().getValue(REF_BASE_FIELD);
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            Map baseDataMap = (Map)customParams.get("baseDataMap");
            List<ComboItem> comboItems = this.generatePropComboItemList(refBaseFieldNumber, (Map)baseDataMap.get(refBaseFieldNumber));
            comboEdit.setComboItems(comboItems);
            this.getModel().setValue(REF_DISPLAY_PROP, null);
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
            }
        }
    }

    private void returnData() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String refBaseField = dataEntity.getString(REF_BASE_FIELD);
        String refDisplayProp = dataEntity.getString(REF_DISPLAY_PROP);
        if (HRStringUtils.isEmpty((String)refBaseField) || HRStringUtils.isEmpty((String)refDisplayProp)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u6216\u663e\u793a\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u5e76\u4fee\u6539\u3002", (String)"BaseDataPropItemsEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("type", BASEDATA_PROP_FIELD);
        StringBuilder builder = new StringBuilder();
        Map<String, String> items = this.getItems(refBaseField, refDisplayProp);
        String caption = builder.append(items.get("baseDataName")).append(".").append(items.get("baseDataPropName")).toString();
        items.put(CAPTION, caption);
        result.put(ALIAS, caption);
        result.put("value", SerializationUtils.toJsonString(items));
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private Map<String, String> getItems(String refBaseField, String refDisplayProp) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Map baseDataMap = (Map)customParams.get("baseDataMap");
        Map baseData = (Map)baseDataMap.get(refBaseField);
        HashMap items = Maps.newHashMapWithExpectedSize((int)4);
        items.put("baseDataNumber", refBaseField);
        items.put("baseDataName", baseData.get("ename"));
        items.put("baseDataPropNumber", refDisplayProp);
        items.put("baseDataPropName", this.getBaseDataPropName(refDisplayProp, (String)baseData.get("baseEntityId")));
        return items;
    }

    private List<ComboItem> generateBaseDataComboItemList(Map<String, Map<String, String>> baseDataMap) {
        if (CollectionUtils.isEmpty(baseDataMap)) {
            return new ArrayList<ComboItem>();
        }
        ArrayList items = Lists.newArrayListWithExpectedSize((int)baseDataMap.size());
        for (Map<String, String> comboMap : baseDataMap.values()) {
            if (!HRStringUtils.isNotEmpty((String)comboMap.get("ename"))) continue;
            ComboItem comboItem = new ComboItem(new LocaleString(comboMap.get("ename")), comboMap.get("epropkey"));
            items.add(comboItem);
        }
        return items;
    }

    private List<ComboItem> generatePropComboItemList(String refBaseFieldNumber, Map<String, String> baseData) {
        if (HRStringUtils.isEmpty((String)refBaseFieldNumber)) {
            return new ArrayList<ComboItem>();
        }
        if (CollectionUtils.isEmpty(baseData)) {
            return new ArrayList<ComboItem>();
        }
        String entityId = baseData.get("baseEntityId");
        if (HRStringUtils.isEmpty((String)entityId)) {
            return new ArrayList<ComboItem>();
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        Map allFields = mainEntityType.getAllFields();
        ArrayList items = Lists.newArrayListWithExpectedSize((int)allFields.size());
        for (IDataEntityProperty field : allFields.values()) {
            if (field.isDbIgnore()) continue;
            ComboItem comboItem = new ComboItem(field.getDisplayName(), field.getName());
            items.add(comboItem);
        }
        return items;
    }

    private String getBaseDataPropName(String refBaseFieldNumber, String entityId) {
        String baseDataPropName = "";
        if (HRStringUtils.isEmpty((String)refBaseFieldNumber)) {
            return baseDataPropName;
        }
        if (HRStringUtils.isEmpty((String)entityId)) {
            return baseDataPropName;
        }
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityTypeById((String)entityId);
        Map allFields = mainEntityType.getAllFields();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)allFields.get(refBaseFieldNumber);
        if (iDataEntityProperty == null) {
            return baseDataPropName;
        }
        baseDataPropName = iDataEntityProperty.getDisplayName().getLocaleValue();
        return baseDataPropName;
    }
}

