/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.common.metadatafield.fielditem;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.CollectionPropertyAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.ListDcxmlBinder;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.Control;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class ComboFieldItemsEditPlugin
extends AbstractHDTCFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String VALUE = "value";
    private static final String CAPTION = "caption";
    private static final String ALIAS = "alias";
    private static final String ITEMS = "items";
    private static final String COMBO_FIELD_TYPE = "ComboField";
    private static final String ITEM_VISIBLE = "itemvisible";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
            }
        }
    }

    public void afterCreateNewData(EventObject eventObject) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        List items = (List)(value instanceof List ? value : new ArrayList());
        if (items.size() > 0) {
            IDataModel model = this.getModel();
            int[] rowIndexs = model.batchCreateNewEntryRow("entryentity", items.size());
            for (int i = 0; i < items.size(); ++i) {
                Map item = (Map)items.get(i);
                Map caption = (Map)item.get(CAPTION);
                for (Map.Entry stringStringEntry : caption.entrySet()) {
                    model.setValue(CAPTION, stringStringEntry.getValue(), rowIndexs[i]);
                }
                model.setValue(VALUE, item.get(VALUE), rowIndexs[i]);
                model.setValue(ITEM_VISIBLE, item.get(ITEM_VISIBLE), rowIndexs[i]);
            }
        }
        this.getPageCache().put(VALUE, SerializationUtils.toJsonString((Object)items));
    }

    public void propertyChanged(PropertyChangedArgs args) {
        if (args.getProperty().getName().equals(VALUE)) {
            ChangeData data = args.getChangeSet()[0];
            Object val = data.getNewValue();
            IDataModel model = this.getModel();
            int currentIndex = model.getEntryCurrentRowIndex("entryentity");
            DynamicObjectCollection entryEntity = model.getEntryEntity("entryentity");
            if (entryEntity != null) {
                for (int i = 0; i < entryEntity.size(); ++i) {
                    DynamicObject row = (DynamicObject)entryEntity.get(i);
                    if (i == currentIndex || !val.equals(row.getString(VALUE))) continue;
                    String showInfo = ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u201c\u4e0b\u62c9\u503c\u201d\u4e0e\u7b2c%2$s\u884c\u91cd\u590d\u3002", (String)"ComboFieldItemsEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);
                    this.getView().showErrorNotification(String.format(showInfo, currentIndex + 1, i + 1));
                    return;
                }
            }
        }
    }

    private void returnData() {
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("type", COMBO_FIELD_TYPE);
        Object items = this.getComboItems();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        if (entryEntity != null) {
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject row = (DynamicObject)entryEntity.get(i);
                if (!HRStringUtils.isEmpty((String)row.getString(VALUE))) continue;
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u4e0b\u62c9\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a", (String)"ComboFieldItemsEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        result.put(VALUE, SerializationUtils.toJsonString((Object)items));
        result.put(ALIAS, this.getComboAlias());
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private Object getComboItems() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        IDataModel model = this.getModel();
        DynamicObjectCollection rowKeyObjects = model.getEntryEntity("entryentity");
        if (rowKeyObjects != null) {
            for (int i = 0; i < rowKeyObjects.size(); ++i) {
                DynamicObject rowKeyObject = (DynamicObject)rowKeyObjects.get(i);
                String value = rowKeyObject.getString(VALUE);
                String caption = rowKeyObject.getString(CAPTION);
                boolean itemVisible = rowKeyObject.getBoolean(ITEM_VISIBLE);
                items.add(new ComboItem(i, new LocaleString(caption), (Object)value, null, itemVisible));
            }
        }
        ComboJsonSerializer comboJsonSerializer = new ComboJsonSerializer();
        comboJsonSerializer.setItems(items);
        ArrayList dts = Lists.newArrayListWithCapacity((int)4);
        dts.add(OrmUtils.getDataEntityType(ComboJsonSerializer.class));
        DcJsonSerializer serializer = new DcJsonSerializer((DcBinder)new ListDcxmlBinder(false, (Iterable)dts));
        Map mapCombo = serializer.serializeToMap((Object)comboJsonSerializer, null);
        return mapCombo.getOrDefault(ITEMS, items);
    }

    private String getComboAlias() {
        String alias = "";
        IDataModel model = this.getModel();
        DynamicObjectCollection rowKeyObjs = model.getEntryEntity("entryentity");
        if (rowKeyObjs != null) {
            for (DynamicObject rowKeyObj : rowKeyObjs) {
                alias = (alias.equals("") ? alias : alias + ",") + rowKeyObj.getString(CAPTION);
            }
        }
        return alias;
    }

    public static class ComboJsonSerializer {
        private List<ComboItem> items = new ArrayList<ComboItem>();

        @CollectionPropertyAttribute(collectionItemPropertyType=ComboItem.class)
        public List<ComboItem> getItems() {
            return this.items;
        }

        public void setItems(List<ComboItem> items) {
            this.items = items;
        }
    }
}

