/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.common.metadatafield.fielditem;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.Control;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;

public class DataBaseFieldItemsEditPlugin
extends AbstractHDTCFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String VALUE = "value";
    private static final String CAPTION = "caption";
    private static final String ALIAS = "alias";
    private static final String BASE_DATA_FIELD = "basedatafield";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    protected String getDatabaseFieldType() {
        return "BasedataField";
    }

    public void afterCreateNewData(EventObject e) {
        Object value = this.getView().getFormShowParameter().getCustomParams().get(VALUE);
        IDataModel model = this.getModel();
        if (value instanceof Map) {
            Map result = (Map)value;
            model.setValue(BASE_DATA_FIELD, result.get("id"));
            this.getPageCache().put(VALUE, SerializationUtils.toJsonString((Object)result));
        }
    }

    public void click(EventObject evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.returnData();
            }
        }
    }

    private void returnData() {
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put("type", this.getDatabaseFieldType());
        Map<String, Object> items = this.getItems();
        result.put(VALUE, SerializationUtils.toJsonString(items));
        result.put(ALIAS, items.get(CAPTION));
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private Map<String, Object> getItems() {
        HashMap<String, Object> items = new HashMap<String, Object>(16);
        IDataModel model = this.getModel();
        DynamicObject dynamicObject = model.getDataEntity().getDynamicObject(BASE_DATA_FIELD);
        if (dynamicObject == null) {
            return items;
        }
        items.put(VALUE, dynamicObject.getString("dentityid"));
        items.put("id", dynamicObject.getString("id"));
        items.put(CAPTION, dynamicObject.getLocaleString("name"));
        return items;
    }
}

