/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.common.metadatafield.fielditem;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;

public class TextItemsEditPlugin
extends AbstractHDTCFormPlugin {
    private static final String BTN_OK = "btnok";
    private static final String ALIAS = "alias";
    private static final String MAX_LENGTH = "MaxLength";
    private static final String MIN_LENGTH = "MinLength";

    public void initialize() {
        this.addClickListeners(new String[]{BTN_OK});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object data = customParams.get("value");
        if (data instanceof Map) {
            Map value = (Map)data;
            this.getModel().setValue(MAX_LENGTH, value.get(MAX_LENGTH));
            this.getModel().setValue(MIN_LENGTH, value.get(MIN_LENGTH));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        ValidateResultCollection validateResult = afterDoOperationEventArgs.getOperationResult().getValidateResult();
        if (CollectionUtils.isEmpty((Collection)validateResult.getValidateErrors())) {
            String type = (String)this.getView().getFormShowParameter().getCustomParams().get("type");
            if (BTN_OK.equals(operateKey)) {
                this.returnData(type);
            }
        }
    }

    private void returnData(String type) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        int maxLength = dataEntity.getInt(MAX_LENGTH);
        int minLength = dataEntity.getInt(MIN_LENGTH);
        if (minLength > maxLength) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6700\u5c0f\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e\u6700\u5927\u957f\u5ea6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TextItemsEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        StringBuilder builder = new StringBuilder("[");
        result.put("type", type);
        Map<String, Integer> items = this.getItems(minLength, maxLength);
        result.put("value", SerializationUtils.toJsonString(items));
        result.put(ALIAS, builder.append(minLength).append(",").append(maxLength).append("]").toString());
        this.getView().returnDataToParent(result);
        this.getView().close();
    }

    private Map<String, Integer> getItems(int minLength, int maxLength) {
        HashMap items = Maps.newHashMapWithExpectedSize((int)4);
        items.put(MAX_LENGTH, maxLength);
        items.put(MIN_LENGTH, minLength);
        return items;
    }
}

