/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.extcase;

import java.security.SecureRandom;
import java.util.Collection;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.bean.SceneCardConfigBean;
import kd.hdtc.hrbm.business.domain.extcase.entity.ISceneCardConfigEntityService;
import kd.hdtc.hrbm.business.domain.extcase.wtc.IWtcFormulaConfigDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizModelDataDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.common.enums.SceneCardConfigEnum;
import kd.hdtc.hrbm.formplugin.web.card.BizModelCardJumpStrategyFactory;
import kd.hdtc.hrbm.formplugin.web.card.BizModelCardParamBean;
import kd.hdtc.hrbm.formplugin.web.card.IBizModelCardJumpStrategy;
import kd.hdtc.hrbm.formplugin.web.logicentity.BizModelExtCaseEditPlugin;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelLogicCardEditPlugin
extends AbstractHDTCFormPlugin {
    private static final String RANDOM = "random";
    private static final String SHOW_DATA = "showData";
    private static final String COIN_TYPE = "coinType";
    private static final String CONTENT_ID = "contentId";
    private static final String ENTITY = "entity";
    private static final String CUSTOM_CONTROL_AP = "customcontrolap";
    private static final String CLICK_CARD_HANDLE = "clickCardHandle";
    private static final Log LOG = LogFactory.getLog(BizModelExtCaseEditPlugin.class);
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IBizModelDataDomainService bizModelDataDomainService = (IBizModelDataDomainService)ServiceFactory.getService(IBizModelDataDomainService.class);
    private final ISceneCardConfigEntityService sceneCardConfigEntityService = (ISceneCardConfigEntityService)ServiceFactory.getService(ISceneCardConfigEntityService.class);
    private final IWtcFormulaConfigDomainService wtcFormulaConfigDomainService = (IWtcFormulaConfigDomainService)ServiceFactory.getService(IWtcFormulaConfigDomainService.class);

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initFieldData();
    }

    private void initFieldData() {
        List<SceneCardConfigBean> list;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        List relModelCardIdList = (List)formShowParameter.getCustomParam("relModelCardIdList");
        Object[] sceneCardConfigs = this.sceneCardConfigEntityService.queryByIdList((Collection)relModelCardIdList);
        if (HRArrayUtils.isEmpty((Object[])sceneCardConfigs)) {
            LOG.info("BizModelLogicCardEditPlugin.initFieldData relModelCardIdList is empty");
        }
        if (CollectionUtils.isNotEmpty(list = Stream.of(sceneCardConfigs).map(this::getSceneCardConfigBean).sorted(Comparator.comparingInt(SceneCardConfigBean::getIndex)).collect(Collectors.toList()))) {
            LOG.info("BizModelLogicCardEditPlugin.initFieldData relModelCardIdList size is {}", (Object)list.size());
        }
        this.renderCustomApData(CUSTOM_CONTROL_AP, null, list);
    }

    public void customEvent(CustomEventArgs event) {
        String eventName = event.getEventName();
        if (CLICK_CARD_HANDLE.equals(eventName)) {
            this.clickCardHandle(event);
        }
    }

    private void clickCardHandle(CustomEventArgs event) {
        String eventArgs = event.getEventArgs();
        Map params = (Map)JsonUtils.castType((String)eventArgs, Map.class);
        String sceneCardConfigId = String.valueOf(params.get("id"));
        if (StringUtils.isEmpty((String)sceneCardConfigId)) {
            return;
        }
        DynamicObject sceneCardConfig = this.sceneCardConfigEntityService.queryById(Long.valueOf(Long.parseLong(sceneCardConfigId)));
        if (sceneCardConfig == null) {
            return;
        }
        if ((SceneCardConfigEnum.WTC_RULE.getStrId().equals(sceneCardConfigId) || "2011775336349588480".equals(sceneCardConfigId)) && !this.wtcFormulaConfigDomainService.isRetrievalOpen().booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u529f\u80fd\u6682\u672a\u5f00\u653e\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"BizModelExtCaseEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return;
        }
        BizModelCardParamBean bizModelCardParamBean = new BizModelCardParamBean();
        bizModelCardParamBean.setCurrentNodeId(this.getCurNodeId(sceneCardConfig));
        bizModelCardParamBean.setSceneCardConfig(sceneCardConfig);
        bizModelCardParamBean.setBizModelDataBean(this.bizModelDataDomainService.getBizModelInfoById(this.getCurNodeType(sceneCardConfig), (Object)this.getCurNodeId(sceneCardConfig)));
        IBizModelCardJumpStrategy generate = BizModelCardJumpStrategyFactory.generate(bizModelCardParamBean);
        FormShowParameter formShowParameter = generate.handleJumpFormShowParameter((IFormPlugin)this);
        if (ShowType.MainNewTabPage.equals((Object)formShowParameter.getOpenStyle().getShowType())) {
            IFormView parentView = this.getView().getParentView();
            if (parentView != null && parentView.getParentView() != null) {
                parentView = parentView.getParentView();
                parentView.showForm(formShowParameter);
                this.getView().sendFormAction(parentView);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7236\u9875\u9762\u5df2\u5173\u95ed\uff0c\u65e0\u6cd5\u6253\u5f00\u65b0\u7684\u9875\u9762", (String)"BizModelLogicCardEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showForm(formShowParameter);
        }
    }

    private Long getCurNodeId(DynamicObject sceneCardConfig) {
        DynamicObject bdDy;
        Long curNodeId = 0L;
        DynamicObjectCollection dynamicObjectCollection = sceneCardConfig.getDynamicObjectCollection("bdentryentity");
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection) && (bdDy = (DynamicObject)dynamicObjectCollection.get(0)).getDynamicObject("bizmodel") != null) {
            curNodeId = bdDy.getLong("bizmodel.id");
        }
        return curNodeId;
    }

    private BizModelTypeEnum getCurNodeType(DynamicObject sceneCardConfig) {
        String bizModelType = "";
        DynamicObjectCollection dynamicObjectCollection = sceneCardConfig.getDynamicObjectCollection("bdentryentity");
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            DynamicObject bdDy = (DynamicObject)dynamicObjectCollection.get(0);
            bizModelType = bdDy.getString("bizmodeltype");
        }
        return BizModelTypeEnum.getBizModelTypeByType((String)bizModelType);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String sceneCardConfigId = (String)returnData.get("sceneCardconfigid");
        if (HRStringUtils.isNotEmpty((String)sceneCardConfigId)) {
            DynamicObject sceneCardConfig = this.sceneCardConfigEntityService.queryById(Long.valueOf(Long.parseLong(sceneCardConfigId)));
            Long logicEntityId = (Long)returnData.get("logicntityid");
            Long currentNodeId = this.getCurNodeId(sceneCardConfig);
            BizModelCardParamBean bizModelCardParamBean = new BizModelCardParamBean();
            bizModelCardParamBean.setCurrentNodeId(currentNodeId);
            bizModelCardParamBean.setSceneCardConfig(sceneCardConfig);
            if (logicEntityId != null) {
                bizModelCardParamBean.setLogicEntityId(logicEntityId);
            }
            bizModelCardParamBean.setBizModelDataBean(this.getBizModelDataBean(logicEntityId, currentNodeId, this.getCurNodeType(sceneCardConfig)));
            IBizModelCardJumpStrategy generate = BizModelCardJumpStrategyFactory.generate(bizModelCardParamBean);
            if (generate.getReturnActionId().equals(closedCallBackEvent.getActionId())) {
                DynamicObject extCase = this.getExtCase(logicEntityId, sceneCardConfig);
                bizModelCardParamBean.setExtCase(extCase);
                generate.handleCloseCallBack(this.getView(), returnData);
            }
        }
    }

    private BizModelDataBean getBizModelDataBean(Long logicEntityId, Long bizModelId, BizModelTypeEnum curNodeType) {
        BizModelDataBean bizModelDataBean;
        if (logicEntityId != null && logicEntityId != 0L) {
            DynamicObject bizModel = this.logicEntityDomainService.getLogicEntityInfoById((Object)logicEntityId);
            bizModelDataBean = new BizModelDataBean(BizModelTypeEnum.LOGIC_ENTITY, bizModel);
        } else {
            bizModelDataBean = this.bizModelDataDomainService.getBizModelInfoById(curNodeType, (Object)bizModelId);
        }
        return bizModelDataBean;
    }

    private DynamicObject getExtCase(Long logicEntityId, DynamicObject sceneCardConfig) {
        if (!HRObjectUtils.isEmpty((Object)sceneCardConfig)) {
            DynamicObjectCollection containCaseCollection = sceneCardConfig.getDynamicObjectCollection("containcase");
            if (CollectionUtils.isEmpty((Collection)containCaseCollection)) {
                return null;
            }
            if (containCaseCollection.size() == 1) {
                return ((DynamicObject)containCaseCollection.get(0)).getDynamicObject("fbasedataid");
            }
            DynamicObject logicEntityInfo = this.logicEntityDomainService.getLogicEntityInfoById((Object)logicEntityId);
            if (HRObjectUtils.isEmpty((Object)logicEntityInfo)) {
                return null;
            }
            List extCaseList = containCaseCollection.stream().filter(containCase -> IsvUtils.isCurrentIsv((String)logicEntityInfo.getString("isv")) == containCase.getDynamicObject("fbasedataid").getBoolean("currentisv")).map(extCase -> extCase.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(extCaseList)) {
                return (DynamicObject)extCaseList.get(0);
            }
        }
        return null;
    }

    private SceneCardConfigBean getSceneCardConfigBean(DynamicObject sceneCardConfig) {
        SceneCardConfigBean sceneCardConfigBean = new SceneCardConfigBean();
        sceneCardConfigBean.setId(sceneCardConfig.getString("id"));
        sceneCardConfigBean.setCurrentName(sceneCardConfig.getString("name"));
        sceneCardConfigBean.setNumber(sceneCardConfig.getString("number"));
        sceneCardConfigBean.setCardClassify(sceneCardConfig.getString("cardclassify"));
        sceneCardConfigBean.setCurrentDescription(sceneCardConfig.getString("description"));
        sceneCardConfigBean.setIndex(Integer.valueOf(sceneCardConfig.getInt("index")));
        return sceneCardConfigBean;
    }

    private void renderCustomApData(String apId, String coinType, List<SceneCardConfigBean> showDataList) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(apId);
        if (customcontrol == null) {
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(RANDOM, new SecureRandom().nextInt(10000000));
        result.put(SHOW_DATA, showDataList);
        result.put(CONTENT_ID, apId);
        if (StringUtils.isNotEmpty((String)coinType)) {
            result.put(COIN_TYPE, ENTITY);
        }
        customcontrol.setData(result);
        this.getView().updateView(apId);
    }
}

