/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.extcase;

import com.google.common.base.Joiner;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.Tips;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.ISceneCardConfigDomainService;
import kd.hdtc.hrbm.business.domain.extcase.bean.SceneCardConfigRelFunctionBean;
import kd.hdtc.hrbm.business.domain.model.IBizModelDataDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.common.enums.ExtCaseCardParamEnum;
import kd.hdtc.hrbm.formplugin.web.handler.common.ISceneCardShowParameterHandler;
import kd.hdtc.hrdbs.business.entity.IBaseCommonDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.HDTCArrayUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;

public class BizModelSceneCardTabEditPlugin
extends HDTCDataBaseEdit
implements ClickListener,
TabSelectListener {
    private static final Log LOG = LogFactory.getLog(BizModelSceneCardTabEditPlugin.class);
    private static final String TAB_AP = "tabap";
    private static final String CLOSE_AP = "closesuccess";
    private static final String OPEN_TYPE_LIST = "list";
    private static final String BOS_LIST = "bos_list";
    private static final String BIZ_MODEL_NAME = "bizmodelname";
    private static final String BIZ_MODEL_NUMBER = "bizmodelnumber";
    private static final String BIZ_MODEL_NAME_LA = "entityname";
    private static final String BIZ_MODEL_PROP = "props";
    private static final String SUCCESS_INFO = "successinfo";
    private static final String SUCCESS_INFO_AP = "successinfoap";
    private static final String FUNC_DESC = "funcdesc";
    private static final String SELECT_FIELD = "id,number,modeltype,bizappid";
    private final ISceneCardConfigDomainService sceneCardConfigDomainService = (ISceneCardConfigDomainService)ServiceFactory.getService(ISceneCardConfigDomainService.class);
    private final IBizModelDataDomainService bizModelDataDomainService = (IBizModelDataDomainService)ServiceFactory.getService(IBizModelDataDomainService.class);
    private final IBaseCommonDomainService baseCommonDomainServiceImpl = (IBaseCommonDomainService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBaseCommonDomainService.class);
    private final IPropDomainService propDomainService = (IPropDomainService)ServiceFactory.getService(IPropDomainService.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl(TAB_AP);
        tab.addTabSelectListener((TabSelectListener)this);
        this.addClickListeners(new String[]{CLOSE_AP});
    }

    public void click(EventObject evt) {
        Control source = (Control)evt.getSource();
        if (CLOSE_AP.equals(source.getKey())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{SUCCESS_INFO_AP});
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        List relFunctionBeanList;
        FormShowParameter formShowParameter = e.getFormShowParameter();
        String sceneCardConfigId = (String)formShowParameter.getCustomParam("mainCardId");
        String bizModelType = (String)formShowParameter.getCustomParam("bizmodeltype");
        String bizObjId = (String)formShowParameter.getCustomParam("bizmodel");
        if (StringUtils.isEmpty((String)sceneCardConfigId) || StringUtils.isEmpty((String)bizModelType) || StringUtils.isEmpty((String)bizObjId)) {
            e.setCancel(true);
            LOG.warn("BizModelSceneCardTabEditPlugin preOpenForm param invalid sceneCardConfigId:{}  bizModelType:{} bizObjId:{}", new Object[]{sceneCardConfigId, bizModelType, bizObjId});
            return;
        }
        BizModelDataBean bizModelDataBean = this.bizModelDataDomainService.getValidBizModelInfoById(BizModelTypeEnum.getBizModelTypeByLevel((int)Integer.parseInt(bizModelType)), (Object)Long.parseLong(bizObjId));
        if (bizModelDataBean == null || bizModelDataBean.getBizModel() == null) {
            LOG.warn("BizModelSceneCardTabEditPlugin preOpenForm query data error sceneCardConfigId:{}  bizModelType:{} bizObjId:{}", new Object[]{sceneCardConfigId, bizModelType, bizObjId});
            e.setCancel(true);
            return;
        }
        String enable = bizModelDataBean.getBizModel().getString("enable");
        if (!StringUtils.equals((String)"1", (String)enable)) {
            LOG.warn("BizModelSceneCardTabEditPlugin preOpenForm data is enabled sceneCardConfigId:{}  bizModelType:{} bizObjId:{}", new Object[]{sceneCardConfigId, bizModelType, bizObjId});
            e.setCancel(true);
            return;
        }
        String name = bizModelDataBean.getBizModel().getString("name");
        if (StringUtils.isNotEmpty((String)name)) {
            formShowParameter.setCaption(String.format(ResManager.loadKDString((String)"%1$s-\u7cfb\u7edf\u63a8\u8350\u914d\u7f6e\u529f\u80fd", (String)"BizModelSceneCardTabEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), name));
        }
        if (CollectionUtils.isEmpty((Collection)(relFunctionBeanList = this.sceneCardConfigDomainService.getSceneCardConfigRelFunctionList(Long.valueOf(Long.parseLong(sceneCardConfigId)), bizModelDataBean)))) {
            e.setCancel(true);
            LOG.warn("BizModelSceneCardTabEditPlugin preOpenForm has no relFunction sceneCardConfigId:{}  bizModelType:{} bizObjId:{}", new Object[]{sceneCardConfigId, bizModelType, bizObjId});
            return;
        }
    }

    public void beforeBindData(EventObject e) {
        List propList;
        BizModelDataBean bizModelDataBean;
        this.getView().setVisible(Boolean.FALSE, new String[]{SUCCESS_INFO_AP});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String bizModelType = (String)formShowParameter.getCustomParam("bizmodeltype");
        String bizModelId = (String)formShowParameter.getCustomParam("bizmodel");
        String sceneCardConfigId = (String)formShowParameter.getCustomParam("mainCardId");
        String opResult = (String)formShowParameter.getCustomParam("op_result");
        if (StringUtils.isNotEmpty((String)opResult)) {
            this.setLabelValue(SUCCESS_INFO, opResult);
            this.getView().setVisible(Boolean.TRUE, new String[]{SUCCESS_INFO_AP});
        }
        if ((bizModelDataBean = this.bizModelDataDomainService.getValidBizModelInfoById(BizModelTypeEnum.getBizModelTypeByLevel((int)Integer.parseInt(bizModelType)), (Object)Long.parseLong(bizModelId))) == null || bizModelDataBean.getBizModel() == null) {
            this.getView().showErrorNotification("data is error");
            return;
        }
        DynamicObject bizModel = bizModelDataBean.getBizModel();
        String number = bizModel.getString("number");
        String name = bizModel.getString("name");
        this.setLabelValue(BIZ_MODEL_NAME, name);
        this.setLabelValue(BIZ_MODEL_NUMBER, number);
        this.setLabelValue(BIZ_MODEL_NAME_LA, name);
        if (bizModelDataBean.getBizModelType() == BizModelTypeEnum.LOGIC_ENTITY && CollectionUtils.isNotEmpty((Collection)(propList = this.propDomainService.getExcludeWhitePropInfobyLogicEntityId(Long.parseLong(bizModelId))))) {
            List nameList = propList.stream().filter(data -> IsvUtils.isCurrentIsv((String)data.getString("isv"))).map(data -> data.getString("name")).collect(Collectors.toList());
            this.setLabelValue(BIZ_MODEL_PROP, Joiner.on((String)",").join(nameList));
        }
        List relFunctionBeanList = this.sceneCardConfigDomainService.getSceneCardConfigRelFunctionList(Long.valueOf(Long.parseLong(sceneCardConfigId)), bizModelDataBean);
        int index = 0;
        FormShowParameter firstParam = null;
        List formIdList = relFunctionBeanList.stream().map(SceneCardConfigRelFunctionBean::getPageNumber).collect(Collectors.toList());
        Object[] entityObjArr = this.baseCommonDomainServiceImpl.queryByFilter("bos_formmeta", SELECT_FIELD, new QFilter[]{new QFilter("number", "in", formIdList)});
        if (HDTCArrayUtils.isEmpty((Object[])entityObjArr)) {
            LOG.warn("BizModelSceneCardTabEditPlugin beforeBindData entityObjArr is null formIdList:{}", formIdList);
            return;
        }
        Map<String, DynamicObject> entityMap = Arrays.stream(entityObjArr).collect(Collectors.toMap(data -> data.getString("number"), dy -> dy, (v1, v2) -> v2));
        for (SceneCardConfigRelFunctionBean sceneCardConfigRelFunctionBean : relFunctionBeanList) {
            String formId = sceneCardConfigRelFunctionBean.getPageNumber();
            DynamicObject entityObj = entityMap.get(formId);
            if (entityObj == null) continue;
            String pageType = entityObj.getString("modeltype");
            if (StringUtils.isEmpty((String)formId)) continue;
            String bizAppId = entityObj.getString("bizappid");
            String paramRule = sceneCardConfigRelFunctionBean.getParamRule();
            FormShowParameter showParameter = this.getParamByParamRule(paramRule, formId, pageType);
            if ("hrbm_sclogicview".equals(sceneCardConfigRelFunctionBean.getPageNumber())) {
                this.getView().getPageCache().put("sclogicpageId", showParameter.getPageId());
            }
            if (StringUtils.isEmpty((String)showParameter.getFormId())) continue;
            this.buildCommonValueToParam(showParameter, parameter -> {
                this.getView().getPageCache().put(parameter.getPageId(), sceneCardConfigRelFunctionBean.getRecommendDesc().getLocaleValue());
                List relModelCardDyList = sceneCardConfigRelFunctionBean.getRelModelCardList();
                if (CollectionUtils.isNotEmpty((Collection)relModelCardDyList)) {
                    List relModelCardIdList = relModelCardDyList.stream().map(t -> t.getLong("fbasedataid_id")).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(relModelCardIdList)) {
                        LOG.info("BizModelSceneCardTabEntityPlugin beforeBindData relModelCardIdList is empty");
                    }
                    parameter.setCustomParam("relModelCardIdList", relModelCardIdList);
                }
                parameter.setCustomParam("sceneCardconfigid", (Object)sceneCardConfigId);
                parameter.setCustomParam("bizmodeltype", (Object)bizModelType);
                parameter.setCustomParam("bizmodel", (Object)Long.parseLong(bizModelId));
                parameter.setCustomParam("id", (Object)Long.parseLong(bizModelId));
                parameter.setCustomParam("number", (Object)number);
                parameter.setCustomParam("hideExit", (Object)true);
                parameter.setAppId(bizAppId);
                parameter.setHasRight(false);
                parameter.setCustomParam("checkRightAppId", (Object)bizAppId);
                parameter.setCustomParam("close_btn_hide", (Object)true);
                if (sceneCardConfigRelFunctionBean != null && StringUtils.isNotEmpty((String)sceneCardConfigRelFunctionBean.getFunctionName().getLocaleValue())) {
                    parameter.setCaption(sceneCardConfigRelFunctionBean.getFunctionName().getLocaleValue());
                    parameter.setCustomParam("ue_param", (Object)"true");
                }
                return parameter;
            });
            String plugin = (String)showParameter.getCustomParam(ExtCaseCardParamEnum.PLUGIN.getParamKey());
            if (StringUtils.isNotEmpty((String)plugin)) {
                this.dealParameterByPlugin(plugin, showParameter);
            }
            if (index == 0) {
                firstParam = showParameter;
            }
            if (formShowParameter.getCustomParam("sceneCardconfigid") != null && sceneCardConfigRelFunctionBean.getRelCardId() != null && formShowParameter.getCustomParam("sceneCardconfigid").equals(String.valueOf(sceneCardConfigRelFunctionBean.getRelCardId()))) {
                this.getView().showForm(showParameter);
                firstParam = showParameter;
            } else {
                this.getView().showForm(showParameter);
            }
            ++index;
        }
        if (firstParam != null && StringUtils.isNotEmpty((String)firstParam.getPageId())) {
            IFormView view = SessionManager.getCurrent().getViewNoPlugin(firstParam.getPageId());
            view.activate();
            this.getView().sendFormAction(view);
        }
        super.beforeBindData(e);
    }

    private void buildCommonValueToParam(FormShowParameter parameter, Function<FormShowParameter, FormShowParameter> func) {
        parameter.getOpenStyle().setShowType(ShowType.NewTabPage);
        StyleCss css = new StyleCss();
        css.setHeight("100%");
        parameter.getOpenStyle().setInlineStyleCss(css);
        parameter.getOpenStyle().setTargetKey(TAB_AP);
        if (func != null) {
            func.apply(parameter);
        }
    }

    private FormShowParameter getParamByParamRule(String paramRule, String formId, String pageType) {
        FormShowParameter showParameter = new FormShowParameter();
        try {
            String openType = "";
            String listFormId = "";
            String plugin = "";
            String lookUp = "";
            Map mappingRuleMap = null;
            if (StringUtils.isNotEmpty((String)paramRule)) {
                mappingRuleMap = (Map)JsonUtils.castType((String)paramRule, Map.class);
                openType = (String)mappingRuleMap.get(ExtCaseCardParamEnum.OPEN_TYPE.getParamKey());
                listFormId = (String)mappingRuleMap.get(ExtCaseCardParamEnum.LIST_FORM_ID.getParamKey());
                plugin = (String)mappingRuleMap.get(ExtCaseCardParamEnum.PLUGIN.getParamKey());
                lookUp = (String)mappingRuleMap.get(ExtCaseCardParamEnum.LOOK_UP.getParamKey());
            }
            if (StringUtils.equals((String)openType, (String)OPEN_TYPE_LIST)) {
                ListShowParameter listShowParameter = new ListShowParameter();
                listShowParameter.setBillFormId(formId);
                if (StringUtils.isNotEmpty((String)listFormId)) {
                    listShowParameter.setFormId(listFormId);
                } else {
                    listShowParameter.setFormId(BOS_LIST);
                }
                if (StringUtils.isNotEmpty((String)lookUp)) {
                    listShowParameter.setLookUp(true);
                }
                listShowParameter.setCustomParam(ExtCaseCardParamEnum.PLUGIN.getParamKey(), (Object)plugin);
                if (CollectionUtils.isNotEmpty((Map)mappingRuleMap)) {
                    listShowParameter.getCustomParams().putAll(mappingRuleMap);
                }
                return listShowParameter;
            }
            if (StringUtils.equals((String)"BillFormModel", (String)pageType)) {
                showParameter = new BillShowParameter();
            } else if (StringUtils.equals((String)"BaseFormModel", (String)pageType)) {
                showParameter = new BaseShowParameter();
            } else if (StringUtils.equals((String)"QueryListModel", (String)pageType)) {
                showParameter = new ListShowParameter();
            }
            showParameter.setFormId(formId);
            showParameter.setCustomParam(ExtCaseCardParamEnum.PLUGIN.getParamKey(), (Object)plugin);
            if (CollectionUtils.isNotEmpty((Map)mappingRuleMap)) {
                showParameter.getCustomParams().putAll(mappingRuleMap);
            }
        }
        catch (Exception ex) {
            LOG.error("dealParamRule error paramRule:{}", (Object)paramRule);
        }
        return showParameter;
    }

    private void dealParameterByPlugin(String plugin, FormShowParameter showParameter) {
        if (StringUtils.isEmpty((String)plugin)) {
            return;
        }
        Class<?> pluginClass = this.getClassByFullPath(plugin);
        Class<ISceneCardShowParameterHandler> serviceInterface = ISceneCardShowParameterHandler.class;
        if (pluginClass == null || !serviceInterface.isAssignableFrom(pluginClass)) {
            return;
        }
        try {
            Object instance = pluginClass.newInstance();
            pluginClass.getMethod("dealParameter", FormShowParameter.class).invoke(instance, showParameter);
        }
        catch (NoSuchMethodException e) {
            LOG.error("dealParameterByPlugin error,NoSuchMethodException plugin:{}", (Object)plugin);
            LOG.error("dealParameterByPlugin error,NoSuchMethodException ", (Throwable)e);
        }
        catch (InstantiationException e) {
            LOG.error("dealParameterByPlugin error,InstantiationException plugin:{}", (Object)plugin);
            LOG.error("dealParameterByPlugin error,InstantiationException ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            LOG.error("dealParameterByPlugin error,IllegalAccessException plugin:{}", (Object)plugin);
            LOG.error("dealParameterByPlugin error,IllegalAccessException ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error("dealParameterByPlugin error,InvocationTargetException plugin:{}", (Object)plugin);
            LOG.error("dealParameterByPlugin error,InvocationTargetException ", (Throwable)e);
        }
    }

    private Class<?> getClassByFullPath(String plugin) {
        try {
            return TypesContainer.getOrRegister((String)plugin);
        }
        catch (Exception e) {
            LOG.error("getClassByFullPath error,plugin:{}", (Object)plugin);
            LOG.error("getClassByFullPath error,", (Throwable)e);
            return null;
        }
    }

    private void setLabelValue(String labelCoin, String value) {
        Label labelApName = (Label)this.getView().getControl(labelCoin);
        if (labelApName != null) {
            labelApName.setText(value);
        }
    }

    private void setLabelTipValue(String labelCoin, String value) {
        Label labelApName = (Label)this.getView().getControl(labelCoin);
        if (labelApName != null) {
            labelApName.setText(value);
            Tips tips = new Tips();
            tips.setContent(new LocaleString(value));
            tips.setType("text");
            tips.setShowIcon(false);
            labelApName.addTips(tips);
        }
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
        String subTabKey = tabSelectEvent.getTabKey();
        String funcDesc = this.getView().getPageCache().get(subTabKey);
        this.setLabelTipValue(FUNC_DESC, String.format(ResManager.loadKDString((String)"\u529f\u80fd\u8bf4\u660e\uff1a%1$s", (String)"BizModelSceneCardTabEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), funcDesc));
        String pageId = this.getView().getPageCache().get("sclogicpageId");
        if (StringUtils.isNotEmpty((String)pageId) && pageId.equals(subTabKey)) {
            IFormView childView = this.getView().getView(tabSelectEvent.getTabKey());
            childView.updateView();
            this.getView().sendFormAction(childView);
        }
    }
}

