/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.extcase;

import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;

public class PerBillToolShowFormPlugin
extends AbstractHDTCFormPlugin {
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IPropDomainService propDomainService = (IPropDomainService)ServiceFactory.getService(IPropDomainService.class);

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Object id = this.getView().getFormShowParameter().getCustomParam("logicEntityId");
        DynamicObject logicEntity = this.logicEntityDomainService.getLogicEntityInfoById(id);
        if (logicEntity != null) {
            this.getModel().setValue("logicentity", (Object)logicEntity);
            this.rendPropValue(logicEntity.getLong("id"));
            this.showBizPage(logicEntity);
        }
    }

    private void rendPropValue(long logicEntityId) {
        List propList = this.propDomainService.getPropInfobyLogicEntityId(logicEntityId);
        if (CollectionUtils.isEmpty((Collection)propList)) {
            return;
        }
        List propNameList = propList.stream().map(data -> data.getString("name")).collect(Collectors.toList());
        String propStr = StringUtils.join((Object[])propNameList.toArray(), (String)",");
        this.getModel().setValue("props", (Object)propStr);
    }

    private void showBizPage(DynamicObject logicEntity) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.getOpenStyle().setShowType(ShowType.InContainer);
        formShowParameter.getOpenStyle().setTargetKey("bizpageap");
        formShowParameter.setAppId("hpfs");
        formShowParameter.setFormId("hpfs_chgactionlist");
        formShowParameter.setCustomParam("l4Number", (Object)logicEntity.getString("pid.number"));
        formShowParameter.setCustomParam("extMetaNum", (Object)logicEntity.getString("extmetanum"));
        formShowParameter.setCustomParam("entityNumber", (Object)logicEntity.getString("number"));
        formShowParameter.setCustomParam("targetEntity", (Object)"");
        this.getView().showForm(formShowParameter);
    }
}

