/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.extcase.sihc;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.SnapCadreRosterHelper;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.bo.SnapReportEntityInfo;
import kd.hdtc.hrbm.business.domain.task.impl.sihc.bo.SnapReportFieldInfo;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.formplugin.web.HDTCDataBaseEdit;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class ModCadreReportEditPlugin
extends HDTCDataBaseEdit
implements BeforeF7SelectListener {
    private static final HRBaseServiceHelper BASE_CONFIG_HELPER = HRBaseServiceHelper.create((String)"hrbm_baseconfig");
    private static final Long REPORT_TYPE_CADRE = 2017475105080255488L;
    private static final Long REPORT_TYPE_SNAP = 2017475217982530560L;
    private static final List<SnapReportEntityInfo> CADRE_REPORT_PRESET = ModCadreReportEditPlugin.getCadreReportPreset();
    private static final List<SnapReportEntityInfo> SNAP_CADRE_REPORT_PRESET = ModCadreReportEditPlugin.getSnapCadreReportPreset();

    private List<String> getPropBlackList() {
        DynamicObject dynamicObject = BASE_CONFIG_HELPER.queryOne("value", new QFilter("number", "=", (Object)"PROP_BLACK"));
        if (dynamicObject == null || HRStringUtils.isEmpty((String)dynamicObject.getString("value"))) {
            return Collections.emptyList();
        }
        String value = dynamicObject.getString("value");
        return Lists.newArrayList((Object[])value.split(","));
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        MulBasedataEdit mulBasedataEdit = (MulBasedataEdit)this.getControl("cadrerepotype");
        mulBasedataEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        if (showParameter.getStatus() == OperationStatus.ADDNEW) {
            this.getModel().setValue("bizmodel", (Object)this.getBizModelId());
        }
        DynamicObject bizmodel = (DynamicObject)this.getModel().getValue("bizmodel");
        Object[] cadreFileTypeIdArr = SnapCadreRosterHelper.getPublishCadreFileType((String)bizmodel.getString("number"));
        this.getModel().setValue("cadrefiletype", (Object)cadreFileTypeIdArr);
        this.getModel().setDataChanged(false);
        this.setEntryVisible();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (HRStringUtils.equals((String)name, (String)"cadrerepotype")) {
            this.setEntryVisible();
        }
    }

    private void setEntryVisible() {
        DynamicObjectCollection cadrerepotypeCol = (DynamicObjectCollection)this.getModel().getValue("cadrerepotype");
        if (CollectionUtils.isEmpty((Collection)cadrerepotypeCol)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advconap", "advconap1"});
            return;
        }
        List typeIdList = cadrerepotypeCol.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList());
        this.getView().setVisible(Boolean.valueOf(typeIdList.contains(REPORT_TYPE_CADRE)), new String[]{"advconap"});
        this.getView().setVisible(Boolean.valueOf(typeIdList.contains(REPORT_TYPE_SNAP)), new String[]{"advconap1"});
    }

    private long getBizModelId() {
        Object bizModelObj = this.getModel().getValue("bizmodel");
        if (bizModelObj != null) {
            return ((DynamicObject)bizModelObj).getLong("id");
        }
        FormShowParameter showParameter = this.getView().getFormShowParameter();
        Object bizModelIdObj = showParameter.getCustomParam("bizmodel");
        if (bizModelIdObj != null) {
            return Long.parseLong(String.valueOf(bizModelIdObj));
        }
        return 0L;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"cadre_deleteentry") && this.isFirstRequest(operate.getOperateKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6240\u9009\u5c5e\u6027\u5c06\u4e0d\u4f1a\u663e\u793a\u5728\u82b1\u540d\u518c\u4e2d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"ModCadreReportEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)this));
            args.setCancel(true);
        }
        if (HRStringUtils.equals((String)operate.getOperateKey(), (String)"snap_deleteentry") && this.isFirstRequest(operate.getOperateKey())) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5220\u9664\u540e\u6240\u9009\u5c5e\u6027\u5c06\u4e0d\u4f1a\u663e\u793a\u5728\u82b1\u540d\u518c\u4e2d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u5417\uff1f", (String)"ModCadreReportEditPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)this));
            args.setCancel(true);
        }
    }

    private boolean isFirstRequest(String operateKey) {
        IPageCache pageCache = this.getPageCache();
        String result = pageCache.get("firstRequest_" + operateKey);
        return !HRStringUtils.equals((String)result, (String)"1");
    }

    private void setSecondRequest(String operateKey) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("firstRequest_" + operateKey, "1");
    }

    private void setFirstRequest(String operateKey) {
        IPageCache pageCache = this.getPageCache();
        pageCache.put("firstRequest_" + operateKey, null);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ((HRStringUtils.equals((String)callBackId, (String)"cadre_deleteentry") || HRStringUtils.equals((String)callBackId, (String)"snap_deleteentry")) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            this.setSecondRequest(callBackId);
            this.getView().invokeOperation(callBackId);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        ArrayList notShowProps;
        String bizModelNumber;
        ArrayList<QFilter> qFilters;
        List<Long> alreadySelectLogicEntity;
        ListFilterParameter listFilterParameter;
        CloseCallBack closeCallBack;
        ListShowParameter listShowParameter;
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)"cadre_newentry")) {
            listShowParameter = ShowFormHelper.createShowListForm((String)"hrbm_prop", (boolean)true);
            closeCallBack = new CloseCallBack((IFormPlugin)this, "cadre_newentry");
            listShowParameter.setCloseCallBack(closeCallBack);
            listFilterParameter = new ListFilterParameter();
            alreadySelectLogicEntity = this.getAlreadySelectLogicEntity(false);
            qFilters = new ArrayList<QFilter>(10);
            if (CollectionUtils.isNotEmpty(alreadySelectLogicEntity)) {
                qFilters.add(new QFilter("id", "not in", alreadySelectLogicEntity));
            }
            qFilters.add(new QFilter("logicentity.id", "=", (Object)this.getBizModelId()));
            bizModelNumber = this.getModel().getDataEntity().getString("bizmodel.number");
            notShowProps = new ArrayList(10);
            notShowProps.addAll(this.getPropBlackList().stream().map(prop -> bizModelNumber + "." + prop).collect(Collectors.toList()));
            CADRE_REPORT_PRESET.stream().filter(info -> HRStringUtils.equals((String)info.getNumber(), (String)bizModelNumber)).findFirst().ifPresent(info -> {
                List fieldNumberList = info.getSnapReportFieldInfoList().stream().map(field -> info.getNumber() + "." + field.getNumber()).collect(Collectors.toList());
                notShowProps.addAll(fieldNumberList);
            });
            qFilters.add(new QFilter("number", "not in", notShowProps));
            listFilterParameter.setQFilters((List)Lists.newArrayList(qFilters));
            listShowParameter.setListFilterParameter(listFilterParameter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"snap_newentry")) {
            listShowParameter = ShowFormHelper.createShowListForm((String)"hrbm_prop", (boolean)true);
            closeCallBack = new CloseCallBack((IFormPlugin)this, "snap_newentry");
            listShowParameter.setCloseCallBack(closeCallBack);
            listFilterParameter = new ListFilterParameter();
            alreadySelectLogicEntity = this.getAlreadySelectLogicEntity(true);
            qFilters = new ArrayList(10);
            if (CollectionUtils.isNotEmpty(alreadySelectLogicEntity)) {
                qFilters.add(new QFilter("id", "not in", alreadySelectLogicEntity));
            }
            qFilters.add(new QFilter("logicentity.id", "=", (Object)this.getBizModelId()));
            bizModelNumber = this.getModel().getDataEntity().getString("bizmodel.number");
            notShowProps = new ArrayList(10);
            notShowProps.addAll(this.getPropBlackList().stream().map(prop -> bizModelNumber + "." + prop).collect(Collectors.toList()));
            SNAP_CADRE_REPORT_PRESET.stream().filter(info -> HRStringUtils.equals((String)info.getNumber(), (String)bizModelNumber)).findFirst().ifPresent(info -> {
                List fieldNumberList = info.getSnapReportFieldInfoList().stream().map(field -> info.getNumber() + "." + field.getNumber()).collect(Collectors.toList());
                notShowProps.addAll(fieldNumberList);
            });
            qFilters.add(new QFilter("number", "not in", notShowProps));
            listFilterParameter.setQFilters((List)Lists.newArrayList(qFilters));
            listShowParameter.setListFilterParameter(listFilterParameter);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
        if (HRStringUtils.equals((String)operateKey, (String)"save_effect")) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            if (operationResult != null && !operationResult.isSuccess()) {
                return;
            }
            this.getView().invokeOperation("save", this.createOperateOption());
        }
        if (HRStringUtils.equals((String)operateKey, (String)"cadre_deleteentry") || HRStringUtils.equals((String)operateKey, (String)"snap_deleteentry")) {
            this.setFirstRequest(operateKey);
        }
    }

    private OperateOption createOperateOption() {
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("ishasright", Boolean.TRUE.toString());
        return operateOption;
    }

    private List<Long> getAlreadySelectLogicEntity(boolean isSnap) {
        if (isSnap) {
            return this.getModel().getEntryEntity("entryentity_snap").stream().map(dy -> dy.getLong("snapprop.id")).collect(Collectors.toList());
        }
        return this.getModel().getEntryEntity("entryentity").stream().map(dy -> dy.getLong("cadreprop.id")).collect(Collectors.toList());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        TableValueSetter tableValueSetter;
        AbstractFormDataModel model;
        ListSelectedRowCollection returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (HRStringUtils.equals((String)actionId, (String)"cadre_newentry") && CollectionUtils.isNotEmpty((Collection)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            model = (AbstractFormDataModel)this.getModel();
            tableValueSetter = new TableValueSetter(new String[0]);
            for (ListSelectedRow row : returnData) {
                tableValueSetter.addField("cadreprop", new Object[]{row.getPrimaryKeyValue()});
            }
            model.batchCreateNewEntryRow("entryentity", tableValueSetter);
            this.getView().updateView("entryentity");
        }
        if (HRStringUtils.equals((String)actionId, (String)"snap_newentry") && CollectionUtils.isNotEmpty((Collection)(returnData = (ListSelectedRowCollection)closedCallBackEvent.getReturnData()))) {
            model = (AbstractFormDataModel)this.getModel();
            tableValueSetter = new TableValueSetter(new String[0]);
            for (ListSelectedRow row : returnData) {
                tableValueSetter.addField("snapprop", new Object[]{row.getPrimaryKeyValue()});
            }
            model.batchCreateNewEntryRow("entryentity_snap", tableValueSetter);
            this.getView().updateView("entryentity_snap");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        IDataEntityProperty property = evt.getProperty();
        String name = property.getName();
        if (HRStringUtils.equals((String)name, (String)"cadrerepotype")) {
            DynamicObjectCollection cadreFileTypeCol = (DynamicObjectCollection)this.getModel().getValue("cadrefiletype");
            ArrayList<Object> idList = new ArrayList<Object>(cadreFileTypeCol.size());
            for (Object dynamicObject : cadreFileTypeCol) {
                if (dynamicObject.getLong("fbasedataid_id") == 1777568566262990848L) {
                    idList.add(REPORT_TYPE_CADRE);
                }
                if (dynamicObject.getLong("fbasedataid_id") != 1787004807962185728L) continue;
                idList.add(REPORT_TYPE_SNAP);
            }
            DynamicObjectCollection cadrerepotype = (DynamicObjectCollection)this.getModel().getValue("cadrerepotype");
            for (DynamicObject cadrerepotyp : cadrerepotype) {
                idList.removeIf(id -> Objects.equals(cadrerepotyp.get("fbasedataid_id"), id));
            }
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            ListFilterParameter listFilterParameter = new ListFilterParameter();
            listFilterParameter.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{new QFilter("id", "in", idList), new QFilter("id", "not in", cadrerepotype.stream().map(dy -> dy.getLong("fbasedataid_id")).collect(Collectors.toList()))}));
            showParameter.setListFilterParameter(listFilterParameter);
        }
    }

    private static List<SnapReportEntityInfo> getCadreReportPreset() {
        ArrayList<SnapReportEntityInfo> snapReportEntityInfos = new ArrayList<SnapReportEntityInfo>(10);
        SnapReportEntityInfo hrpi_pernontsprop = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_pernontsprop);
        hrpi_pernontsprop.setNumber("hrpi_pernontsprop");
        ArrayList<SnapReportFieldInfo> pernontspropFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_pernontsprop.setSnapReportFieldInfoList(pernontspropFields);
        pernontspropFields.add(new SnapReportFieldInfo("formername"));
        pernontspropFields.add(new SnapReportFieldInfo("gender"));
        pernontspropFields.add(new SnapReportFieldInfo("nationality"));
        pernontspropFields.add(new SnapReportFieldInfo("folk"));
        pernontspropFields.add(new SnapReportFieldInfo("beginservicedate"));
        SnapReportEntityInfo hrpi_percontact = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_percontact);
        hrpi_percontact.setNumber("hrpi_percontact");
        ArrayList<SnapReportFieldInfo> percontactFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_percontact.setSnapReportFieldInfoList(percontactFields);
        percontactFields.add(new SnapReportFieldInfo("phone"));
        percontactFields.add(new SnapReportFieldInfo("otherphone"));
        percontactFields.add(new SnapReportFieldInfo("peremail"));
        percontactFields.add(new SnapReportFieldInfo("busemail"));
        percontactFields.add(new SnapReportFieldInfo("workphone"));
        percontactFields.add(new SnapReportFieldInfo("telephone"));
        SnapReportEntityInfo soecs_cafilenontsprop = new SnapReportEntityInfo();
        snapReportEntityInfos.add(soecs_cafilenontsprop);
        soecs_cafilenontsprop.setNumber("soecs_cafilenontsprop");
        ArrayList<SnapReportFieldInfo> soecs_cafilenontspropFields = new ArrayList<SnapReportFieldInfo>(10);
        soecs_cafilenontsprop.setSnapReportFieldInfoList(soecs_cafilenontspropFields);
        soecs_cafilenontspropFields.add(new SnapReportFieldInfo("birthday"));
        soecs_cafilenontspropFields.add(new SnapReportFieldInfo("age"));
        SnapReportEntityInfo hrpi_pertsprop = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_pertsprop);
        hrpi_pertsprop.setNumber("hrpi_pertsprop");
        ArrayList<SnapReportFieldInfo> hrpi_pertspropFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_pertsprop.setSnapReportFieldInfoList(hrpi_pertspropFields);
        hrpi_pertspropFields.add(new SnapReportFieldInfo("procreatstatus"));
        hrpi_pertspropFields.add(new SnapReportFieldInfo("marriagestatus"));
        hrpi_pertspropFields.add(new SnapReportFieldInfo("healthstatus"));
        hrpi_pertspropFields.add(new SnapReportFieldInfo("childrennumber"));
        SnapReportEntityInfo hrpi_perregion = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_perregion);
        hrpi_perregion.setNumber("hrpi_perregion");
        ArrayList<SnapReportFieldInfo> hrpi_perregionFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_perregion.setSnapReportFieldInfoList(hrpi_perregionFields);
        hrpi_perregionFields.add(new SnapReportFieldInfo("politicalstatus"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("party"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("joinpartydate"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("religion"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("nativeplace"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("birthplace"));
        SnapReportEntityInfo hrpi_percre = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_percre);
        hrpi_percre.setNumber("hrpi_percre");
        ArrayList<SnapReportFieldInfo> hrpi_percreFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_percre.setSnapReportFieldInfoList(hrpi_percreFields);
        hrpi_percreFields.add(new SnapReportFieldInfo("number"));
        hrpi_percreFields.add(new SnapReportFieldInfo("credentialstype"));
        SnapReportEntityInfo hrpi_appointremoverel = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_appointremoverel);
        hrpi_appointremoverel.setNumber("hrpi_appointremoverel");
        ArrayList<SnapReportFieldInfo> hrpi_appointremoverelFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_appointremoverel.setSnapReportFieldInfoList(hrpi_appointremoverelFields);
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("company"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("adminorgvid"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("apositiontype"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("positionvid"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("stdpositionvid"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("jobvid"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("cadrecat"));
        SnapReportEntityInfo hrpi_pereduexp = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_pereduexp);
        hrpi_pereduexp.setNumber("hrpi_pereduexp");
        ArrayList<SnapReportFieldInfo> hrpi_pereduexpFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_pereduexp.setSnapReportFieldInfoList(hrpi_pereduexpFields);
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("admissiondate"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("gradutiondate"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("graduateschool"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("schoolrecord"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("isoverseas"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("edunature"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("degree"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("authedegree"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("major"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("secondmajor"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("schoolsystem"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("education"));
        SnapReportEntityInfo hrpi_empentrel = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_empentrel);
        hrpi_empentrel.setNumber("hrpi_empentrel");
        ArrayList<SnapReportFieldInfo> hrpi_empentrelFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_empentrel.setSnapReportFieldInfoList(hrpi_empentrelFields);
        hrpi_empentrelFields.add(new SnapReportFieldInfo("enterprise"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("startdate"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("enddate"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("lastworkdate"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("laborreltype"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("laborrelstatus"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("servicelength"));
        return snapReportEntityInfos;
    }

    private static List<SnapReportEntityInfo> getSnapCadreReportPreset() {
        ArrayList<SnapReportEntityInfo> snapReportEntityInfos = new ArrayList<SnapReportEntityInfo>(10);
        SnapReportEntityInfo hrpi_pernontsprop = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_pernontsprop);
        hrpi_pernontsprop.setNumber("hrpi_pernontsprop");
        ArrayList<SnapReportFieldInfo> pernontspropFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_pernontsprop.setSnapReportFieldInfoList(pernontspropFields);
        pernontspropFields.add(new SnapReportFieldInfo("formername"));
        pernontspropFields.add(new SnapReportFieldInfo("gender"));
        pernontspropFields.add(new SnapReportFieldInfo("nationality"));
        pernontspropFields.add(new SnapReportFieldInfo("folk"));
        pernontspropFields.add(new SnapReportFieldInfo("beginservicedate"));
        SnapReportEntityInfo soecs_cafilenontsprop = new SnapReportEntityInfo();
        snapReportEntityInfos.add(soecs_cafilenontsprop);
        soecs_cafilenontsprop.setNumber("soecs_cafilenontsprop");
        ArrayList<SnapReportFieldInfo> soecs_cafilenontspropFields = new ArrayList<SnapReportFieldInfo>(10);
        soecs_cafilenontsprop.setSnapReportFieldInfoList(soecs_cafilenontspropFields);
        soecs_cafilenontspropFields.add(new SnapReportFieldInfo("birthday"));
        soecs_cafilenontspropFields.add(new SnapReportFieldInfo("age"));
        SnapReportEntityInfo hrpi_pertsprop = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_pertsprop);
        hrpi_pertsprop.setNumber("hrpi_pertsprop");
        ArrayList<SnapReportFieldInfo> hrpi_pertspropFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_pertsprop.setSnapReportFieldInfoList(hrpi_pertspropFields);
        hrpi_pertspropFields.add(new SnapReportFieldInfo("procreatstatus"));
        hrpi_pertspropFields.add(new SnapReportFieldInfo("marriagestatus"));
        hrpi_pertspropFields.add(new SnapReportFieldInfo("healthstatus"));
        hrpi_pertspropFields.add(new SnapReportFieldInfo("childrennumber"));
        SnapReportEntityInfo hrpi_perregion = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_perregion);
        hrpi_perregion.setNumber("hrpi_perregion");
        ArrayList<SnapReportFieldInfo> hrpi_perregionFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_perregion.setSnapReportFieldInfoList(hrpi_perregionFields);
        hrpi_perregionFields.add(new SnapReportFieldInfo("politicalstatus"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("party"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("joinpartydate"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("religion"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("nativeplace"));
        hrpi_perregionFields.add(new SnapReportFieldInfo("birthplace"));
        SnapReportEntityInfo hrpi_percontact = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_percontact);
        hrpi_percontact.setNumber("hrpi_percontact");
        ArrayList<SnapReportFieldInfo> percontactFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_percontact.setSnapReportFieldInfoList(percontactFields);
        percontactFields.add(new SnapReportFieldInfo("phone"));
        percontactFields.add(new SnapReportFieldInfo("otherphone"));
        percontactFields.add(new SnapReportFieldInfo("peremail"));
        percontactFields.add(new SnapReportFieldInfo("busemail"));
        percontactFields.add(new SnapReportFieldInfo("workphone"));
        percontactFields.add(new SnapReportFieldInfo("telephone"));
        SnapReportEntityInfo hrpi_percre = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_percre);
        hrpi_percre.setNumber("hrpi_percre");
        ArrayList<SnapReportFieldInfo> hrpi_percreFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_percre.setSnapReportFieldInfoList(hrpi_percreFields);
        hrpi_percreFields.add(new SnapReportFieldInfo("number"));
        hrpi_percreFields.add(new SnapReportFieldInfo("credentialstype"));
        SnapReportEntityInfo hrpi_appointremoverel = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_appointremoverel);
        hrpi_appointremoverel.setNumber("hrpi_appointremoverel");
        ArrayList<SnapReportFieldInfo> hrpi_appointremoverelFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_appointremoverel.setSnapReportFieldInfoList(hrpi_appointremoverelFields);
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("company"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("adminorgvid"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("apositiontype"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("positionvid"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("stdpositionvid"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("jobvid"));
        hrpi_appointremoverelFields.add(new SnapReportFieldInfo("cadrecat"));
        SnapReportEntityInfo hrpi_pereduexp = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_pereduexp);
        hrpi_pereduexp.setNumber("hrpi_pereduexp");
        ArrayList<SnapReportFieldInfo> hrpi_pereduexpFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_pereduexp.setSnapReportFieldInfoList(hrpi_pereduexpFields);
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("admissiondate"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("gradutiondate"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("graduateschool"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("schoolrecord"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("isoverseas"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("edunature"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("degree"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("authedegree"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("major"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("secondmajor"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("schoolsystem"));
        hrpi_pereduexpFields.add(new SnapReportFieldInfo("education"));
        SnapReportEntityInfo hrpi_empentrel = new SnapReportEntityInfo();
        snapReportEntityInfos.add(hrpi_empentrel);
        hrpi_empentrel.setNumber("hrpi_empentrel");
        ArrayList<SnapReportFieldInfo> hrpi_empentrelFields = new ArrayList<SnapReportFieldInfo>(10);
        hrpi_empentrel.setSnapReportFieldInfoList(hrpi_empentrelFields);
        hrpi_empentrelFields.add(new SnapReportFieldInfo("enterprise"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("startdate"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("enddate"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("lastworkdate"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("laborreltype"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("laborrelstatus"));
        hrpi_empentrelFields.add(new SnapReportFieldInfo("servicelength"));
        return snapReportEntityInfos;
    }
}

