/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.extcase.wtc;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operate.FormOperate;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.wtc.IWtcFormulaConfigDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hr.hbp.common.cache.HRAppCache;
import kd.hr.hbp.common.cache.IHRAppCache;
import kd.hr.hbp.common.util.HRArrayUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class WtcFormulaConfigFormPlugin
extends AbstractHDTCFormPlugin
implements BeforeF7SelectListener {
    private final IWtcFormulaConfigDomainService wtcFormulaConfigDomainService = (IWtcFormulaConfigDomainService)ServiceFactory.getService(IWtcFormulaConfigDomainService.class);
    private static final String RETRIEVAL_DATA_CACHE_KEY = "hrbm:RetrievalData";
    private static final String RETRIEVAL_DATA_CACHE_COIN = "hrbm:RetrievalData_COIN";
    private static final String DELETE_ENTRY = "deleteentry";
    private static final String SAVE_AND_EFFECT = "saveandeffect";
    private static final String REFRESH_CACHE = "refreshcache";

    public void afterCreateNewData(EventObject eventObject) {
        this.getRetrievalDataFromCache();
        this.handleEntityField();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit edit = (BasedataEdit)this.getControl("prop");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs propertyChangedArgs) {
        String propertyKey = propertyChangedArgs.getProperty().getName();
        if ("prop".equals(propertyKey)) {
            int index = propertyChangedArgs.getChangeSet()[0].getRowIndex();
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index);
            DynamicObject prop = entryRowEntity.getDynamicObject("prop");
            if (prop != null) {
                this.getModel().setValue("alias", (Object)prop.getLocaleString("name"), index);
            } else {
                this.getModel().setValue("alias", null, index);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate formOperate = (FormOperate)args.getSource();
        String operateKey = formOperate.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)DELETE_ENTRY)) {
            int index = this.getModel().getEntryCurrentRowIndex("entryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index);
            String cusStatus = entryRowEntity.getString("cusstatus");
            long id = entryRowEntity.getLong("id");
            if (StringUtils.equals((String)cusStatus, (String)"1") && this.wtcFormulaConfigDomainService.validateItemExist(entryRowEntity.getString("number"))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u6570\u636e\u5728\u53d6\u6570\u9879\u76ee\u4e2d\u4ecd\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"WtcFormulaConfigFormPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            this.wtcFormulaConfigDomainService.deleteEntryRowEntity(id);
            if (id != 0L) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"WtcFormulaConfigFormPlugin_3", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            }
        } else if (StringUtils.equals((String)operateKey, (String)SAVE_AND_EFFECT)) {
            DynamicObjectCollection configCollection = this.getModel().getEntryEntity("entryentity");
            if (CollectionUtils.isEmpty((Collection)configCollection)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ef\u751f\u6548\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WtcFormulaConfigFormPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            long validCount = configCollection.stream().filter(data -> !StringUtils.equals((String)data.getString("cusstatus"), (String)"1")).count();
            if (validCount <= 0L) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u53ef\u751f\u6548\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"WtcFormulaConfigFormPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
        }
        args.getSource();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (HRStringUtils.equals((String)operateKey, (String)REFRESH_CACHE) && args.getOperationResult().isSuccess()) {
            this.refreshRetrievalDataCache();
        } else if (HRStringUtils.equals((String)operateKey, (String)SAVE_AND_EFFECT) && args.getOperationResult().isSuccess()) {
            DynamicObjectCollection entityList = this.getModel().getEntryEntity("entryentity");
            List configList = this.wtcFormulaConfigDomainService.saveWtcFormulaConfigData(entityList);
            String msg = this.wtcFormulaConfigDomainService.syncToWtcFormulaConfig(configList, entityList);
            if (StringUtils.isNotEmpty((String)msg)) {
                args.getOperationResult().setSuccess(false);
                args.getOperationResult().setMessage(msg);
            } else {
                args.getOperationResult().setSuccess(true);
                args.getOperationResult().setMessage(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"WtcFormulaConfigFormPlugin_2", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
                this.handleEntityField();
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.getSource();
        String sourceName = Optional.ofNullable(beforeF7SelectEvent).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"prop")) {
            beforeF7SelectEvent.getFormShowParameter().setFormId("hrbm_bizmodeltreef7");
            QFilter validFilter = new QFilter("cusstatus", "=", (Object)"1");
            validFilter.and(new QFilter("deleted", "=", (Object)"0"));
            QFilter cloudFilter = new QFilter("number", "in", (Object)ImmutableList.of((Object)"HR"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("cloud_filter", (Object)cloudFilter.toSerializedString());
            QFilter appFilter = new QFilter("number", "in", (Object)ImmutableList.of((Object)"hspm"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("app_filter", (Object)appFilter.toSerializedString());
            QFilter bizObjFilter = new QFilter("number", "in", (Object)ImmutableList.of((Object)"hrpi_person"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("biz_obj_filter", (Object)bizObjFilter.toSerializedString());
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("isOpenAll", (Object)true);
            beforeF7SelectEvent.addCustomQFilter(validFilter);
        }
    }

    private void handleEntityField() {
        this.getModel().deleteEntryData("entryentity");
        Object[] configs = this.wtcFormulaConfigDomainService.getWtcFormulaConfigDataArr(Boolean.TRUE);
        if (HRArrayUtils.isNotEmpty((Object[])configs)) {
            IDataModel model = this.getModel();
            int[] rowIndexArr = model.batchCreateNewEntryRow("entryentity", configs.length);
            for (int index = 0; index < rowIndexArr.length; ++index) {
                Object config = configs[index];
                int changeIndex = rowIndexArr[index];
                model.setValue("id", config.get("id"), changeIndex);
                model.setValue("number", config.get("number"), changeIndex);
                model.setValue("prop", config.get("prop"), changeIndex);
                model.setValue("alias", config.get("alias"), changeIndex);
                model.setValue("wtcfmlgroup", config.get("wtcfmlgroup"), changeIndex);
                model.setValue("wtcfmlrule", config.get("wtcfmlrule"), changeIndex);
                model.setValue("cusstatus", config.get("cusstatus"), changeIndex);
                String cusStatus = config.getString("cusstatus");
                if (!StringUtils.equals((String)"1", (String)cusStatus)) continue;
                this.getView().setEnable(Boolean.FALSE, changeIndex, new String[]{"prop", "alias", "wtcfmlgroup", "wtcfmlrule", "cusstatus"});
            }
        }
    }

    private void getRetrievalDataFromCache() {
        IHRAppCache ihrAppCache = HRAppCache.get((String)RETRIEVAL_DATA_CACHE_KEY);
        Boolean cache = (Boolean)ihrAppCache.get(RETRIEVAL_DATA_CACHE_COIN, Boolean.class);
        if (cache == null || !cache.booleanValue()) {
            this.refreshRetrievalDataCache();
        }
    }

    private void refreshRetrievalDataCache() {
        IHRAppCache ihrAppCache = HRAppCache.get((String)RETRIEVAL_DATA_CACHE_KEY);
        boolean groupResult = this.wtcFormulaConfigDomainService.getAndRefreshRetrievalGroup();
        boolean ruleResult = this.wtcFormulaConfigDomainService.getAndRefreshRetrievalRule();
        if (groupResult && ruleResult) {
            ihrAppCache.put(RETRIEVAL_DATA_CACHE_COIN, (Object)Boolean.TRUE);
        }
    }
}

