/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.handler;

import java.util.Map;
import java.util.function.Function;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.IExtCaseDomainService;
import kd.hdtc.hrbm.business.domain.extcase.entity.IExtCaseEntityService;
import kd.hdtc.hrbm.business.domain.extcase.impl.ExtCaseDomainServiceImpl;
import kd.hdtc.hrbm.business.domain.model.IBizModelDataDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.common.msgEnum.BizModelMsgEnum;
import kd.hdtc.hrdbs.business.entity.IBaseCommonDomainService;
import kd.hdtc.hrdbs.common.util.HDTCArrayUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;

public class BizModelJumpPageHandler {
    private static final Log LOG = LogFactory.getLog(ExtCaseDomainServiceImpl.class);
    private final IExtCaseDomainService extCaseDomainService = (IExtCaseDomainService)ServiceFactory.getService(IExtCaseDomainService.class);
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private IExtCaseEntityService extCaseEntityService = (IExtCaseEntityService)ServiceFactory.getService(IExtCaseEntityService.class);
    private final IBizModelDataDomainService bizModelDataDomainService = (IBizModelDataDomainService)ServiceFactory.getService(IBizModelDataDomainService.class);
    private final IBaseCommonDomainService baseCommonDomainServiceImpl = (IBaseCommonDomainService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBaseCommonDomainService.class);
    private static BizModelJumpPageHandler handler;

    private BizModelJumpPageHandler() {
    }

    public static BizModelJumpPageHandler getHandler() {
        if (handler == null) {
            handler = new BizModelJumpPageHandler();
        }
        return handler;
    }

    public FormShowParameter getQuestPageParam(String formId, Map<String, String> params, CloseCallBack callBack) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setHasRight(false);
        formShowParameter.getCustomParams().putAll(params);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setFormId(formId);
        if (callBack != null) {
            formShowParameter.setCloseCallBack(callBack);
        }
        return formShowParameter;
    }

    public void showAddEntityMetadataF7(IFormView view, Long logicEntityId, CloseCallBack callBack) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_listf7");
        listShowParameter.setBillFormId("bos_entityobject");
        listShowParameter.setCaption(BizModelMsgEnum.ADD_ENTITY_METADATA_F7_TITLE.get());
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        OpenStyle style = new OpenStyle();
        StyleCss css = new StyleCss();
        style.setShowType(ShowType.Modal);
        css.setWidth("900px");
        css.setHeight("600px");
        style.setInlineStyleCss(css);
        listShowParameter.setCloseCallBack(callBack);
        listShowParameter.setOpenStyle(style);
        listShowParameter.setLookUp(true);
        listShowParameter.setMultiSelect(false);
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setQFilters(this.logicEntityDomainService.getAddEntityMetadataF7QFilter(logicEntityId));
        listShowParameter.setListFilterParameter(listFilterParameter);
        view.showForm((FormShowParameter)listShowParameter);
    }

    public ListShowParameter getLogicEntityViewParam(String entityNumber, CloseCallBack callBack, Function<ListShowParameter, ListShowParameter> func) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        listShowParameter.setFormId("hrbm_boslist");
        listShowParameter.setBillFormId(entityNumber);
        StyleCss cssValue = new StyleCss();
        cssValue.setWidth("1000px");
        cssValue.setHeight("580px");
        listShowParameter.getOpenStyle().setInlineStyleCss(cssValue);
        listShowParameter.setLookUp(false);
        listShowParameter.setShowTitle(true);
        listShowParameter.setCloseCallBack(callBack);
        listShowParameter.getPageId();
        listShowParameter.setCustomParam("isExport", (Object)true);
        listShowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        if (func != null) {
            func.apply(listShowParameter);
        }
        return listShowParameter;
    }

    public FormShowParameter getAddPersonInfoPageParam(DynamicObject curLogicEntity) {
        if (curLogicEntity == null) {
            return null;
        }
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("hrbm_addpersoninfo");
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("number", (Object)curLogicEntity.getString("number"));
        formShowParameter.setCustomParam("id", curLogicEntity.get("id"));
        return formShowParameter;
    }

    public FormShowParameter getMatchPageParamByType(Long bizModelId, BizModelTypeEnum bizModelType, Function<? super FormShowParameter, ? super FormShowParameter> func) {
        if (bizModelType == null || bizModelId == null) {
            LOG.info("ExtCaseDomainServiceImpl.getMatchPageParamByType() bizModelDataBean is illegal");
            throw new HRBMBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6269\u5c55\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ExtCaseDomainServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        }
        BizModelDataBean bizModelDataBean = this.bizModelDataDomainService.getBizModelInfoById(bizModelType, (Object)bizModelId);
        if (bizModelDataBean == null || bizModelDataBean.getBizModel() == null) {
            LOG.info("ExtCaseDomainServiceImpl.getMatchPageParamByType() bizModelDataBean is illegal");
            throw new HRBMBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6269\u5c55\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ExtCaseDomainServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        }
        boolean isCurrentIsv = true;
        if (bizModelType == BizModelTypeEnum.LOGIC_ENTITY) {
            String isv = bizModelDataBean.getBizModel().getString("isv");
            isCurrentIsv = IsvUtils.isCurrentIsv((String)isv);
        }
        DynamicObject extCaseDy = this.extCaseDomainService.getMatchedExtCase(bizModelDataBean, isCurrentIsv);
        return this.dealShowPageParam(extCaseDy, func);
    }

    public FormShowParameter getParamByExtCase(Long extCaseId, Function<? super FormShowParameter, ? super FormShowParameter> func) {
        DynamicObject extCase = this.extCaseEntityService.queryOriginalOne(String.join((CharSequence)",", "casepage", "type", "id"), (Object)extCaseId);
        if (extCase == null) {
            LOG.info("ExtCaseDomainServiceImpl.getMatchPageParamByType() bizModelDataBean is illegal");
            throw new HRBMBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6269\u5c55\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ExtCaseDomainServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        }
        return this.dealShowPageParam(extCase, func);
    }

    private FormShowParameter dealShowPageParam(DynamicObject extCase, Function<? super FormShowParameter, ? super FormShowParameter> func) {
        Object[] entityObjArr;
        String matchedPage = extCase.getString("casepage");
        if (StringUtils.equals((String)extCase.getString("type"), (String)"10")) {
            matchedPage = "hrbm_logicentity_display";
        }
        if (HDTCArrayUtils.isEmpty((Object[])(entityObjArr = this.baseCommonDomainServiceImpl.queryByFilter("bos_formmeta", "id,number,modeltype", new QFilter[]{new QFilter("number", "=", (Object)matchedPage)})))) {
            LOG.info("ExtCaseDomainServiceImpl query entity is null");
            throw new HRBMBizException(ResManager.loadKDString((String)"\u672a\u5339\u914d\u5230\u6269\u5c55\u573a\u666f\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"ExtCaseDomainServiceImpl_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        }
        Object entityObj = entityObjArr[0];
        String pageType = entityObj.getString("modeltype");
        Object showParameter = StringUtils.equals((String)"BillFormModel", (String)pageType) ? new BillShowParameter() : (StringUtils.equals((String)"BaseFormModel", (String)pageType) ? new BaseShowParameter() : (StringUtils.equals((String)"QueryListModel", (String)pageType) ? new ListShowParameter() : new FormShowParameter()));
        showParameter.setFormId(matchedPage);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("logicentity_extCaseKey", (Object)extCase.getString("id"));
        showParameter.setHasRight(false);
        if (func != null) {
            func.apply((FormShowParameter)showParameter);
        }
        return showParameter;
    }

    public FormShowParameter getCardTabShowPagePram(String sceneCardConfigId, String bizModelType, String bizObjId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("hrbm_allextcaseop");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(false);
        showParameter.setCustomParam("bizobj", (Object)bizObjId);
        showParameter.setCustomParam("id", (Object)bizObjId);
        showParameter.setCustomParam("mainCardId", (Object)sceneCardConfigId);
        showParameter.setCustomParam("bizmodeltype", (Object)bizModelType);
        showParameter.setCustomParam("bizmodel", (Object)bizObjId);
        return showParameter;
    }
}

