/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.handler;

import java.util.ArrayList;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.devportal.util.DevportalUtil;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IBizModelRecordDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.IEntityCardEntityService;
import kd.hdtc.hrbm.business.domain.task.bo.BizModelRecordBo;
import kd.hdtc.hrbm.business.domain.task.bo.DataResultBo;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IBizUnitEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.bo.MetadataBo;
import kd.hdtc.hrdbs.business.entity.CommonEntityServiceFactory;
import kd.hdtc.hrdbs.business.entity.IBaseEntityService;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;

public class LogicViewHandler {
    private final IEntityCardEntityService entityCardEntityService = (IEntityCardEntityService)ServiceFactory.getService(IEntityCardEntityService.class);
    private final IBizUnitEntityService bizUnitEntityService = (IBizUnitEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBizUnitEntityService.class);
    private final IDynamicMetadataApplicationService metadataService = (IDynamicMetadataApplicationService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private final IMetadataEntityService metadataEntityService = (IMetadataEntityService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IMetadataEntityService.class);
    private final IBaseEntityService iBaseEntityService = CommonEntityServiceFactory.getEntityService((String)"bos_formmeta");
    private final IBizModelRecordDomainService bizModelRecordDomainService = (IBizModelRecordDomainService)ServiceFactory.getService(IBizModelRecordDomainService.class);
    private static final String MATE_NUMBER = "metanumber";

    public void openLogicViewPage(IFormView view, Object entityCardId) {
        DynamicObject dynamicObject = this.entityCardEntityService.query("id,metanumber", entityCardId);
        if (dynamicObject != null) {
            String metaNumber = dynamicObject.getString(MATE_NUMBER);
            DynamicObject metaDy = this.iBaseEntityService.queryOne("id,number,isv", new QFilter[]{new QFilter("number", "=", (Object)metaNumber)});
            if (metaDy == null) {
                return;
            }
            String entityId = metaDy.getString("id");
            if (IsvUtils.isNotCurrentIsv((String)metaDy.getString("isv"))) {
                entityId = this.getExtEntityId(metaNumber, dynamicObject.getLong("id"), entityId);
            }
            DevportalUtil.gotoPageDesinger((IFormView)view, (String)entityId, (String)"bos_devportal_bizpagelist");
        }
    }

    private String getExtEntityId(String metaNumber, Long logicEntityId, String metaId) {
        Optional isvMetadataBoOptional = this.metadataEntityService.getIsvMetadataBo(metaId);
        if (isvMetadataBoOptional.isPresent()) {
            return ((MetadataBo)isvMetadataBoOptional.get()).getId();
        }
        MetadataGenResult result = this.metadataService.generate(this.buildExtParam(metaNumber));
        if (!result.isSuccess()) {
            throw new KDBizException("generateExt error");
        }
        DataResultBo dataResultBo = new DataResultBo();
        dataResultBo.addMetadataResultBo(result.getEntityNumber(), result.getEntityId(), result.getVersionNumber());
        this.bizModelRecordDomainService.saveBizModelRecord(this.buildBizModelRecordBo(logicEntityId, dataResultBo));
        return result.getEntityId();
    }

    private MetadataGenParam buildExtParam(String metaNumber) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)metaNumber);
        String extMetaName = mainType.getDisplayName().getLocaleValue();
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        metadataGenParam.setFieldParamList(new ArrayList());
        baseParam.setMetadataNumber(metaNumber);
        baseParam.setMetadataName(extMetaName);
        baseParam.setType(MetadataGenTypeEnum.EXTEND_METADATA);
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)metaNumber);
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        baseParam.setBizUnitId((String)this.bizUnitEntityService.getMetadataBizUnit(formMetadata.getEntityId(), formMetadata.getBizappId()).orElse(null));
        baseParam.setAppId(mainType.getAppId());
        return metadataGenParam;
    }

    private BizModelRecordBo buildBizModelRecordBo(Long logicEntityId, DataResultBo dataResultBo) {
        BizModelRecordBo bizModelRecordBo = new BizModelRecordBo();
        bizModelRecordBo.setBizModelId(logicEntityId.longValue());
        bizModelRecordBo.setBaseDatatype("hrbm_logicentity");
        bizModelRecordBo.setDataResultBo(dataResultBo);
        return bizModelRecordBo;
    }
}

