/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.handler;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.FormShowParameter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.IBizModelDataDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.formplugin.web.handler.common.ISceneCardShowParameterHandler;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;

public class PersonTranChgShowParameterHandler
implements ISceneCardShowParameterHandler {
    private IBizModelDataDomainService bizModelDataDomainService = (IBizModelDataDomainService)ServiceFactory.getService(IBizModelDataDomainService.class);
    private static final String L4_NUMBER = "l4Number";
    private static final String HOM_ON_BRD_INFO = "hom_onbrdbilltpl";

    @Override
    public void dealParameter(FormShowParameter parameter) {
        String bizModelType = (String)parameter.getCustomParam("bizmodeltype");
        Long bizModelId = (Long)parameter.getCustomParam("bizmodel");
        if (StringUtils.isEmpty((String)bizModelType) || bizModelId == null || bizModelId == 0L) {
            return;
        }
        BizModelTypeEnum bizModelTypeEnum = BizModelTypeEnum.getBizModelTypeByLevel((int)Integer.parseInt(bizModelType));
        if (bizModelTypeEnum != BizModelTypeEnum.LOGIC_ENTITY) {
            return;
        }
        BizModelDataBean bizModelDataBean = this.bizModelDataDomainService.getBizModelInfoById(bizModelTypeEnum, (Object)bizModelId);
        if (bizModelDataBean == null) {
            return;
        }
        DynamicObject bizModel = bizModelDataBean.getBizModel();
        if (bizModel == null) {
            return;
        }
        String l4Number = this.getL4Number(bizModel);
        parameter.setCustomParam(L4_NUMBER, (Object)l4Number);
    }

    private String getL4Number(DynamicObject bizModel) {
        String bizObjNumber = bizModel.getString("bizobj.number");
        if (StringUtils.equals((String)"hcf_candidate", (String)bizObjNumber)) {
            return HOM_ON_BRD_INFO;
        }
        DynamicObject logicEntity = HRObjectUtils.isEmpty((Object)bizModel.getDynamicObject("pid")) ? bizModel : bizModel.getDynamicObject("pid");
        String l4Number = logicEntity.getString("extmetanum");
        if (StringUtils.isEmpty((String)l4Number)) {
            l4Number = bizModel.getString("number");
        }
        return l4Number;
    }
}

