/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.bd.pojo.CtrlStrategyEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityRelEntityService;
import kd.hdtc.hrdbs.business.entity.IBaseCommonDomainService;
import kd.hdtc.hrdbs.common.constants.AppConstants;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hr.expt.common.plugin.AfterQueryDataEventArgs;
import kd.hr.expt.common.plugin.BeforeCreateHeaderColumnEventArgs;
import kd.hr.expt.common.plugin.BeforeWriteDataEventArgs;
import kd.hr.expt.common.plugin.HRExportPlugin;

public class BasicModelExportPlugin
implements HRExportPlugin {
    private static final Log logger = LogFactory.getLog(BasicModelExportPlugin.class);
    private final ILogicEntityDomainService iLogicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.createInstance(ILogicEntityDomainService.class);
    private final ILogicEntityRelEntityService iLogicEntityRelEntityService = (ILogicEntityRelEntityService)ServiceFactory.createInstance(ILogicEntityRelEntityService.class);
    private static final String BASIC_MODEL_AND_APP_KEY = "BASIC_MODEL_AND_APP_KEY";
    Map<String, String> CUSTOM_FIELD_AND_FIELD_MAP = ImmutableMap.of((Object)"namevalue", (Object)"name", (Object)"numbervalue", (Object)"number", (Object)"enablevalue", (Object)"enable", (Object)"createorg", (Object)"createorg", (Object)"ctrlstrategy", (Object)"ctrlstrategy");
    private final String ENABLED_STR = ResManager.loadKDString((String)"\u542f\u7528", (String)"BasicModelExportPlugin_6", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);
    private final String DISABLED_STR = ResManager.loadKDString((String)"\u7981\u7528", (String)"BasicModelExportPlugin_7", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);
    private final Map<String, String> BASIC_MODEL_ADD_FIELD_AND_FIELD_NAME_MAP = ImmutableMap.of((Object)"basicname", (Object)ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"BasicModelExportPlugin_0", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"numbervalue", (Object)ResManager.loadKDString((String)"\u7f16\u7801", (String)"BasicModelExportPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"namevalue", (Object)ResManager.loadKDString((String)"\u540d\u79f0", (String)"BasicModelExportPlugin_2", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"enablevalue", (Object)ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001", (String)"BasicModelExportPlugin_3", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"createorg", (Object)ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"BasicModelExportPlugin_4", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), (Object)"ctrlstrategy", (Object)ResManager.loadKDString((String)"\u63a7\u5236\u7b56\u7565", (String)"BasicModelExportPlugin_5", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
    protected final IBaseCommonDomainService iBaseCommonDomainService = (IBaseCommonDomainService)kd.hdtc.hrdbs.business.common.ServiceFactory.getService(IBaseCommonDomainService.class);
    private static final String CONTROL_BASIC_SELECT_PROPERTIES = "id,name,number,enable,createorg,ctrlstrategy";
    private static final String NO_CONTROL_BASIC_SELECT_PROPERTIES = "id,name,number,enable";
    private static final List<String> NO_CONTROL_BASIC_CUSTOM_FIELD_LIST = ImmutableList.of((Object)"numbervalue", (Object)"namevalue", (Object)"enablevalue");
    private static final List<String> NO_CONTROL_BASIC_FIELD_LIST = ImmutableList.of((Object)"number", (Object)"name", (Object)"enable");
    private static final List<String> CONTROL_BASIC_CUSTOM_FIELD_LIST = ImmutableList.of((Object)"numbervalue", (Object)"namevalue", (Object)"enablevalue", (Object)"createorg", (Object)"ctrlstrategy");

    public void beforeCreateHeaderColumn(BeforeCreateHeaderColumnEventArgs args) {
        super.beforeCreateHeaderColumn(args);
        List headerWriterFormatList = args.getHeaderWriterFormats();
        headerWriterFormatList.forEach(headerWriterFormat -> {
            this.iLogicEntityDomainService.handleCustomColumn(headerWriterFormat, null, this.BASIC_MODEL_ADD_FIELD_AND_FIELD_NAME_MAP);
            headerWriterFormat.getFields().remove("number");
            headerWriterFormat.getProperties().remove("number");
        });
    }

    public void afterQueryData(AfterQueryDataEventArgs afterQueryDataEventArgs) {
        List dataList = afterQueryDataEventArgs.getDataList();
        ArrayList logicEntityIdList = Lists.newArrayListWithExpectedSize((int)dataList.size());
        dataList.forEach(dy -> {
            String[] numbers = dy.getString("number").split("\\.");
            if (MetadataUtils.isExist((String)numbers[0])) {
                List fieldNumberList = MetadataUtils.getFieldNumberList((String)numbers[0]);
                HashSet allFieldNumberSet = new HashSet(fieldNumberList);
                if (allFieldNumberSet.containsAll(NO_CONTROL_BASIC_FIELD_LIST)) {
                    logicEntityIdList.add(dy.getLong("id"));
                } else {
                    logger.warn("entityNumber:{} number or name or enable field not exist", (Object)dy.getString("number"));
                }
            } else {
                logger.error("logicEntityNumber:{}, entityNumber:{} metadata not exist", (Object)dy.getString("number"), (Object)numbers[0]);
            }
        });
        afterQueryDataEventArgs.getCustomParams().put(BASIC_MODEL_AND_APP_KEY, logicEntityIdList);
    }

    public void beforeWriteData(BeforeWriteDataEventArgs beforeWriteDataEventArgs) {
        List tplDataRowList = beforeWriteDataEventArgs.getTplDataRows();
        Map tplDataRow = (Map)tplDataRowList.get(0);
        tplDataRowList.clear();
        List logicEntityIdList = (List)beforeWriteDataEventArgs.getCustomParams().get(BASIC_MODEL_AND_APP_KEY);
        Map logicEntityIdAndLogicEntityRelEntryListMap = this.iLogicEntityRelEntityService.queryLogicEntityRelEntryByLogicEntityId((Collection)logicEntityIdList);
        HashSet entityNumberSet = Sets.newHashSetWithExpectedSize((int)logicEntityIdAndLogicEntityRelEntryListMap.size());
        logicEntityIdAndLogicEntityRelEntryListMap.forEach((logicEntityId, logicEntityRelEntryList) -> logicEntityRelEntryList.forEach(logicEntityRelEntry -> {
            String fullEntityNumber = logicEntityRelEntry.getMetadataNum();
            String[] entityNumbers = fullEntityNumber.split("\\.");
            String entityNumber = entityNumbers[0];
            if (!entityNumberSet.contains(entityNumber)) {
                boolean control = MetadataUtils.checkBaseDataCtrl((String)entityNumber);
                String selectProperties = this.getSelectProperties(control);
                int pageNo = 0;
                QFilter[] qFilter = this.getQFilter(entityNumber);
                Object[] dynamicObjects = this.iBaseCommonDomainService.queryPageCollection(entityNumber, selectProperties, qFilter, pageNo, AppConstants.TEN_THOUSAND.intValue());
                while (ArrayUtils.isNotEmpty((Object[])dynamicObjects)) {
                    Stream.of(dynamicObjects).forEach(dy -> {
                        Map<Integer, Map<String, Object>> newTplDataRow = this.setValueForCustomColumn(tplDataRow, logicEntityRelEntry.getMetadataName(), control, (DynamicObject)dy);
                        tplDataRowList.add(newTplDataRow);
                    });
                    dynamicObjects = this.iBaseCommonDomainService.queryPageCollection(entityNumber, selectProperties, qFilter, ++pageNo, AppConstants.TEN_THOUSAND.intValue());
                }
                entityNumberSet.add(entityNumber);
            }
        }));
    }

    private QFilter[] getQFilter(String entityNumber) {
        boolean hisEntity = MetadataUtils.hisEntity((String)entityNumber);
        if (hisEntity) {
            return new QFilter[]{QFilterConstants.Q_CURRENTVERSION};
        }
        return new QFilter[0];
    }

    private String getSelectProperties(boolean control) {
        String selectProperties = NO_CONTROL_BASIC_SELECT_PROPERTIES;
        if (control) {
            selectProperties = CONTROL_BASIC_SELECT_PROPERTIES;
        }
        return selectProperties;
    }

    private Map<Integer, Map<String, Object>> setValueForCustomColumn(Map<Integer, Map<String, Object>> tplDataRow, String metadataName, boolean control, DynamicObject dy) {
        Map<Integer, Map<String, Object>> newTplDataRow = this.copyTplDataRow(tplDataRow);
        newTplDataRow.forEach((columnIdx, cellInfoMap) -> {
            Object customFieldKey = cellInfoMap.get("key");
            if (control) {
                if (CONTROL_BASIC_CUSTOM_FIELD_LIST.contains(customFieldKey)) {
                    this.setValue((Map<String, Object>)cellInfoMap, dy, this.CUSTOM_FIELD_AND_FIELD_MAP.get(customFieldKey));
                }
            } else if (NO_CONTROL_BASIC_CUSTOM_FIELD_LIST.contains(customFieldKey)) {
                this.setValue((Map<String, Object>)cellInfoMap, dy, this.CUSTOM_FIELD_AND_FIELD_MAP.get(customFieldKey));
            }
            if ("basicname".equals(customFieldKey)) {
                cellInfoMap.put("val", metadataName);
            }
        });
        return newTplDataRow;
    }

    private void setValue(Map<String, Object> cellInfoMap, DynamicObject dy, String fieldKey) {
        Object value = dy.get(fieldKey);
        if (value == null) {
            return;
        }
        if ("enable".equals(fieldKey)) {
            cellInfoMap.put("val", "1".equals(value) ? this.ENABLED_STR : this.DISABLED_STR);
            return;
        }
        if ("ctrlstrategy".equals(fieldKey)) {
            cellInfoMap.put("val", CtrlStrategyEnum.getEnum((String)dy.getString(fieldKey)).getDescription());
            return;
        }
        if (value instanceof OrmLocaleValue) {
            cellInfoMap.put("val", dy.getString(fieldKey));
        } else if (value instanceof DynamicObject) {
            cellInfoMap.put("val", dy.getDynamicObject(fieldKey).getString("name"));
        } else {
            cellInfoMap.put("val", value);
        }
    }

    private Map<Integer, Map<String, Object>> copyTplDataRow(Map<Integer, Map<String, Object>> tplDataRow) {
        HashMap<Integer, Map<String, Object>> newTplDataRow = new HashMap<Integer, Map<String, Object>>();
        tplDataRow.forEach((columnIdx, cellInfoMap) -> {
            HashMap newCellInfoMap = new HashMap(cellInfoMap);
            newTplDataRow.put((Integer)columnIdx, newCellInfoMap);
        });
        return newTplDataRow;
    }
}

