/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import java.security.SecureRandom;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.domain.extcase.ISceneCardConfigDomainService;
import kd.hdtc.hrbm.business.domain.extcase.bean.SceneCardConfigBean;
import kd.hdtc.hrbm.business.domain.extcase.entity.ISceneCardConfigEntityService;
import kd.hdtc.hrbm.business.domain.extcase.wtc.IWtcFormulaConfigDomainService;
import kd.hdtc.hrbm.business.domain.model.IBizModelDataDomainService;
import kd.hdtc.hrbm.business.domain.model.ILogicEntityDomainService;
import kd.hdtc.hrbm.business.domain.model.bean.BizModelDataBean;
import kd.hdtc.hrbm.common.enums.BizModelTypeEnum;
import kd.hdtc.hrbm.common.enums.SceneCardConfigEnum;
import kd.hdtc.hrbm.common.exception.HRBMBizException;
import kd.hdtc.hrbm.formplugin.web.card.BizModelCardJumpStrategyFactory;
import kd.hdtc.hrbm.formplugin.web.card.BizModelCardParamBean;
import kd.hdtc.hrbm.formplugin.web.card.IBizModelCardJumpStrategy;
import kd.hdtc.hrbm.formplugin.web.tree.BizModelTreePlugin;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.IsvUtils;
import kd.hdtc.hrdbs.common.util.JsonUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hr.hbp.common.util.HRObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelExtCaseEditPlugin
extends BizModelTreePlugin {
    private static final Log LOG = LogFactory.getLog(BizModelExtCaseEditPlugin.class);
    private final ISceneCardConfigDomainService sceneCardConfigDomainService = (ISceneCardConfigDomainService)ServiceFactory.getService(ISceneCardConfigDomainService.class);
    private final ISceneCardConfigEntityService sceneCardConfigEntityService = (ISceneCardConfigEntityService)ServiceFactory.getService(ISceneCardConfigEntityService.class);
    private final ILogicEntityDomainService logicEntityDomainService = (ILogicEntityDomainService)ServiceFactory.getService(ILogicEntityDomainService.class);
    private final IBizModelDataDomainService bizModelDataDomainService = (IBizModelDataDomainService)ServiceFactory.getService(IBizModelDataDomainService.class);
    private final IWtcFormulaConfigDomainService wtcFormulaConfigDomainService = (IWtcFormulaConfigDomainService)ServiceFactory.getService(IWtcFormulaConfigDomainService.class);
    private static final String RANDOM = "random";
    private static final String SHOW_DATA = "showData";
    private static final String COIN_TYPE = "coinType";
    private static final String CONTENT_ID = "contentId";
    private static final String ENTITY = "entity";

    @Override
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initControlAp();
    }

    @Override
    public void treeNodeClick(TreeNodeEvent evt) {
        super.treeNodeClick(evt);
        this.initControlAp();
    }

    public void customEvent(CustomEventArgs event) {
        String eventName;
        if (!PermissionServiceHelper.hasSpecificPerm((long)RequestContext.get().getCurrUserId(), (String)"hrbm", (String)"hrbm_bmmanagement", (String)"4715a0df000000ac")) {
            throw new HRBMBizException(ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u4e1a\u52a1\u6a21\u578b\u7ba1\u7406\u7684\u4fee\u6539\u6743\u9650\u3002", (String)"BizModelExtCaseEditPlugin_0", (String)"hdtc-hrbm-business", (Object[])new Object[0]));
        }
        switch (eventName = event.getEventName()) {
            case "clickCardHandle": {
                this.clickCardHandle(event);
                break;
            }
        }
    }

    @Override
    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        String sceneCardConfigId = (String)returnData.get("sceneCardconfigid");
        if (HRStringUtils.isNotEmpty((String)sceneCardConfigId)) {
            DynamicObject sceneCardConfig = this.sceneCardConfigEntityService.queryById(Long.valueOf(Long.parseLong(sceneCardConfigId)));
            Long logicEntityId = (Long)returnData.get("logicntityid");
            Long currentNodeId = Long.parseLong(this.getCurNodeId());
            BizModelCardParamBean bizModelCardParamBean = new BizModelCardParamBean();
            bizModelCardParamBean.setCurrentNodeId(currentNodeId);
            bizModelCardParamBean.setSceneCardConfig(sceneCardConfig);
            if (logicEntityId != null) {
                bizModelCardParamBean.setLogicEntityId(logicEntityId);
            }
            LOG.info("bizModelAllLineLog about BizModelExtCaseEditPlugin.closedCallBack(): logicEntityId:{},currentNodeId:{}, sceneCardConfigNumber:{}", new Object[]{logicEntityId, currentNodeId, sceneCardConfig.getString("number")});
            bizModelCardParamBean.setBizModelDataBean(this.getBizModelDataBean(logicEntityId, currentNodeId));
            IBizModelCardJumpStrategy generate = BizModelCardJumpStrategyFactory.generate(bizModelCardParamBean);
            if (generate.getReturnActionId().equals(closedCallBackEvent.getActionId())) {
                DynamicObject extCase = this.getExtCase(logicEntityId, sceneCardConfig);
                bizModelCardParamBean.setExtCase(extCase);
                generate.handleCloseCallBack(this.getView(), returnData);
            }
        }
    }

    private DynamicObject getExtCase(Long logicEntityId, DynamicObject sceneCardConfig) {
        if (!HRObjectUtils.isEmpty((Object)sceneCardConfig)) {
            DynamicObjectCollection containCaseCollection = sceneCardConfig.getDynamicObjectCollection("containcase");
            if (CollectionUtils.isEmpty((Collection)containCaseCollection)) {
                return null;
            }
            if (containCaseCollection.size() == 1) {
                return ((DynamicObject)containCaseCollection.get(0)).getDynamicObject("fbasedataid");
            }
            DynamicObject logicEntityInfo = this.logicEntityDomainService.getLogicEntityInfoById((Object)logicEntityId);
            if (HRObjectUtils.isEmpty((Object)logicEntityInfo)) {
                return null;
            }
            List extCaseList = containCaseCollection.stream().filter(containCase -> IsvUtils.isCurrentIsv((String)logicEntityInfo.getString("isv")) == containCase.getDynamicObject("fbasedataid").getBoolean("currentisv")).map(extCase -> extCase.getDynamicObject("fbasedataid")).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(extCaseList)) {
                return (DynamicObject)extCaseList.get(0);
            }
        }
        return null;
    }

    private void clickCardHandle(CustomEventArgs event) {
        String eventArgs = event.getEventArgs();
        Map params = (Map)JsonUtils.castType((String)eventArgs, Map.class);
        String sceneCardConfigId = String.valueOf(params.get("id"));
        if (StringUtils.isEmpty((String)sceneCardConfigId)) {
            LOG.info("bizModelAllLineLog about BizModelExtCaseEditPlugin.clickCardHandle(): sceneCardConfigId isEmpty return");
            return;
        }
        DynamicObject sceneCardConfig = this.sceneCardConfigEntityService.queryById(Long.valueOf(Long.parseLong(sceneCardConfigId)));
        if (sceneCardConfig == null) {
            LOG.info("bizModelAllLineLog about BizModelExtCaseEditPlugin.clickCardHandle(): sceneCardConfig isNull return");
            return;
        }
        if ((SceneCardConfigEnum.WTC_RULE.getStrId().equals(sceneCardConfigId) || "2011775336349588480".equals(sceneCardConfigId)) && !this.wtcFormulaConfigDomainService.isRetrievalOpen().booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6b64\u529f\u80fd\u6682\u672a\u5f00\u653e\uff0c\u656c\u8bf7\u671f\u5f85\u3002", (String)"BizModelExtCaseEditPlugin_1", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]));
            return;
        }
        Long curNodeId = Long.valueOf(this.getCurNodeId());
        BizModelCardParamBean bizModelCardParamBean = new BizModelCardParamBean();
        bizModelCardParamBean.setCurrentNodeId(curNodeId);
        bizModelCardParamBean.setSceneCardConfig(sceneCardConfig);
        BizModelTypeEnum curNodeType = this.getCurNodeType();
        bizModelCardParamBean.setBizModelDataBean(this.bizModelDataDomainService.getBizModelInfoById(curNodeType, (Object)curNodeId));
        LOG.info("bizModelAllLineLog about BizModelExtCaseEditPlugin.clickCardHandle(): currentNodeId:{}, sceneCardConfigNumber:{}, bizModelType:{}", new Object[]{curNodeId, sceneCardConfig.getString("number"), curNodeType.getType()});
        IBizModelCardJumpStrategy generate = BizModelCardJumpStrategyFactory.generate(bizModelCardParamBean);
        FormShowParameter formShowParameter = generate.handleJumpFormShowParameter((IFormPlugin)this);
        this.getView().showForm(formShowParameter);
    }

    private BizModelDataBean getBizModelDataBean(Long logicEntityId, Long bizModelId) {
        BizModelDataBean bizModelDataBean;
        if (logicEntityId != null && logicEntityId != 0L) {
            DynamicObject bizModel = this.logicEntityDomainService.getLogicEntityInfoById((Object)logicEntityId);
            bizModelDataBean = new BizModelDataBean(BizModelTypeEnum.LOGIC_ENTITY, bizModel);
        } else {
            bizModelDataBean = this.bizModelDataDomainService.getBizModelInfoById(this.getCurNodeType(), (Object)bizModelId);
        }
        return bizModelDataBean;
    }

    private void initControlAp(String classModel, String controlAp, String coinType) {
        List showDataList = this.sceneCardConfigDomainService.getMatchedSceneCardConfigList(Long.valueOf(Long.parseLong(this.getCurNodeId())), this.getCurNodeType(), classModel);
        this.renderCustomApData(controlAp, coinType, showDataList);
    }

    private void renderCustomApData(String apId, String coinType, List<SceneCardConfigBean> showDataList) {
        CustomControl customcontrol = (CustomControl)this.getView().getControl(apId);
        if (customcontrol == null) {
            return;
        }
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        result.put(RANDOM, new SecureRandom().nextInt(10000000));
        result.put(SHOW_DATA, showDataList);
        result.put(CONTENT_ID, apId);
        if (StringUtils.isNotEmpty((String)coinType)) {
            result.put(COIN_TYPE, ENTITY);
        }
        customcontrol.setData(result);
        this.getView().updateView(apId);
    }

    private void initControlAp() {
        this.initControlAp("1010", "modelcustomcontrolap", null);
        this.initControlAp("1020", "viewcustomcontrolap", ENTITY);
        this.initControlAp("1030", "funccustomcontrolap", null);
        this.initControlAp("1040", "relmodelcustomcontrolap", null);
    }
}

