/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrbm.formplugin.web.logicentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.hdtc.hrbm.business.common.ServiceFactory;
import kd.hdtc.hrbm.business.common.util.PropUtils;
import kd.hdtc.hrbm.business.domain.model.IPropDomainService;
import kd.hdtc.hrbm.business.domain.model.entity.ILogicEntityEntityService;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.formplugin.web.AbstractHDTCFormPlugin;
import kd.hr.hbp.common.util.HRStringUtils;

public class ImportPersonPropEditPlugin
extends AbstractHDTCFormPlugin
implements BeforeF7SelectListener {
    private final ILogicEntityEntityService logicEntityEntityService = (ILogicEntityEntityService)ServiceFactory.getService(ILogicEntityEntityService.class);
    private final IPropDomainService propDomainService = (IPropDomainService)ServiceFactory.getService(IPropDomainService.class);
    private static final Log LOG = LogFactory.getLog(ImportPersonPropEditPlugin.class);

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
    }

    public void registerListener(EventObject eventObject) {
        super.registerListener(eventObject);
        BasedataEdit edit = (BasedataEdit)this.getControl("name");
        edit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void propertyChanged(PropertyChangedArgs args) {
        String propertyKey = args.getProperty().getName();
        int index = args.getChangeSet()[0].getRowIndex();
        DynamicObjectCollection entryCol = this.getModel().getEntryEntity("entryentity");
        if ("name".equals(propertyKey)) {
            this.getModel().deleteEntryData("previewentryentity");
            entryCol.stream().filter(e -> e.get("name") != null).forEach(e -> {
                int row = this.getModel().createNewEntryRow("previewentryentity");
                this.handleEntityField(e.getDynamicObject("name"), e.getString("fieldusage"), row);
                this.getModel().setValue("prop", e.get("name"), row);
            });
        } else if ("fieldusage".equals(propertyKey)) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", index);
            if (entryRowEntity.getDynamicObject("name") == null) {
                return;
            }
            DynamicObjectCollection previewEntryEntityCol = this.getModel().getEntryEntity("previewentryentity");
            for (int i = 0; i < previewEntryEntityCol.size(); ++i) {
                if (((DynamicObject)previewEntryEntityCol.get(i)).getLong("prop.id") != entryRowEntity.getDynamicObject("name").getLong("id")) continue;
                this.handleEntityField(entryRowEntity.getDynamicObject("name"), entryRowEntity.getString("fieldusage"), i);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String operateKey = op.getOperateKey();
        if (StringUtils.equals((String)operateKey, (String)"deleteentry")) {
            EntryGrid entryGrid = (EntryGrid)this.getView().getControl("entryentity");
            int[] selectRows = entryGrid.getSelectRows();
            ArrayList<Long> propIdList = new ArrayList<Long>(selectRows.length);
            ArrayList<Integer> deleteRowList = new ArrayList<Integer>(selectRows.length);
            for (int i = 0; i < selectRows.length; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entryentity", selectRows[i]);
                if (entryRowEntity == null) continue;
                propIdList.add(entryRowEntity.getLong("name.id"));
            }
            DynamicObjectCollection previewEntryEntity = this.getModel().getEntryEntity("previewentryentity");
            for (int i = 0; i < previewEntryEntity.size(); ++i) {
                long propId = ((DynamicObject)previewEntryEntity.get(i)).getLong("prop.id");
                if (!propIdList.contains(propId)) continue;
                deleteRowList.add(i);
            }
            this.getModel().deleteEntryRows("previewentryentity", deleteRowList.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    private void handleEntityField(DynamicObject prop, String fieldUsage, int row) {
        switch (fieldUsage) {
            case "2": {
                this.getModel().setValue("beforeprop", (Object)prop, row);
                this.getModel().setValue("afterprop", (Object)prop, row);
                break;
            }
            case "1": {
                this.getModel().setValue("afterprop", (Object)prop, row);
                this.getModel().setValue("beforeprop", null, row);
                break;
            }
            case "0": {
                this.getModel().setValue("beforeprop", (Object)prop, row);
                this.getModel().setValue("afterprop", null, row);
                break;
            }
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key) && !this.checkReferenceProp().booleanValue()) {
            this.returnData();
        }
    }

    private Boolean checkReferenceProp() {
        DynamicObjectCollection entryEntityCol = this.getModel().getEntryEntity("entryentity");
        List propIdList = entryEntityCol.stream().filter(it -> it.getLong("name.id") != 0L && !"0".equals(it.getString("fieldusage"))).map(it -> it.getLong("name.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(propIdList)) {
            return Boolean.FALSE;
        }
        String logicEntityNumber = this.getView().getParentView().getModel().getDataEntity().getString("number");
        DynamicObject logicEntity = this.logicEntityEntityService.queryOne("id", new QFilter[]{new QFilter("number", "=", (Object)logicEntityNumber)});
        if (logicEntity == null) {
            return Boolean.FALSE;
        }
        List targetPropIdList = this.propDomainService.getTargetPropIdList(Long.valueOf(logicEntity.getLong("id")), propIdList);
        if (CollectionUtils.isEmpty((Collection)targetPropIdList)) {
            return Boolean.FALSE;
        }
        StringBuilder rowStringBuilder = new StringBuilder();
        StringBuilder propNameStringBuilder = new StringBuilder();
        for (int i = 0; i < entryEntityCol.size(); ++i) {
            Long propId = ((DynamicObject)entryEntityCol.get(i)).getLong("name.id");
            if (!targetPropIdList.contains(propId)) continue;
            rowStringBuilder.append(i + 1).append(",");
            propNameStringBuilder.append(((DynamicObject)entryEntityCol.get(i)).getLocaleString("name.name")).append(",");
        }
        if (rowStringBuilder.length() > 0 && propNameStringBuilder.length() > 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u884c\u6570\uff1a%1$s\u5bf9\u5e94\u7684\u5c5e\u6027\u540d\u79f0\uff1a%2$s\uff0c\u5df2\u88ab\u5355\u636e\u5206\u5f55\u5f15\u7528\u4e14\u56de\u5199\u4eba\u5458\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u88ab\u5b9a\u4e49\u4e3a\u9700\u56de\u5199\u81f3\u4eba\u5458\u4fe1\u606f\uff0c\u8bf7\u5220\u9664\u8be5\u5c5e\u6027\u540e\u91cd\u65b0\u64cd\u4f5c", (String)"ImportPersonPropEditPlugin_3", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]), rowStringBuilder.deleteCharAt(rowStringBuilder.length() - 1), propNameStringBuilder.deleteCharAt(propNameStringBuilder.length() - 1));
            this.getView().showMessage(msg);
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        beforeF7SelectEvent.getSource();
        String sourceName = Optional.ofNullable(beforeF7SelectEvent).map(BeforeF7SelectEvent::getProperty).map(IMetadata::getName).orElse(null);
        if (HRStringUtils.equals((String)sourceName, (String)"name")) {
            String logicEntityNumber = "";
            beforeF7SelectEvent.getFormShowParameter().setFormId("hrbm_bizmodeltreef7");
            QFilter validFilter = this.initQFilter();
            validFilter.and(new QFilter("proptype", "=", (Object)"10"));
            validFilter.and(new QFilter("name", "!=", (Object)"ID"));
            validFilter.and(PropUtils.getNoAttAndPropFieldFilter());
            if (this.getView().getParentView() != null) {
                validFilter.and(PropUtils.getIncludeFieldTypeFilter((IDataModel)this.getView().getParentView().getModel()));
                logicEntityNumber = this.getView().getParentView().getModel().getDataEntity().getString("number");
            }
            DynamicObjectCollection propEntryCollection = this.getModel().getEntryEntity("entryentity");
            List entryPropIdList = propEntryCollection.stream().map(it -> it.getLong("name.id")).collect(Collectors.toList());
            List propList = (List)this.getView().getFormShowParameter().getCustomParam("propList");
            QFilter propFilter = new QFilter("id", "not in", entryPropIdList).and("id", "not in", (Object)propList);
            validFilter.and(propFilter);
            QFilter cloudFilter = new QFilter("number", "in", (Object)ImmutableList.of((Object)"HR"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("cloud_filter", (Object)cloudFilter.toSerializedString());
            QFilter appFilter = new QFilter("number", "in", (Object)ImmutableList.of((Object)"hspm"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("app_filter", (Object)appFilter.toSerializedString());
            QFilter bizObjFilter = new QFilter("number", "in", (Object)ImmutableList.of((Object)"hrpi_person"));
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("biz_obj_filter", (Object)bizObjFilter.toSerializedString());
            LOG.info("logicEntityNumber is:{}", (Object)logicEntityNumber);
            QFilter AFilter = new QFilter("pid.number", "in", (Object)Lists.newArrayList((Object[])new String[]{"hrpi_employee", "hrpi_depemp"}));
            QFilter BFilter = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"hrpi_person", "hrpi_employee", "hrpi_depemp"}));
            if ("hom_onbrdinfo".equals(logicEntityNumber)) {
                BFilter = new QFilter("number", "in", (Object)Lists.newArrayList((Object[])new String[]{"hrpi_employee", "hrpi_depemp"}));
            }
            QFilter CFilter = new QFilter("pid.number", "=", (Object)"hrpi_person").and(new QFilter("mulline", "=", (Object)Boolean.FALSE));
            QFilter qFilter = "hom_onbrdinfo".equals(logicEntityNumber) ? AFilter.or(BFilter) : AFilter.or(BFilter).or(CFilter);
            beforeF7SelectEvent.getFormShowParameter().setCustomParam("logic_entity_filter", (Object)qFilter.toSerializedString());
            beforeF7SelectEvent.addCustomQFilter(validFilter);
            ListShowParameter listShowParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            listShowParameter.getCustomParams().put("isOpenAll", true);
            listShowParameter.getCustomParams().put("is_cache_select_node", true);
            String selectNodeId = this.getPageCache().get("selectedNodeId");
            if (StringUtils.isNotEmpty((String)selectNodeId)) {
                listShowParameter.getCustomParams().put("selectedNodeId", selectNodeId);
            }
        }
    }

    private QFilter initQFilter() {
        return new QFilter("cusstatus", "=", (Object)"1").and(new QFilter("deleted", "=", (Object)"0"));
    }

    private void returnData() {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)4);
        DynamicObjectCollection previewEntryEntity = this.getModel().getEntryEntity("previewentryentity");
        resultMap.put("beforePropList", previewEntryEntity.stream().filter(it -> it.get("beforeprop") != null).map(it -> it.getLong("beforeprop.id")).collect(Collectors.toList()));
        resultMap.put("afterPropList", previewEntryEntity.stream().filter(it -> it.get("afterprop") != null).map(it -> it.getLong("afterprop.id")).collect(Collectors.toList()));
        this.getModel().setDataChanged(false);
        this.getView().returnDataToParent((Object)resultMap);
        this.getView().close();
    }

    public void beforeClosed(BeforeClosedEvent event) {
        if (!this.getModel().getDataChanged()) {
            return;
        }
        String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ImportPersonPropEditPlugin_2", (String)"hdtc-hrbm-formplugin", (Object[])new Object[0]);
        String changeDesc = this.getModel().getChangeDesc();
        this.getModel().getDataEntity().getDataEntityState().getBizChangedProperties();
        this.getView().showConfirm(msg, changeDesc, MessageBoxOptions.OKCancel, ConfirmTypes.Save, new ConfirmCallBackListener("cancel", (IFormPlugin)this));
        event.setCancel(true);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (HRStringUtils.equals((String)callBackId, (String)"cancel") && messageBoxClosedEvent.getResult().getValue() == MessageBoxResult.Yes.getValue()) {
            this.getModel().setDataChanged(false);
            this.getView().close();
        }
    }
}

